require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASMARM_PGTABLE_H)) {
    eval 'sub _ASMARM_PGTABLE_H () {1;}' unless defined(&_ASMARM_PGTABLE_H);
    require 'linux/config.ph';
    require 'asm/memory.ph';
    require 'asm/proc-fns.ph';
    eval 'sub PMD_SHIFT () {20;}' unless defined(&PMD_SHIFT);
    eval 'sub PGDIR_SHIFT () {20;}' unless defined(&PGDIR_SHIFT);
    eval 'sub LIBRARY_TEXT_START () {0xc000000;}' unless defined(&LIBRARY_TEXT_START);
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub pte_ERROR {
	    local($pte) = @_;
    	    eval q( &__pte_error( &__FILE__,  &__LINE__,  &pte_val($pte)));
	}' unless defined(&pte_ERROR);
	eval 'sub pmd_ERROR {
	    local($pmd) = @_;
    	    eval q( &__pmd_error( &__FILE__,  &__LINE__,  &pmd_val($pmd)));
	}' unless defined(&pmd_ERROR);
	eval 'sub pgd_ERROR {
	    local($pgd) = @_;
    	    eval q( &__pgd_error( &__FILE__,  &__LINE__,  &pgd_val($pgd)));
	}' unless defined(&pgd_ERROR);
    }
    eval 'sub PMD_SIZE () {(1 <<  &PMD_SHIFT);}' unless defined(&PMD_SIZE);
    eval 'sub PMD_MASK () {(~( &PMD_SIZE-1));}' unless defined(&PMD_MASK);
    eval 'sub PGDIR_SIZE () {(1 <<  &PGDIR_SHIFT);}' unless defined(&PGDIR_SIZE);
    eval 'sub PGDIR_MASK () {(~( &PGDIR_SIZE-1));}' unless defined(&PGDIR_MASK);
    eval 'sub FIRST_USER_PGD_NR () {1;}' unless defined(&FIRST_USER_PGD_NR);
    eval 'sub USER_PTRS_PER_PGD () {(( &TASK_SIZE/ &PGDIR_SIZE) -  &FIRST_USER_PGD_NR);}' unless defined(&USER_PTRS_PER_PGD);
    eval 'sub __P000 () { &PAGE_NONE;}' unless defined(&__P000);
    eval 'sub __P001 () { &PAGE_READONLY;}' unless defined(&__P001);
    eval 'sub __P010 () { &PAGE_COPY;}' unless defined(&__P010);
    eval 'sub __P011 () { &PAGE_COPY;}' unless defined(&__P011);
    eval 'sub __P100 () { &PAGE_READONLY;}' unless defined(&__P100);
    eval 'sub __P101 () { &PAGE_READONLY;}' unless defined(&__P101);
    eval 'sub __P110 () { &PAGE_COPY;}' unless defined(&__P110);
    eval 'sub __P111 () { &PAGE_COPY;}' unless defined(&__P111);
    eval 'sub __S000 () { &PAGE_NONE;}' unless defined(&__S000);
    eval 'sub __S001 () { &PAGE_READONLY;}' unless defined(&__S001);
    eval 'sub __S010 () { &PAGE_SHARED;}' unless defined(&__S010);
    eval 'sub __S011 () { &PAGE_SHARED;}' unless defined(&__S011);
    eval 'sub __S100 () { &PAGE_READONLY;}' unless defined(&__S100);
    eval 'sub __S101 () { &PAGE_READONLY;}' unless defined(&__S101);
    eval 'sub __S110 () { &PAGE_SHARED;}' unless defined(&__S110);
    eval 'sub __S111 () { &PAGE_SHARED;}' unless defined(&__S111);
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub ZERO_PAGE {
	    local($vaddr) = @_;
    	    eval q(( &empty_zero_page));
	}' unless defined(&ZERO_PAGE);
	eval 'sub pte_pfn {
	    local($pte) = @_;
    	    eval q(( &pte_val($pte) >>  &PAGE_SHIFT));
	}' unless defined(&pte_pfn);
	eval 'sub pfn_pte {
	    local($pfn,$prot) = @_;
    	    eval q(( &__pte((($pfn) <<  &PAGE_SHIFT) |  &pgprot_val($prot))));
	}' unless defined(&pfn_pte);
	eval 'sub pte_none {
	    local($pte) = @_;
    	    eval q((! &pte_val($pte)));
	}' unless defined(&pte_none);
	eval 'sub pte_clear {
	    local($ptep) = @_;
    	    eval q( &set_pte(($ptep),  &__pte(0)));
	}' unless defined(&pte_clear);
	eval 'sub pte_page {
	    local($pte) = @_;
    	    eval q(( &pfn_to_page( &pte_pfn($pte))));
	}' unless defined(&pte_page);
	eval 'sub pmd_none {
	    local($pmd) = @_;
    	    eval q((! &pmd_val($pmd)));
	}' unless defined(&pmd_none);
	eval 'sub pmd_present {
	    local($pmd) = @_;
    	    eval q(( &pmd_val($pmd)));
	}' unless defined(&pmd_present);
	eval 'sub pmd_clear {
	    local($pmdp) = @_;
    	    eval q( &set_pmd($pmdp,  &__pmd(0)));
	}' unless defined(&pmd_clear);
	eval 'sub pages_to_mb {
	    local($x) = @_;
    	    eval q((($x) >> (20-  &PAGE_SHIFT)));
	}' unless defined(&pages_to_mb);
	eval 'sub mk_pte {
	    local($page,$prot) = @_;
    	    eval q( &pfn_pte( &page_to_pfn($page),$prot));
	}' unless defined(&mk_pte);
	eval 'sub pgd_none {
	    local($pgd) = @_;
    	    eval q((0));
	}' unless defined(&pgd_none);
	eval 'sub pgd_bad {
	    local($pgd) = @_;
    	    eval q((0));
	}' unless defined(&pgd_bad);
	eval 'sub pgd_present {
	    local($pgd) = @_;
    	    eval q((1));
	}' unless defined(&pgd_present);
	eval 'sub pgd_clear {
	    local($pgdp) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pgd_clear);
	eval 'sub page_pte_prot {
	    local($page,$prot) = @_;
    	    eval q( &mk_pte($page, $prot));
	}' unless defined(&page_pte_prot);
	eval 'sub page_pte {
	    local($page) = @_;
    	    eval q( &mk_pte($page,  &__pgprot(0)));
	}' unless defined(&page_pte);
	eval 'sub pgd_index {
	    local($addr) = @_;
    	    eval q((($addr) >>  &PGDIR_SHIFT));
	}' unless defined(&pgd_index);
	eval 'sub __pgd_offset {
	    local($addr) = @_;
    	    eval q( &pgd_index($addr));
	}' unless defined(&__pgd_offset);
	eval 'sub pgd_offset {
	    local($mm, $addr) = @_;
    	    eval q((($mm)-> &pgd+ &pgd_index($addr)));
	}' unless defined(&pgd_offset);
	eval 'sub pgd_offset_k {
	    local($addr) = @_;
    	    eval q( &pgd_offset( &init_mm, $addr));
	}' unless defined(&pgd_offset_k);
	eval 'sub pmd_offset {
	    local($dir, $addr) = @_;
    	    eval q((( &pmd_t *)($dir)));
	}' unless defined(&pmd_offset);
	eval 'sub __pte_offset {
	    local($addr) = @_;
    	    eval q(((($addr) >>  &PAGE_SHIFT) & ( &PTRS_PER_PTE - 1)));
	}' unless defined(&__pte_offset);
	eval 'sub pte_offset {
	    local($dir, $addr) = @_;
    	    eval q((( &pte_t *) &pmd_page(*($dir)) +  &__pte_offset($addr)));
	}' unless defined(&pte_offset);
	require 'asm/proc/pgtable.ph';
	eval 'sub pte_modify {
	    local($pte,$newprot) = @_;
    	    eval q({  &pte_val($pte) = ( &pte_val($pte) &  &_PAGE_CHG_MASK) |  &pgprot_val($newprot); $pte; });
	}' unless defined(&pte_modify);
	eval 'sub SWP_TYPE {
	    local($x) = @_;
    	    eval q(((($x). &val >> 2) & 0x7f));
	}' unless defined(&SWP_TYPE);
	eval 'sub SWP_OFFSET {
	    local($x) = @_;
    	    eval q((($x). &val >> 9));
	}' unless defined(&SWP_OFFSET);
	eval 'sub SWP_ENTRY {
	    local($type,$offset) = @_;
    	    eval q((( &swp_entry_t) { (($type) << 2) | (($offset) << 9) }));
	}' unless defined(&SWP_ENTRY);
	eval 'sub pte_to_swp_entry {
	    local($pte) = @_;
    	    eval q((( &swp_entry_t) {  &pte_val($pte) }));
	}' unless defined(&pte_to_swp_entry);
	eval 'sub swp_entry_to_pte {
	    local($swp) = @_;
    	    eval q((( &pte_t) { ($swp). &val }));
	}' unless defined(&swp_entry_to_pte);
	eval 'sub kern_addr_valid {
	    local($addr) = @_;
    	    eval q((1));
	}' unless defined(&kern_addr_valid);
	require 'asm-generic/pgtable.ph';
	eval 'sub io_remap_page_range {
	    local($from,$phys,$size,$prot) = @_;
    	    eval q( &remap_page_range($from,$phys,$size,$prot));
	}' unless defined(&io_remap_page_range);
    }
}
1;
