require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASMARM_PAGE_H)) {
    eval 'sub _ASMARM_PAGE_H () {1;}' unless defined(&_ASMARM_PAGE_H);
    require 'asm/proc/page.ph';
    eval 'sub PAGE_SIZE () {(1 <<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {(~( &PAGE_SIZE-1));}' unless defined(&PAGE_MASK);
    if(defined(&__KERNEL__)) {
	unless(defined(&__ASSEMBLY__)) {
	    eval 'sub STRICT_MM_TYPECHECKS () {1;}' unless defined(&STRICT_MM_TYPECHECKS);
	    eval 'sub clear_page {
	        local($page) = @_;
    		eval q( &memzero(( &void *)($page),  &PAGE_SIZE));
	    }' unless defined(&clear_page);
	    eval 'sub clear_user_page {
	        local($page, $vaddr) = @_;
    		eval q( &clear_page($page));
	    }' unless defined(&clear_user_page);
	    eval 'sub copy_user_page {
	        local($to, $from, $vaddr) = @_;
    		eval q( &copy_page($to, $from));
	    }' unless defined(&copy_user_page);
	    if(defined(&STRICT_MM_TYPECHECKS)) {
		eval 'sub pte_val {
		    local($x) = @_;
    		    eval q((($x). &pte));
		}' unless defined(&pte_val);
		eval 'sub pmd_val {
		    local($x) = @_;
    		    eval q((($x). &pmd));
		}' unless defined(&pmd_val);
		eval 'sub pgd_val {
		    local($x) = @_;
    		    eval q((($x). &pgd));
		}' unless defined(&pgd_val);
		eval 'sub pgprot_val {
		    local($x) = @_;
    		    eval q((($x). &pgprot));
		}' unless defined(&pgprot_val);
		eval 'sub __pte {
		    local($x) = @_;
    		    eval q((( &pte_t) { ($x) } ));
		}' unless defined(&__pte);
		eval 'sub __pmd {
		    local($x) = @_;
    		    eval q((( &pmd_t) { ($x) } ));
		}' unless defined(&__pmd);
		eval 'sub __pgd {
		    local($x) = @_;
    		    eval q((( &pgd_t) { ($x) } ));
		}' unless defined(&__pgd);
		eval 'sub __pgprot {
		    local($x) = @_;
    		    eval q((( &pgprot_t) { ($x) } ));
		}' unless defined(&__pgprot);
	    } else {
		eval 'sub pte_val {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&pte_val);
		eval 'sub pmd_val {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&pmd_val);
		eval 'sub pgd_val {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&pgd_val);
		eval 'sub pgprot_val {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&pgprot_val);
		eval 'sub __pte {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pte);
		eval 'sub __pmd {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pmd);
		eval 'sub __pgd {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pgd);
		eval 'sub __pgprot {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pgprot);
	    }
	}
	eval 'sub PAGE_ALIGN {
	    local($addr) = @_;
    	    eval q(((($addr)+ &PAGE_SIZE-1) &PAGE_MASK));
	}' unless defined(&PAGE_ALIGN);
	unless(defined(&__ASSEMBLY__)) {
	    if(defined(&CONFIG_DEBUG_BUGVERBOSE)) {
		eval 'sub BUG () {
		    eval q( &__bug( &__FILE__,  &__LINE__,  &NULL));
		}' unless defined(&BUG);
		eval 'sub PAGE_BUG {
		    local($page) = @_;
    		    eval q( &__bug( &__FILE__,  &__LINE__, $page));
		}' unless defined(&PAGE_BUG);
	    } else {
		eval 'sub BUG () {
		    eval q((*0= 0));
		}' unless defined(&BUG);
		eval 'sub PAGE_BUG {
		    local($page) = @_;
    		    eval q((*0= 0));
		}' unless defined(&PAGE_BUG);
	    }
	}
	require 'linux/config.ph';
	require 'asm/memory.ph';
	eval 'sub VM_DATA_DEFAULT_FLAGS () {( &VM_READ |  &VM_WRITE |  &VM_EXEC |  &VM_MAYREAD |  &VM_MAYWRITE |  &VM_MAYEXEC);}' unless defined(&VM_DATA_DEFAULT_FLAGS);
    }
}
1;
