require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_FLOPPY_H)) {
    eval 'sub __ASM_ARM_FLOPPY_H () {1;}' unless defined(&__ASM_ARM_FLOPPY_H);
    if(0) {
	require 'asm/arch/floppy.ph';
    }
    eval 'sub fd_outb {
        local($val,$port) = @_;
	    eval q( &do {  &if (($port) ==  &FD_DOR)  &fd_setdor(($val));  &else  &outb(($val),($port)); }  &while(0));
    }' unless defined(&fd_outb);
    eval 'sub fd_inb {
        local($port) = @_;
	    eval q( &inb(($port)));
    }' unless defined(&fd_inb);
    eval 'sub fd_request_irq () {
        eval q( &request_irq( &IRQ_FLOPPYDISK, &floppy_interrupt,  &SA_INTERRUPT| &SA_SAMPLE_RANDOM,\\"floppy\\", &NULL));
    }' unless defined(&fd_request_irq);
    eval 'sub fd_free_irq () {
        eval q( &free_irq( &IRQ_FLOPPYDISK, &NULL));
    }' unless defined(&fd_free_irq);
    eval 'sub fd_disable_irq () {
        eval q( &disable_irq( &IRQ_FLOPPYDISK));
    }' unless defined(&fd_disable_irq);
    eval 'sub fd_enable_irq () {
        eval q( &enable_irq( &IRQ_FLOPPYDISK));
    }' unless defined(&fd_enable_irq);
    eval 'sub fd_request_dma () {
        eval q( &request_dma( &DMA_FLOPPY,\\"floppy\\"));
    }' unless defined(&fd_request_dma);
    eval 'sub fd_free_dma () {
        eval q( &free_dma( &DMA_FLOPPY));
    }' unless defined(&fd_free_dma);
    eval 'sub fd_disable_dma () {
        eval q( &disable_dma( &DMA_FLOPPY));
    }' unless defined(&fd_disable_dma);
    eval 'sub fd_enable_dma () {
        eval q( &enable_dma( &DMA_FLOPPY));
    }' unless defined(&fd_enable_dma);
    eval 'sub fd_clear_dma_ff () {
        eval q( &clear_dma_ff( &DMA_FLOPPY));
    }' unless defined(&fd_clear_dma_ff);
    eval 'sub fd_set_dma_mode {
        local($mode) = @_;
	    eval q( &set_dma_mode( &DMA_FLOPPY, ($mode)));
    }' unless defined(&fd_set_dma_mode);
    eval 'sub fd_set_dma_addr {
        local($addr) = @_;
	    eval q( &set_dma_addr( &DMA_FLOPPY,  &virt_to_bus(($addr))));
    }' unless defined(&fd_set_dma_addr);
    eval 'sub fd_set_dma_count {
        local($len) = @_;
	    eval q( &set_dma_count( &DMA_FLOPPY, ($len)));
    }' unless defined(&fd_set_dma_count);
    eval 'sub fd_cacheflush {
        local($addr,$sz) = @_;
	    eval q();
    }' unless defined(&fd_cacheflush);
    eval 'sub DMA_FLOPPYDISK () { &DMA_FLOPPY;}' unless defined(&DMA_FLOPPYDISK);
    eval 'sub fd_setdor {
        local($dor) = @_;
	    eval q( &do { \'int\'  &new_dor = ($dor);  &if ( &new_dor & 0xf0)  &new_dor = ( &new_dor & 0xc) |  $floppy_selects[ &fdc][ &new_dor & 3];  &else  &new_dor &= 0xc;  &outb( &new_dor,  &FD_DOR); }  &while (0));
    }' unless defined(&fd_setdor);
    if(0) {
    } else {
    }
    eval 'sub FDC1 () {(0x3f0);}' unless defined(&FDC1);
    eval 'sub FLOPPY0_TYPE () {4;}' unless defined(&FLOPPY0_TYPE);
    eval 'sub FLOPPY1_TYPE () {4;}' unless defined(&FLOPPY1_TYPE);
    eval 'sub N_FDC () {1;}' unless defined(&N_FDC);
    eval 'sub N_DRIVE () {4;}' unless defined(&N_DRIVE);
    eval 'sub FLOPPY_MOTOR_MASK () {0xf0;}' unless defined(&FLOPPY_MOTOR_MASK);
    eval 'sub CROSS_64KB {
        local($a,$s) = @_;
	    eval q((0));
    }' unless defined(&CROSS_64KB);
    eval 'sub EXTRA_FLOPPY_PARAMS () {,{ "driveswap",  &driveswap,  &NULL, 0, 0};}' unless defined(&EXTRA_FLOPPY_PARAMS);
}
1;
