require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_DMA_H)) {
    eval 'sub __ASM_ARM_DMA_H () {1;}' unless defined(&__ASM_ARM_DMA_H);
    require 'linux/config.ph';
    require 'linux/spinlock.ph';
    require 'asm/system.ph';
    require 'asm/memory.ph';
    require 'asm/scatterlist.ph';
    require 'asm/arch/dma.ph';
    eval 'sub DMA_MODE_MASK () {3;}' unless defined(&DMA_MODE_MASK);
    eval 'sub DMA_MODE_READ () {0;}' unless defined(&DMA_MODE_READ);
    eval 'sub DMA_MODE_WRITE () {1;}' unless defined(&DMA_MODE_WRITE);
    eval 'sub DMA_MODE_CASCADE () {2;}' unless defined(&DMA_MODE_CASCADE);
    eval 'sub DMA_AUTOINIT () {4;}' unless defined(&DMA_AUTOINIT);
    eval 'sub claim_dma_lock {
        local($void) = @_;
	    eval q({ my $flags;  &spin_lock_irqsave( &dma_spin_lock,  $flags);  $flags; });
    }' unless defined(&claim_dma_lock);
    eval 'sub release_dma_lock {
        local($flags) = @_;
	    eval q({  &spin_unlock_irqrestore( &dma_spin_lock, $flags); });
    }' unless defined(&release_dma_lock);
    eval 'sub clear_dma_ff {
        local($channel) = @_;
	    eval q();
    }' unless defined(&clear_dma_ff);
    unless(defined(&NO_DMA)) {
	eval 'sub NO_DMA () {255;}' unless defined(&NO_DMA);
    }
    if(defined(&CONFIG_PCI)) {
    } else {
	eval 'sub isa_dma_bridge_buggy () {(0);}' unless defined(&isa_dma_bridge_buggy);
    }
    unless(defined(&arch_adjust_zones)) {
	eval 'sub arch_adjust_zones {
	    local($node,$size,$holes) = @_;
    	    eval q();
	}' unless defined(&arch_adjust_zones);
    }
}
1;
