require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASSEMBLY__)) {
    require 'asm/memory.ph';
    require 'asm/page.ph';
    eval 'sub cpu_data_abort {
        local($pc) = @_;
	    eval q( ($processor->{_data_abort})($pc));
    }' unless defined(&cpu_data_abort);
    eval 'sub cpu_check_bugs () {
        eval q( ($processor->{_check_bugs})());
    }' unless defined(&cpu_check_bugs);
    eval 'sub cpu_proc_init () {
        eval q( ($processor->{_proc_init})());
    }' unless defined(&cpu_proc_init);
    eval 'sub cpu_proc_fin () {
        eval q( ($processor->{_proc_fin})());
    }' unless defined(&cpu_proc_fin);
    eval 'sub cpu_reset {
        local($addr) = @_;
	    eval q( ($processor->{reset})($addr));
    }' unless defined(&cpu_reset);
    eval 'sub cpu_do_idle () {
        eval q( ($processor->{_do_idle})());
    }' unless defined(&cpu_do_idle);
    eval 'sub cpu_cache_clean_invalidate_all () {
        eval q( ($processor->{cache}->{clean_invalidate_all})());
    }' unless defined(&cpu_cache_clean_invalidate_all);
    eval 'sub cpu_cache_clean_invalidate_range {
        local($s,$e,$f) = @_;
	    eval q( ($processor->{cache}->{clean_invalidate_range})($s,$e,$f));
    }' unless defined(&cpu_cache_clean_invalidate_range);
    eval 'sub cpu_flush_ram_page {
        local($vp) = @_;
	    eval q( ($processor->{cache}->{_flush_ram_page})($vp));
    }' unless defined(&cpu_flush_ram_page);
    eval 'sub cpu_dcache_clean_page {
        local($vp) = @_;
	    eval q( ($processor->{dcache}->{clean_page})($vp));
    }' unless defined(&cpu_dcache_clean_page);
    eval 'sub cpu_dcache_clean_entry {
        local($addr) = @_;
	    eval q( ($processor->{dcache}->{clean_entry})($addr));
    }' unless defined(&cpu_dcache_clean_entry);
    eval 'sub cpu_dcache_clean_range {
        local($s,$e) = @_;
	    eval q( ($processor->{dcache}->{clean_range})($s,$e));
    }' unless defined(&cpu_dcache_clean_range);
    eval 'sub cpu_dcache_invalidate_range {
        local($s,$e) = @_;
	    eval q( ($processor->{dcache}->{invalidate_range})($s,$e));
    }' unless defined(&cpu_dcache_invalidate_range);
    eval 'sub cpu_icache_invalidate_range {
        local($s,$e) = @_;
	    eval q( ($processor->{icache}->{invalidate_range})($s,$e));
    }' unless defined(&cpu_icache_invalidate_range);
    eval 'sub cpu_icache_invalidate_page {
        local($vp) = @_;
	    eval q( ($processor->{icache}->{invalidate_page})($vp));
    }' unless defined(&cpu_icache_invalidate_page);
    eval 'sub cpu_tlb_invalidate_all () {
        eval q( ($processor->{tlb}->{invalidate_all})());
    }' unless defined(&cpu_tlb_invalidate_all);
    eval 'sub cpu_tlb_invalidate_range {
        local($s,$e) = @_;
	    eval q( ($processor->{tlb}->{invalidate_range})($s,$e));
    }' unless defined(&cpu_tlb_invalidate_range);
    eval 'sub cpu_tlb_invalidate_page {
        local($vp,$f) = @_;
	    eval q( ($processor->{tlb}->{invalidate_page})($vp,$f));
    }' unless defined(&cpu_tlb_invalidate_page);
    eval 'sub cpu_set_pgd {
        local($pgd) = @_;
	    eval q( ($processor->{pgtable}->{set_pgd})($pgd));
    }' unless defined(&cpu_set_pgd);
    eval 'sub cpu_set_pmd {
        local($pmdp, $pmd) = @_;
	    eval q( ($processor->{pgtable}->{set_pmd})($pmdp, $pmd));
    }' unless defined(&cpu_set_pmd);
    eval 'sub cpu_set_pte {
        local($ptep, $pte) = @_;
	    eval q( ($processor->{pgtable}->{set_pte})($ptep, $pte));
    }' unless defined(&cpu_set_pte);
    eval 'sub cpu_switch_mm {
        local($pgd,$tsk) = @_;
	    eval q( &cpu_set_pgd( &__virt_to_phys(($pgd))));
    }' unless defined(&cpu_switch_mm);
    eval 'sub cpu_get_pgd () {
        eval q(({ \'unsigned long pg\';  &__asm__(\\"mrc p15, 0, %0, c2, c0, 0\\" : \\"=r\\" ( &pg));  &pg &= ~0x3fff; ( &pgd_t *) &phys_to_virt( &pg); }));
    }' unless defined(&cpu_get_pgd);
}
1;
