require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_ATOMIC_H)) {
    eval 'sub __ASM_ARM_ATOMIC_H () {1;}' unless defined(&__ASM_ARM_ATOMIC_H);
    require 'linux/config.ph';
    if(defined(&CONFIG_SMP)) {
	die("SMP\ not\ supported");
    }
    eval 'sub ATOMIC_INIT {
        local($i) = @_;
	    eval q({ ($i) });
    }' unless defined(&ATOMIC_INIT);
    if(defined(&__KERNEL__)) {
	require 'asm/proc/system.ph';
	eval 'sub atomic_read {
	    local($v) = @_;
    	    eval q((($v)-> &counter));
	}' unless defined(&atomic_read);
	eval 'sub atomic_set {
	    local($v,$i) = @_;
    	    eval q(((($v)-> &counter) = ($i)));
	}' unless defined(&atomic_set);
	eval 'sub atomic_add {
	    local($i,$v) = @_;
    	    eval q({ my $flags;  &local_irq_save( $flags);  ($v->{counter}) += $i;  &local_irq_restore( $flags); });
	}' unless defined(&atomic_add);
	eval 'sub atomic_sub {
	    local($i,$v) = @_;
    	    eval q({ my $flags;  &local_irq_save( $flags);  ($v->{counter}) -= $i;  &local_irq_restore( $flags); });
	}' unless defined(&atomic_sub);
	eval 'sub atomic_inc {
	    local($v) = @_;
    	    eval q({ my $flags;  &local_irq_save( $flags);  ($v->{counter}) += 1;  &local_irq_restore( $flags); });
	}' unless defined(&atomic_inc);
	eval 'sub atomic_dec {
	    local($v) = @_;
    	    eval q({ my $flags;  &local_irq_save( $flags);  ($v->{counter}) -= 1;  &local_irq_restore( $flags); });
	}' unless defined(&atomic_dec);
	eval 'sub atomic_dec_and_test {
	    local($v) = @_;
    	    eval q({ my $flags; \'int\'  &val;  &local_irq_save( $flags);  &val =  ($v->{counter});  ($v->{counter}) =  &val -= 1;  &local_irq_restore( $flags);  &val == 0; });
	}' unless defined(&atomic_dec_and_test);
	eval 'sub atomic_add_negative {
	    local($i,$v) = @_;
    	    eval q({ my $flags; \'int\'  &val;  &local_irq_save( $flags);  &val =  ($v->{counter});  ($v->{counter}) =  &val += $i;  &local_irq_restore( $flags);  &val < 0; });
	}' unless defined(&atomic_add_negative);
	eval 'sub atomic_clear_mask {
	    local($mask,$addr) = @_;
    	    eval q({ my $flags;  &local_irq_save( $flags); *$addr &= ~$mask;  &local_irq_restore( $flags); });
	}' unless defined(&atomic_clear_mask);
	eval 'sub smp_mb__before_atomic_dec () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__before_atomic_dec);
	eval 'sub smp_mb__after_atomic_dec () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__after_atomic_dec);
	eval 'sub smp_mb__before_atomic_inc () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__before_atomic_inc);
	eval 'sub smp_mb__after_atomic_inc () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__after_atomic_inc);
    }
}
1;
