require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&AMIGAFFS_H)) {
    eval 'sub AMIGAFFS_H () {1;}' unless defined(&AMIGAFFS_H);
    require 'linux/types.ph';
    require 'linux/locks.ph';
    require 'asm/byteorder.ph';
    eval 'sub GET_END_PTR {
        local($st,$p,$sz) = @_;
	    eval q((($st *)(($p)+(($sz)-$sizeof{$st}))));
    }' unless defined(&GET_END_PTR);
    eval 'sub AFFS_GET_HASHENTRY {
        local($data,$hashkey) = @_;
	    eval q( &be32_to_cpu(($data)-> $hashtable[$hashkey]));
    }' unless defined(&AFFS_GET_HASHENTRY);
    eval 'sub AFFS_BLOCK {
        local($sb, $bh, $blk) = @_;
	    eval q(( &AFFS_HEAD($bh)-> $table[($sb)-> ($u->{affs_sb}->{s_hashsize})-1-($blk)]));
    }' unless defined(&AFFS_BLOCK);
    eval 'sub affs_set_blocksize {
        local($sb,$size) = @_;
	    eval q({  &set_blocksize( ($sb->{s_dev}), $size);  ($sb->{s_blocksize}) = $size; });
    }' unless defined(&affs_set_blocksize);
    eval 'sub affs_bread {
        local($sb,$block) = @_;
	    eval q({  &pr_debug( &KERN_DEBUG \\"affs_bread: %d\\\\n\\", $block);  &if ($block >=  ($AFFS_SB->{s_reserved})  && $block <  ($AFFS_SB->{s_partition_size}))  &sb_bread($sb, $block);  &NULL; });
    }' unless defined(&affs_bread);
    eval 'sub affs_getblk {
        local($sb,$block) = @_;
	    eval q({  &pr_debug( &KERN_DEBUG \\"affs_getblk: %d\\\\n\\", $block);  &if ($block >=  ($AFFS_SB->{s_reserved})  && $block <  ($AFFS_SB->{s_partition_size}))  &sb_getblk($sb, $block);  &NULL; });
    }' unless defined(&affs_getblk);
    eval 'sub affs_getzeroblk {
        local($sb,$block) = @_;
	    eval q({ \'struct buffer_head\' * &bh;  &pr_debug( &KERN_DEBUG \\"affs_getzeroblk: %d\\\\n\\", $block);  &if ($block >=  ($AFFS_SB->{s_reserved})  && $block <  ($AFFS_SB->{s_partition_size})) {  &bh =  &sb_getblk($sb, $block);  &lock_buffer( &bh);  &memset( ($bh->{b_data}), 0,  ($sb->{s_blocksize}));  &mark_buffer_uptodate( &bh, 1);  &unlock_buffer( &bh);  &bh; }  &NULL; });
    }' unless defined(&affs_getzeroblk);
    eval 'sub affs_getemptyblk {
        local($sb,$block) = @_;
	    eval q({ \'struct buffer_head\' * &bh;  &pr_debug( &KERN_DEBUG \\"affs_getemptyblk: %d\\\\n\\", $block);  &if ($block >=  ($AFFS_SB->{s_reserved})  && $block <  ($AFFS_SB->{s_partition_size})) {  &bh =  &sb_getblk($sb, $block);  &wait_on_buffer( &bh);  &mark_buffer_uptodate( &bh, 1);  &bh; }  &NULL; });
    }' unless defined(&affs_getemptyblk);
    eval 'sub affs_brelse {
        local($bh) = @_;
	    eval q({  &if ($bh)  &pr_debug( &KERN_DEBUG \\"affs_brelse: %ld\\\\n\\",  ($bh->{b_blocknr}));  &brelse($bh); });
    }' unless defined(&affs_brelse);
    eval 'sub affs_adjust_checksum {
        local($bh,$val) = @_;
	    eval q({  &u32  &tmp =  &be32_to_cpu((( &u32 *) ($bh->{b_data}))[5]); (( &u32 *) ($bh->{b_data}))[5] =  &cpu_to_be32( &tmp - $val); });
    }' unless defined(&affs_adjust_checksum);
    eval 'sub affs_adjust_bitmapchecksum {
        local($bh,$val) = @_;
	    eval q({  &u32  &tmp =  &be32_to_cpu((( &u32 *) ($bh->{b_data}))[0]); (( &u32 *) ($bh->{b_data}))[0] =  &cpu_to_be32( &tmp - $val); });
    }' unless defined(&affs_adjust_bitmapchecksum);
    eval 'sub affs_lock_link {
        local($inode) = @_;
	    eval q({  &down( ($AFFS_INODE->{i_link_lock})); });
    }' unless defined(&affs_lock_link);
    eval 'sub affs_unlock_link {
        local($inode) = @_;
	    eval q({  &up( ($AFFS_INODE->{i_link_lock})); });
    }' unless defined(&affs_unlock_link);
    eval 'sub affs_lock_dir {
        local($inode) = @_;
	    eval q({  &down( ($AFFS_INODE->{i_hash_lock})); });
    }' unless defined(&affs_lock_dir);
    eval 'sub affs_unlock_dir {
        local($inode) = @_;
	    eval q({  &up( ($AFFS_INODE->{i_hash_lock})); });
    }' unless defined(&affs_unlock_dir);
    eval 'sub affs_lock_ext {
        local($inode) = @_;
	    eval q({  &down( ($AFFS_INODE->{i_ext_lock})); });
    }' unless defined(&affs_lock_ext);
    eval 'sub affs_unlock_ext {
        local($inode) = @_;
	    eval q({  &up( ($AFFS_INODE->{i_ext_lock})); });
    }' unless defined(&affs_unlock_ext);
    if(defined(&__LITTLE_ENDIAN)) {
	eval 'sub BO_EXBITS () {0x18;}' unless defined(&BO_EXBITS);
    }
 elsif(defined( &__BIG_ENDIAN)) {
	eval 'sub BO_EXBITS () {0x;}' unless defined(&BO_EXBITS);
    } else {
	die("Endianness\ must\ be\ known\ for\ affs\ to\ work\.");
    }
    eval 'sub FS_OFS () {0x444f5300;}' unless defined(&FS_OFS);
    eval 'sub FS_FFS () {0x444f5301;}' unless defined(&FS_FFS);
    eval 'sub FS_INTLOFS () {0x444f5302;}' unless defined(&FS_INTLOFS);
    eval 'sub FS_INTLFFS () {0x444f5303;}' unless defined(&FS_INTLFFS);
    eval 'sub FS_DCOFS () {0x444f5304;}' unless defined(&FS_DCOFS);
    eval 'sub FS_DCFFS () {0x444f5305;}' unless defined(&FS_DCFFS);
    eval 'sub MUFS_FS () {0x6d754653;}' unless defined(&MUFS_FS);
    eval 'sub MUFS_OFS () {0x6d754600;}' unless defined(&MUFS_OFS);
    eval 'sub MUFS_FFS () {0x6d754601;}' unless defined(&MUFS_FFS);
    eval 'sub MUFS_INTLOFS () {0x6d754602;}' unless defined(&MUFS_INTLOFS);
    eval 'sub MUFS_INTLFFS () {0x6d754603;}' unless defined(&MUFS_INTLFFS);
    eval 'sub MUFS_DCOFS () {0x6d754604;}' unless defined(&MUFS_DCOFS);
    eval 'sub MUFS_DCFFS () {0x6d754605;}' unless defined(&MUFS_DCFFS);
    eval 'sub T_SHORT () {2;}' unless defined(&T_SHORT);
    eval 'sub T_LIST () {16;}' unless defined(&T_LIST);
    eval 'sub T_DATA () {8;}' unless defined(&T_DATA);
    eval 'sub ST_LINKFILE () {-4;}' unless defined(&ST_LINKFILE);
    eval 'sub ST_FILE () {-3;}' unless defined(&ST_FILE);
    eval 'sub ST_ROOT () {1;}' unless defined(&ST_ROOT);
    eval 'sub ST_USERDIR () {2;}' unless defined(&ST_USERDIR);
    eval 'sub ST_SOFTLINK () {3;}' unless defined(&ST_SOFTLINK);
    eval 'sub ST_LINKDIR () {4;}' unless defined(&ST_LINKDIR);
    eval 'sub AFFS_ROOT_BMAPS () {25;}' unless defined(&AFFS_ROOT_BMAPS);
    eval 'sub AFFS_HEAD {
        local($bh) = @_;
	    eval q((($bh)-> &b_data));
    }' unless defined(&AFFS_HEAD);
    eval 'sub AFFS_TAIL {
        local($sb, $bh) = @_;
	    eval q(((($bh)-> &b_data+($sb)-> &s_blocksize-$sizeof{\'struct affs_tail\'})));
    }' unless defined(&AFFS_TAIL);
    eval 'sub AFFS_ROOT_HEAD {
        local($bh) = @_;
	    eval q((($bh)-> &b_data));
    }' unless defined(&AFFS_ROOT_HEAD);
    eval 'sub AFFS_ROOT_TAIL {
        local($sb, $bh) = @_;
	    eval q(((($bh)-> &b_data+($sb)-> &s_blocksize-$sizeof{\'struct affs_root_tail\'})));
    }' unless defined(&AFFS_ROOT_TAIL);
    eval 'sub AFFS_DATA_HEAD {
        local($bh) = @_;
	    eval q((($bh)-> &b_data));
    }' unless defined(&AFFS_DATA_HEAD);
    eval 'sub AFFS_DATA {
        local($bh) = @_;
	    eval q(((($bh)-> &b_data)-> &data));
    }' unless defined(&AFFS_DATA);
    eval 'sub FIBF_OTR_READ () {0x8000;}' unless defined(&FIBF_OTR_READ);
    eval 'sub FIBF_OTR_WRITE () {0x4000;}' unless defined(&FIBF_OTR_WRITE);
    eval 'sub FIBF_OTR_EXECUTE () {0x2000;}' unless defined(&FIBF_OTR_EXECUTE);
    eval 'sub FIBF_OTR_DELETE () {0x1000;}' unless defined(&FIBF_OTR_DELETE);
    eval 'sub FIBF_GRP_READ () {0x800;}' unless defined(&FIBF_GRP_READ);
    eval 'sub FIBF_GRP_WRITE () {0x400;}' unless defined(&FIBF_GRP_WRITE);
    eval 'sub FIBF_GRP_EXECUTE () {0x200;}' unless defined(&FIBF_GRP_EXECUTE);
    eval 'sub FIBF_GRP_DELETE () {0x100;}' unless defined(&FIBF_GRP_DELETE);
    eval 'sub FIBF_HIDDEN () {0x80;}' unless defined(&FIBF_HIDDEN);
    eval 'sub FIBF_SCRIPT () {0x40;}' unless defined(&FIBF_SCRIPT);
    eval 'sub FIBF_PURE () {0x20;}' unless defined(&FIBF_PURE);
    eval 'sub FIBF_ARCHIVED () {0x10;}' unless defined(&FIBF_ARCHIVED);
    eval 'sub FIBF_NOREAD () {0x8;}' unless defined(&FIBF_NOREAD);
    eval 'sub FIBF_NOWRITE () {0x4;}' unless defined(&FIBF_NOWRITE);
    eval 'sub FIBF_NOEXECUTE () {0x2;}' unless defined(&FIBF_NOEXECUTE);
    eval 'sub FIBF_NODELETE () {0x1;}' unless defined(&FIBF_NODELETE);
    eval 'sub FIBF_OWNER () {0xf;}' unless defined(&FIBF_OWNER);
    eval 'sub FIBF_MASK () {0xee0e;}' unless defined(&FIBF_MASK);
}
1;
