require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NFS_FS_H)) {
    eval 'sub _LINUX_NFS_FS_H () {1;}' unless defined(&_LINUX_NFS_FS_H);
    require 'linux/config.ph';
    require 'linux/in.ph';
    require 'linux/mm.ph';
    require 'linux/pagemap.ph';
    require 'linux/sunrpc/debug.ph';
    require 'linux/sunrpc/auth.ph';
    require 'linux/sunrpc/clnt.ph';
    require 'linux/nfs.ph';
    require 'linux/nfs2.ph';
    require 'linux/nfs3.ph';
    require 'linux/nfs_xdr.ph';
    if(defined(&RPC_DEBUG)) {
	eval 'sub NFS_DEBUG () {1;}' unless defined(&NFS_DEBUG);
    }
    eval 'sub NFS_MAX_DIRCACHE () {16;}' unless defined(&NFS_MAX_DIRCACHE);
    eval 'sub NFS_MAX_FILE_IO_BUFFER_SIZE () {32768;}' unless defined(&NFS_MAX_FILE_IO_BUFFER_SIZE);
    eval 'sub NFS_DEF_FILE_IO_BUFFER_SIZE () {4096;}' unless defined(&NFS_DEF_FILE_IO_BUFFER_SIZE);
    eval 'sub NFS_MAX_RPC_TIMEOUT () {(6* &HZ);}' unless defined(&NFS_MAX_RPC_TIMEOUT);
    eval 'sub NFS_READ_DELAY () {(2* &HZ);}' unless defined(&NFS_READ_DELAY);
    eval 'sub NFS_WRITEBACK_DELAY () {(5* &HZ);}' unless defined(&NFS_WRITEBACK_DELAY);
    eval 'sub NFS_WRITEBACK_LOCKDELAY () {(60* &HZ);}' unless defined(&NFS_WRITEBACK_LOCKDELAY);
    eval 'sub NFS_COMMIT_DELAY () {(5* &HZ);}' unless defined(&NFS_COMMIT_DELAY);
    eval 'sub NFS_LOOKUP_CACHE_SIZE () {64;}' unless defined(&NFS_LOOKUP_CACHE_SIZE);
    eval 'sub NFS_SUPER_MAGIC () {0x6969;}' unless defined(&NFS_SUPER_MAGIC);
    eval 'sub nfs_inode_info {
        eval q(* &NFS_I(\'struct inode\' * &inode) {  ($inode->{u}->{nfs_i}); });
    }' unless defined(&nfs_inode_info);
    eval 'sub NFS_FH {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{fh})));
    }' unless defined(&NFS_FH);
    eval 'sub NFS_SERVER {
        local($inode) = @_;
	    eval q((($inode)-> ($i_sb->{u}->{nfs_sb}->{s_server})));
    }' unless defined(&NFS_SERVER);
    eval 'sub NFS_CLIENT {
        local($inode) = @_;
	    eval q(( &NFS_SERVER($inode)-> &client));
    }' unless defined(&NFS_CLIENT);
    eval 'sub NFS_PROTO {
        local($inode) = @_;
	    eval q(( &NFS_SERVER($inode)-> &rpc_ops));
    }' unless defined(&NFS_PROTO);
    eval 'sub NFS_REQUESTLIST {
        local($inode) = @_;
	    eval q(( &NFS_SERVER($inode)-> &rw_requests));
    }' unless defined(&NFS_REQUESTLIST);
    eval 'sub NFS_ADDR {
        local($inode) = @_;
	    eval q(( &RPC_PEERADDR( &NFS_CLIENT($inode))));
    }' unless defined(&NFS_ADDR);
    eval 'sub NFS_CONGESTED {
        local($inode) = @_;
	    eval q(( &RPC_CONGESTED( &NFS_CLIENT($inode))));
    }' unless defined(&NFS_CONGESTED);
    eval 'sub NFS_COOKIEVERF {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{cookieverf})));
    }' unless defined(&NFS_COOKIEVERF);
    eval 'sub NFS_READTIME {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{read_cache_jiffies})));
    }' unless defined(&NFS_READTIME);
    eval 'sub NFS_MTIME_UPDATE {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{cache_mtime_jiffies})));
    }' unless defined(&NFS_MTIME_UPDATE);
    eval 'sub NFS_CACHE_CTIME {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{read_cache_ctime})));
    }' unless defined(&NFS_CACHE_CTIME);
    eval 'sub NFS_CACHE_MTIME {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{read_cache_mtime})));
    }' unless defined(&NFS_CACHE_MTIME);
    eval 'sub NFS_CACHE_ISIZE {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{read_cache_isize})));
    }' unless defined(&NFS_CACHE_ISIZE);
    eval 'sub NFS_NEXTSCAN {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{nextscan})));
    }' unless defined(&NFS_NEXTSCAN);
    eval 'sub NFS_CACHEINV {
        local($inode) = @_;
	    eval q( &do {  &NFS_READTIME($inode) =  &jiffies -  &NFS_MAXATTRTIMEO($inode) - 1; }  &while (0));
    }' unless defined(&NFS_CACHEINV);
    eval 'sub NFS_ATTRTIMEO {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{attrtimeo})));
    }' unless defined(&NFS_ATTRTIMEO);
    eval 'sub NFS_MINATTRTIMEO {
        local($inode) = @_;
	    eval q(( &S_ISDIR( ($inode->{i_mode}))?  &NFS_SERVER($inode)-> &acdirmin :  &NFS_SERVER($inode)-> &acregmin));
    }' unless defined(&NFS_MINATTRTIMEO);
    eval 'sub NFS_MAXATTRTIMEO {
        local($inode) = @_;
	    eval q(( &S_ISDIR( ($inode->{i_mode}))?  &NFS_SERVER($inode)-> &acdirmax :  &NFS_SERVER($inode)-> &acregmax));
    }' unless defined(&NFS_MAXATTRTIMEO);
    eval 'sub NFS_ATTRTIMEO_UPDATE {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{attrtimeo_timestamp})));
    }' unless defined(&NFS_ATTRTIMEO_UPDATE);
    eval 'sub NFS_FLAGS {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{flags})));
    }' unless defined(&NFS_FLAGS);
    eval 'sub NFS_REVALIDATING {
        local($inode) = @_;
	    eval q(( &NFS_FLAGS($inode) &  &NFS_INO_REVALIDATING));
    }' unless defined(&NFS_REVALIDATING);
    eval 'sub NFS_STALE {
        local($inode) = @_;
	    eval q(( &NFS_FLAGS($inode) &  &NFS_INO_STALE));
    }' unless defined(&NFS_STALE);
    eval 'sub NFS_FILEID {
        local($inode) = @_;
	    eval q((($inode)-> ($u->{nfs_i}->{fileid})));
    }' unless defined(&NFS_FILEID);
    eval 'sub NFS_USE_READDIRPLUS {
        local($inode) = @_;
	    eval q((( &NFS_FLAGS($inode) &  &NFS_INO_ADVISE_RDPLUS) ? 1: 0));
    }' unless defined(&NFS_USE_READDIRPLUS);
    eval 'sub NFS_RPC_SWAPFLAGS () {( &RPC_TASK_SWAPPER| &RPC_TASK_ROOTCREDS);}' unless defined(&NFS_RPC_SWAPFLAGS);
    eval 'sub NFS_CLNTF_BUFSIZE () {0x1;}' unless defined(&NFS_CLNTF_BUFSIZE);
    eval 'sub NFS_RW_SYNC () {0x1;}' unless defined(&NFS_RW_SYNC);
    eval 'sub NFS_RW_SWAP () {0x2;}' unless defined(&NFS_RW_SWAP);
    eval 'sub FLUSH_AGING () {0;}' unless defined(&FLUSH_AGING);
    eval 'sub FLUSH_SYNC () {1;}' unless defined(&FLUSH_SYNC);
    eval 'sub FLUSH_WAIT () {2;}' unless defined(&FLUSH_WAIT);
    eval 'sub FLUSH_STABLE () {4;}' unless defined(&FLUSH_STABLE);
    if(defined(&__KERNEL__)) {
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub nfs_file_cred {
	    local($file) = @_;
    	    eval q({ \'struct rpc_cred\' * &cred =  &NULL;  &if ($file)  &cred =  ($file->{private_data});  &cred; });
	}' unless defined(&nfs_file_cred);
	if(defined(&CONFIG_NFS_V3)) {
	}
	eval 'sub nfs_have_read {
	    local($inode) = @_;
    	    eval q({ ! &list_empty( ($inode->{u}->{nfs_i}->{read})); });
	}' unless defined(&nfs_have_read);
	eval 'sub nfs_have_writebacks {
	    local($inode) = @_;
    	    eval q({ ! &list_empty( ($inode->{u}->{nfs_i}->{writeback})); });
	}' unless defined(&nfs_have_writebacks);
	eval 'sub nfs_wb_all {
	    local($inode) = @_;
    	    eval q({ \'int\'  &error =  &nfs_sync_file($inode, 0, 0,  &FLUSH_WAIT); ( &error < 0) ?  &error : 0; });
	}' unless defined(&nfs_wb_all);
	eval 'sub NFS_SetPageSync {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_fs_1, ($page)-> &flags));
	}' unless defined(&NFS_SetPageSync);
	eval 'sub NFS_ClearPageSync {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_fs_1, ($page)-> &flags));
	}' unless defined(&NFS_ClearPageSync);
	eval 'sub NFS_TestClearPageSync {
	    local($page) = @_;
    	    eval q( &test_and_clear_bit( &PG_fs_1, ($page)-> &flags));
	}' unless defined(&NFS_TestClearPageSync);
	eval 'sub nfs_refresh_inode {
	    local($inode,$fattr) = @_;
    	    eval q({  &if (( ($fattr->{valid}) &  &NFS_ATTR_FATTR) == 0) 0;  &__nfs_refresh_inode($inode,$fattr); });
	}' unless defined(&nfs_refresh_inode);
	eval 'sub nfs_size_to_loff_t {
	    local($size) = @_;
    	    eval q({  &loff_t  &maxsz = ((( &loff_t)  &ULONG_MAX) <<  &PAGE_CACHE_SHIFT) +  &PAGE_CACHE_SIZE - 1;  &if ($size >  &maxsz)  &maxsz; ( &loff_t) $size; });
	}' unless defined(&nfs_size_to_loff_t);
	eval 'sub nfs_fileid_to_ino_t {
	    local($fileid) = @_;
    	    eval q({  &ino_t  &ino = ( &ino_t) $fileid;  &if ($sizeof{ &ino_t} < $sizeof{ &u64})  &ino ^= $fileid >> ($sizeof{ &u64}-$sizeof{ &ino_t}) * 8;  &ino; });
	}' unless defined(&nfs_fileid_to_ino_t);
	eval 'sub nfs_time_to_secs {
	    local($time) = @_;
    	    eval q({ ( &time_t)($time >> 32); });
	}' unless defined(&nfs_time_to_secs);
	eval 'sub nfs_wait_event {
	    local($clnt, $wq, $condition) = @_;
    	    eval q(({ \'int\'  &__retval = 0;  &if ( ($clnt->{cl_intr})) {  &sigset_t  &oldmask;  &rpc_clnt_sigmask($clnt,  &oldmask);  &__retval =  &wait_event_interruptible($wq, $condition);  &rpc_clnt_sigunmask($clnt,  &oldmask); }  &else  &wait_event($wq, $condition);  &__retval; }));
	}' unless defined(&nfs_wait_event);
	if(defined(&CONFIG_NFS_V3)) {
	    eval 'sub NFS_JUKEBOX_RETRY_TIME () {(5*  &HZ);}' unless defined(&NFS_JUKEBOX_RETRY_TIME);
	    eval 'sub nfs_async_handle_jukebox {
	        local($task) = @_;
    		eval q({  &if ( ($task->{tk_status}) != - &EJUKEBOX) 0;  ($task->{tk_status}) = 0;  &rpc_restart_call($task);  &rpc_delay($task,  &NFS_JUKEBOX_RETRY_TIME); 1; });
	    }' unless defined(&nfs_async_handle_jukebox);
	} else {
	    eval 'sub nfs_async_handle_jukebox {
	        local($task) = @_;
    		eval q({ 0; });
	    }' unless defined(&nfs_async_handle_jukebox);
	}
    }
    eval 'sub NFSDBG_VFS () {0x1;}' unless defined(&NFSDBG_VFS);
    eval 'sub NFSDBG_DIRCACHE () {0x2;}' unless defined(&NFSDBG_DIRCACHE);
    eval 'sub NFSDBG_LOOKUPCACHE () {0x4;}' unless defined(&NFSDBG_LOOKUPCACHE);
    eval 'sub NFSDBG_PAGECACHE () {0x8;}' unless defined(&NFSDBG_PAGECACHE);
    eval 'sub NFSDBG_PROC () {0x10;}' unless defined(&NFSDBG_PROC);
    eval 'sub NFSDBG_XDR () {0x20;}' unless defined(&NFSDBG_XDR);
    eval 'sub NFSDBG_FILE () {0x40;}' unless defined(&NFSDBG_FILE);
    eval 'sub NFSDBG_ROOT () {0x80;}' unless defined(&NFSDBG_ROOT);
    eval 'sub NFSDBG_ALL () {0xffff;}' unless defined(&NFSDBG_ALL);
    if(defined(&__KERNEL__)) {
	undef(&ifdebug) if defined(&ifdebug);
	if(defined(&NFS_DEBUG)) {
	    eval 'sub ifdebug {
	        local($fac) = @_;
    		eval q( &if ( &nfs_debug &  &NFSDBG_$fac));
	    }' unless defined(&ifdebug);
	} else {
	    eval 'sub ifdebug {
	        local($fac) = @_;
    		eval q( &if (0));
	    }' unless defined(&ifdebug);
	}
    }
}
1;
