require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_IGMP_H)) {
    eval 'sub _LINUX_IGMP_H () {1;}' unless defined(&_LINUX_IGMP_H);
    require 'asm/byteorder.ph';
    eval 'sub IGMPV3_MODE_IS_INCLUDE () {1;}' unless defined(&IGMPV3_MODE_IS_INCLUDE);
    eval 'sub IGMPV3_MODE_IS_EXCLUDE () {2;}' unless defined(&IGMPV3_MODE_IS_EXCLUDE);
    eval 'sub IGMPV3_CHANGE_TO_INCLUDE () {3;}' unless defined(&IGMPV3_CHANGE_TO_INCLUDE);
    eval 'sub IGMPV3_CHANGE_TO_EXCLUDE () {4;}' unless defined(&IGMPV3_CHANGE_TO_EXCLUDE);
    eval 'sub IGMPV3_ALLOW_NEW_SOURCES () {5;}' unless defined(&IGMPV3_ALLOW_NEW_SOURCES);
    eval 'sub IGMPV3_BLOCK_OLD_SOURCES () {6;}' unless defined(&IGMPV3_BLOCK_OLD_SOURCES);
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    eval 'sub IGMP_HOST_MEMBERSHIP_QUERY () {0x11;}' unless defined(&IGMP_HOST_MEMBERSHIP_QUERY);
    eval 'sub IGMP_HOST_MEMBERSHIP_REPORT () {0x12;}' unless defined(&IGMP_HOST_MEMBERSHIP_REPORT);
    eval 'sub IGMP_DVMRP () {0x13;}' unless defined(&IGMP_DVMRP);
    eval 'sub IGMP_PIM () {0x14;}' unless defined(&IGMP_PIM);
    eval 'sub IGMP_TRACE () {0x15;}' unless defined(&IGMP_TRACE);
    eval 'sub IGMPV2_HOST_MEMBERSHIP_REPORT () {0x16;}' unless defined(&IGMPV2_HOST_MEMBERSHIP_REPORT);
    eval 'sub IGMP_HOST_LEAVE_MESSAGE () {0x17;}' unless defined(&IGMP_HOST_LEAVE_MESSAGE);
    eval 'sub IGMPV3_HOST_MEMBERSHIP_REPORT () {0x22;}' unless defined(&IGMPV3_HOST_MEMBERSHIP_REPORT);
    eval 'sub IGMP_MTRACE_RESP () {0x1e;}' unless defined(&IGMP_MTRACE_RESP);
    eval 'sub IGMP_MTRACE () {0x1f;}' unless defined(&IGMP_MTRACE);
    eval 'sub IGMP_DELAYING_MEMBER () {0x1;}' unless defined(&IGMP_DELAYING_MEMBER);
    eval 'sub IGMP_IDLE_MEMBER () {0x2;}' unless defined(&IGMP_IDLE_MEMBER);
    eval 'sub IGMP_LAZY_MEMBER () {0x3;}' unless defined(&IGMP_LAZY_MEMBER);
    eval 'sub IGMP_SLEEPING_MEMBER () {0x4;}' unless defined(&IGMP_SLEEPING_MEMBER);
    eval 'sub IGMP_AWAKENING_MEMBER () {0x5;}' unless defined(&IGMP_AWAKENING_MEMBER);
    eval 'sub IGMP_MINLEN () {8;}' unless defined(&IGMP_MINLEN);
    eval 'sub IGMP_MAX_HOST_REPORT_DELAY () {10;}' unless defined(&IGMP_MAX_HOST_REPORT_DELAY);
    eval 'sub IGMP_TIMER_SCALE () {10;}' unless defined(&IGMP_TIMER_SCALE);
    eval 'sub IGMP_AGE_THRESHOLD () {400;}' unless defined(&IGMP_AGE_THRESHOLD);
    eval 'sub IGMP_ALL_HOSTS () { &htonl(0xe0000001);}' unless defined(&IGMP_ALL_HOSTS);
    eval 'sub IGMP_ALL_ROUTER () { &htonl(0xe0000002);}' unless defined(&IGMP_ALL_ROUTER);
    eval 'sub IGMPV3_ALL_MCR () { &htonl(0xe0000016);}' unless defined(&IGMPV3_ALL_MCR);
    eval 'sub IGMP_LOCAL_GROUP () { &htonl(0xe0000000);}' unless defined(&IGMP_LOCAL_GROUP);
    eval 'sub IGMP_LOCAL_GROUP_MASK () { &htonl(0xffffff00);}' unless defined(&IGMP_LOCAL_GROUP_MASK);
    if(defined(&__KERNEL__)) {
	eval 'sub IP_SFLSIZE {
	    local($count) = @_;
    	    eval q(($sizeof{\'struct ip_sf_socklist\'} + ($count) * $sizeof{ &__u32}));
	}' unless defined(&IP_SFLSIZE);
	eval 'sub IP_SFBLOCK () {10;}' unless defined(&IP_SFBLOCK);
	eval 'sub IGMPV3_MASK {
	    local($value, $nb) = @_;
    	    eval q((($nb)>=32? ($value) : ((1<<($nb))-1) & ($value)));
	}' unless defined(&IGMPV3_MASK);
	eval 'sub IGMPV3_EXP {
	    local($thresh, $nbmant, $nbexp, $value) = @_;
    	    eval q((($value) < ($thresh) ? ($value) : (( &IGMPV3_MASK($value, $nbmant) | (1<<($nbmant+$nbexp))) << ( &IGMPV3_MASK(($value) >> ($nbmant), $nbexp) + ($nbexp)))));
	}' unless defined(&IGMPV3_EXP);
	eval 'sub IGMPV3_QQIC {
	    local($value) = @_;
    	    eval q( &IGMPV3_EXP(0x80, 4, 3, $value));
	}' unless defined(&IGMPV3_QQIC);
	eval 'sub IGMPV3_MRC {
	    local($value) = @_;
    	    eval q( &IGMPV3_EXP(0x80, 4, 3, $value));
	}' unless defined(&IGMPV3_MRC);
    }
}
1;
