require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&I2C_H)) {
    eval 'sub I2C_H () {1;}' unless defined(&I2C_H);
    eval 'sub I2C_DATE () {"20010830";}' unless defined(&I2C_DATE);
    eval 'sub I2C_VERSION () {"2.6.1";}' unless defined(&I2C_VERSION);
    require 'linux/i2c-id.ph';
    require 'linux/types.ph';
    if(defined(&__KERNEL__)) {
	require 'asm/semaphore.ph';
	require 'linux/config.ph';
	eval 'sub I2C_ALGO_MAX () {4;}' unless defined(&I2C_ALGO_MAX);
	eval 'sub I2C_ADAP_MAX () {16;}' unless defined(&I2C_ADAP_MAX);
	eval 'sub I2C_DRIVER_MAX () {16;}' unless defined(&I2C_DRIVER_MAX);
	eval 'sub I2C_CLIENT_MAX () {32;}' unless defined(&I2C_CLIENT_MAX);
	eval 'sub I2C_DUMMY_MAX () {4;}' unless defined(&I2C_DUMMY_MAX);
	if(defined(&CONFIG_PROC_FS)) {
	}
	eval 'sub I2C_DF_NOTIFY () {0x1;}' unless defined(&I2C_DF_NOTIFY);
	eval 'sub I2C_DF_DUMMY () {0x2;}' unless defined(&I2C_DF_DUMMY);
	eval 'sub I2C_CLIENT_ALLOW_USE () {0x1;}' unless defined(&I2C_CLIENT_ALLOW_USE);
	eval 'sub I2C_CLIENT_ALLOW_MULTIPLE_USE () {0x2;}' unless defined(&I2C_CLIENT_ALLOW_MULTIPLE_USE);
	eval 'sub I2C_CLIENT_END () {0xfffe;}' unless defined(&I2C_CLIENT_END);
	eval 'sub ANY_I2C_BUS () {0xffff;}' unless defined(&ANY_I2C_BUS);
	eval 'sub I2C_CLIENT_MAX_OPTS () {48;}' unless defined(&I2C_CLIENT_MAX_OPTS);
    }
    eval 'sub I2C_M_TEN () {0x10;}' unless defined(&I2C_M_TEN);
    eval 'sub I2C_M_RD () {0x1;}' unless defined(&I2C_M_RD);
    eval 'sub I2C_M_NOSTART () {0x4000;}' unless defined(&I2C_M_NOSTART);
    eval 'sub I2C_M_REV_DIR_ADDR () {0x2000;}' unless defined(&I2C_M_REV_DIR_ADDR);
    eval 'sub I2C_FUNC_I2C () {0x1;}' unless defined(&I2C_FUNC_I2C);
    eval 'sub I2C_FUNC_10BIT_ADDR () {0x2;}' unless defined(&I2C_FUNC_10BIT_ADDR);
    eval 'sub I2C_FUNC_PROTOCOL_MANGLING () {0x4;}' unless defined(&I2C_FUNC_PROTOCOL_MANGLING);
    eval 'sub I2C_FUNC_SMBUS_QUICK () {0x10000;}' unless defined(&I2C_FUNC_SMBUS_QUICK);
    eval 'sub I2C_FUNC_SMBUS_READ_BYTE () {0x20000;}' unless defined(&I2C_FUNC_SMBUS_READ_BYTE);
    eval 'sub I2C_FUNC_SMBUS_WRITE_BYTE () {0x40000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_BYTE);
    eval 'sub I2C_FUNC_SMBUS_READ_BYTE_DATA () {0x80000;}' unless defined(&I2C_FUNC_SMBUS_READ_BYTE_DATA);
    eval 'sub I2C_FUNC_SMBUS_WRITE_BYTE_DATA () {0x100000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_BYTE_DATA);
    eval 'sub I2C_FUNC_SMBUS_READ_WORD_DATA () {0x200000;}' unless defined(&I2C_FUNC_SMBUS_READ_WORD_DATA);
    eval 'sub I2C_FUNC_SMBUS_WRITE_WORD_DATA () {0x400000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_WORD_DATA);
    eval 'sub I2C_FUNC_SMBUS_PROC_CALL () {0x800000;}' unless defined(&I2C_FUNC_SMBUS_PROC_CALL);
    eval 'sub I2C_FUNC_SMBUS_READ_BLOCK_DATA () {0x1000000;}' unless defined(&I2C_FUNC_SMBUS_READ_BLOCK_DATA);
    eval 'sub I2C_FUNC_SMBUS_WRITE_BLOCK_DATA () {0x2000000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_BLOCK_DATA);
    eval 'sub I2C_FUNC_SMBUS_READ_I2C_BLOCK () {0x4000000;}' unless defined(&I2C_FUNC_SMBUS_READ_I2C_BLOCK);
    eval 'sub I2C_FUNC_SMBUS_WRITE_I2C_BLOCK () {0x8000000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_I2C_BLOCK);
    eval 'sub I2C_FUNC_SMBUS_BYTE () { &I2C_FUNC_SMBUS_READ_BYTE |  &I2C_FUNC_SMBUS_WRITE_BYTE;}' unless defined(&I2C_FUNC_SMBUS_BYTE);
    eval 'sub I2C_FUNC_SMBUS_BYTE_DATA () { &I2C_FUNC_SMBUS_READ_BYTE_DATA |  &I2C_FUNC_SMBUS_WRITE_BYTE_DATA;}' unless defined(&I2C_FUNC_SMBUS_BYTE_DATA);
    eval 'sub I2C_FUNC_SMBUS_WORD_DATA () { &I2C_FUNC_SMBUS_READ_WORD_DATA |  &I2C_FUNC_SMBUS_WRITE_WORD_DATA;}' unless defined(&I2C_FUNC_SMBUS_WORD_DATA);
    eval 'sub I2C_FUNC_SMBUS_BLOCK_DATA () { &I2C_FUNC_SMBUS_READ_BLOCK_DATA |  &I2C_FUNC_SMBUS_WRITE_BLOCK_DATA;}' unless defined(&I2C_FUNC_SMBUS_BLOCK_DATA);
    eval 'sub I2C_FUNC_SMBUS_I2C_BLOCK () { &I2C_FUNC_SMBUS_READ_I2C_BLOCK |  &I2C_FUNC_SMBUS_WRITE_I2C_BLOCK;}' unless defined(&I2C_FUNC_SMBUS_I2C_BLOCK);
    eval 'sub I2C_FUNC_SMBUS_EMUL () { &I2C_FUNC_SMBUS_QUICK |  &I2C_FUNC_SMBUS_BYTE |  &I2C_FUNC_SMBUS_BYTE_DATA |  &I2C_FUNC_SMBUS_WORD_DATA |  &I2C_FUNC_SMBUS_PROC_CALL |  &I2C_FUNC_SMBUS_WRITE_BLOCK_DATA;}' unless defined(&I2C_FUNC_SMBUS_EMUL);
    eval 'sub I2C_SMBUS_BLOCK_MAX () {32;}' unless defined(&I2C_SMBUS_BLOCK_MAX);
    eval 'sub I2C_SMBUS_I2C_BLOCK_MAX () {32;}' unless defined(&I2C_SMBUS_I2C_BLOCK_MAX);
    eval 'sub I2C_SMBUS_READ () {1;}' unless defined(&I2C_SMBUS_READ);
    eval 'sub I2C_SMBUS_WRITE () {0;}' unless defined(&I2C_SMBUS_WRITE);
    eval 'sub I2C_SMBUS_QUICK () {0;}' unless defined(&I2C_SMBUS_QUICK);
    eval 'sub I2C_SMBUS_BYTE () {1;}' unless defined(&I2C_SMBUS_BYTE);
    eval 'sub I2C_SMBUS_BYTE_DATA () {2;}' unless defined(&I2C_SMBUS_BYTE_DATA);
    eval 'sub I2C_SMBUS_WORD_DATA () {3;}' unless defined(&I2C_SMBUS_WORD_DATA);
    eval 'sub I2C_SMBUS_PROC_CALL () {4;}' unless defined(&I2C_SMBUS_PROC_CALL);
    eval 'sub I2C_SMBUS_BLOCK_DATA () {5;}' unless defined(&I2C_SMBUS_BLOCK_DATA);
    eval 'sub I2C_SMBUS_I2C_BLOCK_DATA () {6;}' unless defined(&I2C_SMBUS_I2C_BLOCK_DATA);
    eval 'sub I2C_RETRIES () {0x701;}' unless defined(&I2C_RETRIES);
    eval 'sub I2C_TIMEOUT () {0x702;}' unless defined(&I2C_TIMEOUT);
    eval 'sub I2C_SLAVE () {0x703;}' unless defined(&I2C_SLAVE);
    eval 'sub I2C_SLAVE_FORCE () {0x706;}' unless defined(&I2C_SLAVE_FORCE);
    eval 'sub I2C_TENBIT () {0x704;}' unless defined(&I2C_TENBIT);
    eval 'sub I2C_FUNCS () {0x705;}' unless defined(&I2C_FUNCS);
    eval 'sub I2C_RDWR () {0x707;}' unless defined(&I2C_RDWR);
    if(0) {
	eval 'sub I2C_ACK_TEST () {0x710;}' unless defined(&I2C_ACK_TEST);
    }
    eval 'sub I2C_SMBUS () {0x720;}' unless defined(&I2C_SMBUS);
    eval 'sub I2C_UDELAY () {0x705;}' unless defined(&I2C_UDELAY);
    eval 'sub I2C_MDELAY () {0x706;}' unless defined(&I2C_MDELAY);
    eval 'sub I2C_MAJOR () {89;}' unless defined(&I2C_MAJOR);
    if(defined(&__KERNEL__)) {
	unless(defined(&NULL)) {
	    eval 'sub NULL () {( ( &void *) 0);}' unless defined(&NULL);
	}
	unless(defined(&ENODEV)) {
	    require 'asm/errno.ph';
	}
	eval 'sub I2C_CLIENT_DEFAULTS () {{ &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END};}' unless defined(&I2C_CLIENT_DEFAULTS);
	eval 'sub I2C_CLIENT_MODPARM_AUX1 {
	    local($x) = @_;
    	    eval q(\\"1-\\" $x \\"h\\");
	}' unless defined(&I2C_CLIENT_MODPARM_AUX1);
	eval 'sub I2C_CLIENT_MODPARM_AUX {
	    local($x) = @_;
    	    eval q( &I2C_CLIENT_MODPARM_AUX1($x));
	}' unless defined(&I2C_CLIENT_MODPARM_AUX);
	eval 'sub I2C_CLIENT_MODPARM () { &I2C_CLIENT_MODPARM_AUX( &I2C_CLIENT_MAX_OPTS);}' unless defined(&I2C_CLIENT_MODPARM);
	eval 'sub I2C_CLIENT_MODULE_PARM {
	    local($var,$desc) = @_;
    	    eval q( &static \'unsigned short var\'[ &I2C_CLIENT_MAX_OPTS] =  &I2C_CLIENT_DEFAULTS;  &MODULE_PARM($var, &I2C_CLIENT_MODPARM);  &MODULE_PARM_DESC($var,$desc));
	}' unless defined(&I2C_CLIENT_MODULE_PARM);
	eval 'sub I2C_CLIENT_INSMOD () { &I2C_CLIENT_MODULE_PARM( &probe, "List of adapter,address pairs to scan additionally");  &I2C_CLIENT_MODULE_PARM( &probe_range, "List of adapter,start-addr,end-addr triples to scan " "additionally");  &I2C_CLIENT_MODULE_PARM( &ignore, "List of adapter,address pairs not to scan");  &I2C_CLIENT_MODULE_PARM( &ignore_range, "List of adapter,start-addr,end-addr triples not to " "scan");  &I2C_CLIENT_MODULE_PARM( &force, "List of adapter,address pairs to boldly assume " "to be present");  &static \'struct i2c_client_address_data\'  &addr_data = { &normal_i2c,  &normal_i2c_range,  &probe,  &probe_range,  &ignore,  &ignore_range,  &force};}' unless defined(&I2C_CLIENT_INSMOD);
	eval 'sub i2c_is_isa_client {
	    local($clientptr) = @_;
    	    eval q((($clientptr)-> ($adapter->{algo}->{id}) ==  &I2C_ALGO_ISA));
	}' unless defined(&i2c_is_isa_client);
	eval 'sub i2c_is_isa_adapter {
	    local($adapptr) = @_;
    	    eval q((($adapptr)-> ($algo->{id}) ==  &I2C_ALGO_ISA));
	}' unless defined(&i2c_is_isa_adapter);
    }
}
1;
