require '_h2ph_pre.ph';

no warnings 'redefine';

require 'asm-generic/xor.ph';
unless(defined(&__XOR)) {
    sub __XOR {
	local($a1, $a2) = @_;
	eval q($a1 ^= $a2);
    }
}
unless(defined(&GET_BLOCK_2)) {
    sub GET_BLOCK_2 {
	local($dst) = @_;
	eval q( &__asm__(\"ldmia	%0, {%1, %2}\" : \"=r\" ($dst), \"=r\" ( &a1), \"=r\" ( &a2) : \"0\" ($dst)));
    }
}
unless(defined(&GET_BLOCK_4)) {
    sub GET_BLOCK_4 {
	local($dst) = @_;
	eval q( &__asm__(\"ldmia	%0, {%1, %2, %3, %4}\" : \"=r\" ($dst), \"=r\" ( &a1), \"=r\" ( &a2), \"=r\" ( &a3), \"=r\" ( &a4) : \"0\" ($dst)));
    }
}
unless(defined(&XOR_BLOCK_2)) {
    sub XOR_BLOCK_2 {
	local($src) = @_;
	eval q( &__asm__(\"ldmia	%0!, {%1, %2}\" : \"=r\" ($src), \"=r\" ( &b1), \"=r\" ( &b2) : \"0\" ($src));  &__XOR( &a1,  &b1);  &__XOR( &a2,  &b2););
    }
}
unless(defined(&XOR_BLOCK_4)) {
    sub XOR_BLOCK_4 {
	local($src) = @_;
	eval q( &__asm__(\"ldmia	%0!, {%1, %2, %3, %4}\" : \"=r\" ($src), \"=r\" ( &b1), \"=r\" ( &b2), \"=r\" ( &b3), \"=r\" ( &b4) : \"0\" ($src));  &__XOR( &a1,  &b1);  &__XOR( &a2,  &b2);  &__XOR( &a3,  &b3);  &__XOR( &a4,  &b4));
    }
}
unless(defined(&PUT_BLOCK_2)) {
    sub PUT_BLOCK_2 {
	local($dst) = @_;
	eval q( &__asm__  &__volatile__(\"stmia	%0!, {%2, %3}\" : \"=r\" ($dst) : \"0\" ($dst), \"r\" ( &a1), \"r\" ( &a2)));
    }
}
unless(defined(&PUT_BLOCK_4)) {
    sub PUT_BLOCK_4 {
	local($dst) = @_;
	eval q( &__asm__  &__volatile__(\"stmia	%0!, {%2, %3, %4, %5}\" : \"=r\" ($dst) : \"0\" ($dst), \"r\" ( &a1), \"r\" ( &a2), \"r\" ( &a3), \"r\" ( &a4)));
    }
}
undef(&XOR_TRY_TEMPLATES) if defined(&XOR_TRY_TEMPLATES);
unless(defined(&XOR_TRY_TEMPLATES)) {
    sub XOR_TRY_TEMPLATES () {	 &do {  &xor_speed( &xor_block_arm4regs);  &xor_speed( &xor_block_8regs);  &xor_speed( &xor_block_32regs); }  &while (0);}
}
1;
