require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PAGEMAP_H)) {
    eval 'sub _LINUX_PAGEMAP_H () {1;}' unless defined(&_LINUX_PAGEMAP_H);
    require 'linux/mm.ph';
    require 'linux/fs.ph';
    require 'linux/list.ph';
    require 'asm/system.ph';
    require 'asm/pgtable.ph';
    require 'linux/highmem.ph';
    eval 'sub PAGE_CACHE_SHIFT () { &PAGE_SHIFT;}' unless defined(&PAGE_CACHE_SHIFT);
    eval 'sub PAGE_CACHE_SIZE () { &PAGE_SIZE;}' unless defined(&PAGE_CACHE_SIZE);
    eval 'sub PAGE_CACHE_MASK () { &PAGE_MASK;}' unless defined(&PAGE_CACHE_MASK);
    eval 'sub PAGE_CACHE_ALIGN {
        local($addr) = @_;
	    eval q(((($addr)+ &PAGE_CACHE_SIZE-1) &PAGE_CACHE_MASK));
    }' unless defined(&PAGE_CACHE_ALIGN);
    eval 'sub page_cache_get {
        local($x) = @_;
	    eval q( &get_page($x));
    }' unless defined(&page_cache_get);
    eval 'sub page_cache_release {
        local($x) = @_;
	    eval q( &__free_page($x));
    }' unless defined(&page_cache_release);
    eval 'sub page {
        eval q(* &page_cache_alloc(\'struct address_space\' * &x) {  &alloc_pages( ($x->{gfp_mask}), 0); });
    }' unless defined(&page);
    eval 'sub page_cache_entry {
        local($x) = @_;
	    eval q( &virt_to_page($x));
    }' unless defined(&page_cache_entry);
    eval 'sub PAGE_HASH_BITS () {( &page_hash_bits);}' unless defined(&PAGE_HASH_BITS);
    eval 'sub PAGE_HASH_SIZE () {(1<<  &PAGE_HASH_BITS);}' unless defined(&PAGE_HASH_SIZE);
    eval 'sub i () {((  &mapping)/($sizeof{\'struct inode\'} & ~ ($sizeof{\'struct inode\'} - 1)));}' unless defined(&i);
    eval 'sub s {
        local($x) = @_;
	    eval q((($x)+(($x)>> &PAGE_HASH_BITS)));
    }' unless defined(&s);
    undef(&i) if defined(&i);
    undef(&s) if defined(&s);
    eval 'sub page_hash {
        local($mapping,$index) = @_;
	    eval q(( &page_hash_table+ &_page_hashfn($mapping,$index)));
    }' unless defined(&page_hash);
    eval 'sub find_get_page {
        local($mapping, $index) = @_;
	    eval q( &__find_get_page($mapping, $index,  &page_hash($mapping, $index)));
    }' unless defined(&find_get_page);
    eval 'sub find_lock_page {
        local($mapping, $index) = @_;
	    eval q( &__find_lock_page($mapping, $index,  &page_hash($mapping, $index)));
    }' unless defined(&find_lock_page);
    eval 'sub wait_on_page {
        local($page) = @_;
	    eval q({  &if ( &PageLocked($page))  &___wait_on_page($page); });
    }' unless defined(&wait_on_page);
}
1;
