require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NETDEVICE_H)) {
    eval 'sub _LINUX_NETDEVICE_H () {1;}' unless defined(&_LINUX_NETDEVICE_H);
    require 'linux/if.ph';
    require 'linux/if_ether.ph';
    require 'linux/if_packet.ph';
    require 'asm/atomic.ph';
    require 'asm/cache.ph';
    require 'asm/byteorder.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	if(defined(&CONFIG_NET_PROFILE)) {
	    require 'net/profile.ph';
	}
	eval 'sub SET_ETHTOOL_OPS {
	    local($netdev,$ops) = @_;
    	    eval q(( ($netdev)-> &ethtool_ops = ($ops) ));
	}' unless defined(&SET_ETHTOOL_OPS);
	eval 'sub HAVE_ALLOC_NETDEV () {1;}' unless defined(&HAVE_ALLOC_NETDEV);
	eval 'sub HAVE_FREE_NETDEV () {1;}' unless defined(&HAVE_FREE_NETDEV);
	eval 'sub NET_XMIT_SUCCESS () {0;}' unless defined(&NET_XMIT_SUCCESS);
	eval 'sub NET_XMIT_DROP () {1;}' unless defined(&NET_XMIT_DROP);
	eval 'sub NET_XMIT_CN () {2;}' unless defined(&NET_XMIT_CN);
	eval 'sub NET_XMIT_POLICED () {3;}' unless defined(&NET_XMIT_POLICED);
	eval 'sub NET_XMIT_BYPASS () {4;}' unless defined(&NET_XMIT_BYPASS);
	eval 'sub NET_RX_SUCCESS () {0;}' unless defined(&NET_RX_SUCCESS);
	eval 'sub NET_RX_DROP () {1;}' unless defined(&NET_RX_DROP);
	eval 'sub NET_RX_CN_LOW () {2;}' unless defined(&NET_RX_CN_LOW);
	eval 'sub NET_RX_CN_MOD () {3;}' unless defined(&NET_RX_CN_MOD);
	eval 'sub NET_RX_CN_HIGH () {4;}' unless defined(&NET_RX_CN_HIGH);
	eval 'sub NET_RX_BAD () {5;}' unless defined(&NET_RX_BAD);
	eval 'sub net_xmit_errno {
	    local($e) = @_;
    	    eval q((($e) !=  &NET_XMIT_CN ? - &ENOBUFS : 0));
	}' unless defined(&net_xmit_errno);
    }
    eval 'sub MAX_ADDR_LEN () {8;}' unless defined(&MAX_ADDR_LEN);
    if(!defined( &CONFIG_AX25)  && !defined( &CONFIG_AX25_MODULE)  && !defined( &CONFIG_TR)) {
	eval 'sub LL_MAX_HEADER () {32;}' unless defined(&LL_MAX_HEADER);
    } else {
	if(defined( &CONFIG_AX25) || defined( &CONFIG_AX25_MODULE)) {
	    eval 'sub LL_MAX_HEADER () {96;}' unless defined(&LL_MAX_HEADER);
	} else {
	    eval 'sub LL_MAX_HEADER () {48;}' unless defined(&LL_MAX_HEADER);
	}
    }
    if(!defined( &CONFIG_NET_IPIP)  && !defined( &CONFIG_IPV6)  && !defined( &CONFIG_IPV6_MODULE)) {
	eval 'sub MAX_HEADER () { &LL_MAX_HEADER;}' unless defined(&MAX_HEADER);
    } else {
	eval 'sub MAX_HEADER () {( &LL_MAX_HEADER + 48);}' unless defined(&MAX_HEADER);
    }
    eval("sub IF_PORT_UNKNOWN () { 0; }") unless defined(&IF_PORT_UNKNOWN);
    eval("sub IF_PORT_10BASE2 () { 1; }") unless defined(&IF_PORT_10BASE2);
    eval("sub IF_PORT_10BASET () { 2; }") unless defined(&IF_PORT_10BASET);
    eval("sub IF_PORT_AUI () { 3; }") unless defined(&IF_PORT_AUI);
    eval("sub IF_PORT_100BASET () { 4; }") unless defined(&IF_PORT_100BASET);
    eval("sub IF_PORT_100BASETX () { 5; }") unless defined(&IF_PORT_100BASETX);
    eval("sub IF_PORT_100BASEFX () { 6; }") unless defined(&IF_PORT_100BASEFX);
    if(defined(&__KERNEL__)) {
	require 'linux/cache.ph';
	require 'linux/skbuff.ph';
	eval 'sub HH_DATA_MOD () {16;}' unless defined(&HH_DATA_MOD);
	eval 'sub HH_DATA_OFF {
	    local($__len) = @_;
    	    eval q(( &HH_DATA_MOD - (($__len) & ( &HH_DATA_MOD - 1))));
	}' unless defined(&HH_DATA_OFF);
	eval 'sub HH_DATA_ALIGN {
	    local($__len) = @_;
    	    eval q(((($__len)+( &HH_DATA_MOD-1))&~( &HH_DATA_MOD - 1)));
	}' unless defined(&HH_DATA_ALIGN);
	eval("sub __LINK_STATE_XOFF () { 0; }") unless defined(&__LINK_STATE_XOFF);
	eval("sub __LINK_STATE_START () { 1; }") unless defined(&__LINK_STATE_START);
	eval("sub __LINK_STATE_PRESENT () { 2; }") unless defined(&__LINK_STATE_PRESENT);
	eval("sub __LINK_STATE_SCHED () { 3; }") unless defined(&__LINK_STATE_SCHED);
	eval("sub __LINK_STATE_NOCARRIER () { 4; }") unless defined(&__LINK_STATE_NOCARRIER);
	eval("sub __LINK_STATE_RX_SCHED () { 5; }") unless defined(&__LINK_STATE_RX_SCHED);
	eval 'sub NETDEV_BOOT_SETUP_MAX () {8;}' unless defined(&NETDEV_BOOT_SETUP_MAX);
	eval 'sub NETIF_F_SG () {1;}' unless defined(&NETIF_F_SG);
	eval 'sub NETIF_F_IP_CSUM () {2;}' unless defined(&NETIF_F_IP_CSUM);
	eval 'sub NETIF_F_NO_CSUM () {4;}' unless defined(&NETIF_F_NO_CSUM);
	eval 'sub NETIF_F_HW_CSUM () {8;}' unless defined(&NETIF_F_HW_CSUM);
	eval 'sub NETIF_F_DYNALLOC () {16;}' unless defined(&NETIF_F_DYNALLOC);
	eval 'sub NETIF_F_HIGHDMA () {32;}' unless defined(&NETIF_F_HIGHDMA);
	eval 'sub NETIF_F_FRAGLIST () {64;}' unless defined(&NETIF_F_FRAGLIST);
	eval 'sub NETIF_F_HW_VLAN_TX () {128;}' unless defined(&NETIF_F_HW_VLAN_TX);
	eval 'sub NETIF_F_HW_VLAN_RX () {256;}' unless defined(&NETIF_F_HW_VLAN_RX);
	eval 'sub NETIF_F_HW_VLAN_FILTER () {512;}' unless defined(&NETIF_F_HW_VLAN_FILTER);
	eval 'sub NETIF_F_VLAN_CHALLENGED () {1024;}' unless defined(&NETIF_F_VLAN_CHALLENGED);
	eval 'sub HAVE_NETDEV_POLL () {1;}' unless defined(&HAVE_NETDEV_POLL);
	eval 'sub HAVE_MULTICAST () {1;}' unless defined(&HAVE_MULTICAST);
	eval 'sub HAVE_SET_MAC_ADDR () {1;}' unless defined(&HAVE_SET_MAC_ADDR);
	eval 'sub HAVE_PRIVATE_IOCTL () {1;}' unless defined(&HAVE_PRIVATE_IOCTL);
	eval 'sub HAVE_SET_CONFIG () {1;}' unless defined(&HAVE_SET_CONFIG);
	eval 'sub HAVE_HEADER_CACHE () {1;}' unless defined(&HAVE_HEADER_CACHE);
	eval 'sub HAVE_CHANGE_MTU () {1;}' unless defined(&HAVE_CHANGE_MTU);
	eval 'sub HAVE_TX_TIMEOUT () {1;}' unless defined(&HAVE_TX_TIMEOUT);
	if(defined(&CONFIG_NET_FASTROUTE)) {
	    eval 'sub NETDEV_FASTROUTE_HMASK () {0xf;}' unless defined(&NETDEV_FASTROUTE_HMASK);
	}
	if(defined(&CONFIG_NET_DIVERT)) {
	}
	eval 'sub SET_NETDEV_DEV {
	    local($net, $pdev) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&SET_NETDEV_DEV);
	require 'linux/interrupt.ph';
	require 'linux/notifier.ph';
	eval 'sub unregister_gifconf {
	    local($family) = @_;
    	    eval q({  &register_gifconf($family, 0); });
	}' unless defined(&unregister_gifconf);
	eval 'sub HAVE_NETIF_QUEUE () {1;}' unless defined(&HAVE_NETIF_QUEUE);
	eval 'sub __netif_schedule {
	    local($dev) = @_;
    	    eval q({  &if (! &test_and_set_bit( &__LINK_STATE_SCHED,  ($dev->{state}))) { my $flags; \'int\'  &cpu =  &smp_processor_id();  &local_irq_save( $flags);  ($dev->{next_sched}) =  ($softnet_data[&cpu]->{output_queue});  ($softnet_data[&cpu]->{output_queue}) = $dev;  &cpu_raise_softirq( &cpu,  &NET_TX_SOFTIRQ);  &local_irq_restore( $flags); } });
	}' unless defined(&__netif_schedule);
	eval 'sub netif_schedule {
	    local($dev) = @_;
    	    eval q({  &if (! &test_bit( &__LINK_STATE_XOFF,  ($dev->{state})))  &__netif_schedule($dev); });
	}' unless defined(&netif_schedule);
	eval 'sub netif_start_queue {
	    local($dev) = @_;
    	    eval q({  &clear_bit( &__LINK_STATE_XOFF,  ($dev->{state})); });
	}' unless defined(&netif_start_queue);
	eval 'sub netif_wake_queue {
	    local($dev) = @_;
    	    eval q({  &if ( &test_and_clear_bit( &__LINK_STATE_XOFF,  ($dev->{state})))  &__netif_schedule($dev); });
	}' unless defined(&netif_wake_queue);
	eval 'sub netif_stop_queue {
	    local($dev) = @_;
    	    eval q({  &set_bit( &__LINK_STATE_XOFF,  ($dev->{state})); });
	}' unless defined(&netif_stop_queue);
	eval 'sub netif_queue_stopped {
	    local($dev) = @_;
    	    eval q({  &test_bit( &__LINK_STATE_XOFF,  ($dev->{state})); });
	}' unless defined(&netif_queue_stopped);
	eval 'sub netif_running {
	    local($dev) = @_;
    	    eval q({  &test_bit( &__LINK_STATE_START,  ($dev->{state})); });
	}' unless defined(&netif_running);
	eval 'sub HAVE_NETIF_RX () {1;}' unless defined(&HAVE_NETIF_RX);
	eval 'sub HAVE_NETIF_RECEIVE_SKB () {1;}' unless defined(&HAVE_NETIF_RECEIVE_SKB);
	eval 'sub dev_put {
	    local($dev) = @_;
    	    eval q({  &if ( &atomic_dec_and_test( ($dev->{refcnt})))  &netdev_finish_unregister($dev); });
	}' unless defined(&dev_put);
	eval 'sub __dev_put {
	    local($dev) = @_;
    	    eval q( &atomic_dec(($dev)-> &refcnt));
	}' unless defined(&__dev_put);
	eval 'sub dev_hold {
	    local($dev) = @_;
    	    eval q( &atomic_inc(($dev)-> &refcnt));
	}' unless defined(&dev_hold);
	eval 'sub netif_carrier_on {
	    local($dev) = @_;
    	    eval q({  &clear_bit( &__LINK_STATE_NOCARRIER,  ($dev->{state}));  &if ( &netif_running($dev))  &__netdev_watchdog_up($dev); });
	}' unless defined(&netif_carrier_on);
	eval 'sub netif_carrier_off {
	    local($dev) = @_;
    	    eval q({  &set_bit( &__LINK_STATE_NOCARRIER,  ($dev->{state})); });
	}' unless defined(&netif_carrier_off);
	eval 'sub netif_device_detach {
	    local($dev) = @_;
    	    eval q({  &if ( &test_and_clear_bit( &__LINK_STATE_PRESENT,  ($dev->{state}))  &&  &netif_running($dev)) {  &netif_stop_queue($dev); } });
	}' unless defined(&netif_device_detach);
	eval 'sub netif_device_attach {
	    local($dev) = @_;
    	    eval q({  &if (! &test_and_set_bit( &__LINK_STATE_PRESENT,  ($dev->{state}))  &&  &netif_running($dev)) {  &netif_wake_queue($dev);  &__netdev_watchdog_up($dev); } });
	}' unless defined(&netif_device_attach);
	eval 'sub HAVE_NETIF_MSG () {1;}' unless defined(&HAVE_NETIF_MSG);
	eval("sub NETIF_MSG_DRV () { 0x0001; }") unless defined(&NETIF_MSG_DRV);
	eval("sub NETIF_MSG_PROBE () { 0x0002; }") unless defined(&NETIF_MSG_PROBE);
	eval("sub NETIF_MSG_LINK () { 0x0004; }") unless defined(&NETIF_MSG_LINK);
	eval("sub NETIF_MSG_TIMER () { 0x0008; }") unless defined(&NETIF_MSG_TIMER);
	eval("sub NETIF_MSG_IFDOWN () { 0x0010; }") unless defined(&NETIF_MSG_IFDOWN);
	eval("sub NETIF_MSG_IFUP () { 0x0020; }") unless defined(&NETIF_MSG_IFUP);
	eval("sub NETIF_MSG_RX_ERR () { 0x0040; }") unless defined(&NETIF_MSG_RX_ERR);
	eval("sub NETIF_MSG_TX_ERR () { 0x0080; }") unless defined(&NETIF_MSG_TX_ERR);
	eval("sub NETIF_MSG_TX_QUEUED () { 0x0100; }") unless defined(&NETIF_MSG_TX_QUEUED);
	eval("sub NETIF_MSG_INTR () { 0x0200; }") unless defined(&NETIF_MSG_INTR);
	eval("sub NETIF_MSG_TX_DONE () { 0x0400; }") unless defined(&NETIF_MSG_TX_DONE);
	eval("sub NETIF_MSG_RX_STATUS () { 0x0800; }") unless defined(&NETIF_MSG_RX_STATUS);
	eval("sub NETIF_MSG_PKTDATA () { 0x1000; }") unless defined(&NETIF_MSG_PKTDATA);
	eval("sub NETIF_MSG_HW () { 0x2000; }") unless defined(&NETIF_MSG_HW);
	eval("sub NETIF_MSG_WOL () { 0x4000; }") unless defined(&NETIF_MSG_WOL);
	eval 'sub netif_msg_drv {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_DRV));
	}' unless defined(&netif_msg_drv);
	eval 'sub netif_msg_probe {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_PROBE));
	}' unless defined(&netif_msg_probe);
	eval 'sub netif_msg_link {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_LINK));
	}' unless defined(&netif_msg_link);
	eval 'sub netif_msg_timer {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TIMER));
	}' unless defined(&netif_msg_timer);
	eval 'sub netif_msg_ifdown {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_IFDOWN));
	}' unless defined(&netif_msg_ifdown);
	eval 'sub netif_msg_ifup {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_IFUP));
	}' unless defined(&netif_msg_ifup);
	eval 'sub netif_msg_rx_err {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_RX_ERR));
	}' unless defined(&netif_msg_rx_err);
	eval 'sub netif_msg_tx_err {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TX_ERR));
	}' unless defined(&netif_msg_tx_err);
	eval 'sub netif_msg_tx_queued {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TX_QUEUED));
	}' unless defined(&netif_msg_tx_queued);
	eval 'sub netif_msg_intr {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_INTR));
	}' unless defined(&netif_msg_intr);
	eval 'sub netif_msg_tx_done {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TX_DONE));
	}' unless defined(&netif_msg_tx_done);
	eval 'sub netif_msg_rx_status {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_RX_STATUS));
	}' unless defined(&netif_msg_rx_status);
	eval 'sub netif_msg_pktdata {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_PKTDATA));
	}' unless defined(&netif_msg_pktdata);
	eval 'sub netif_msg_hw {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_HW));
	}' unless defined(&netif_msg_hw);
	eval 'sub netif_msg_wol {
	    local($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_WOL));
	}' unless defined(&netif_msg_wol);
	eval 'sub netif_poll_disable {
	    local($dev) = @_;
    	    eval q({  &while ( &test_and_set_bit( &__LINK_STATE_RX_SCHED,  ($dev->{state}))) {  ($current->{state}) =  &TASK_INTERRUPTIBLE;  &schedule_timeout(1); } });
	}' unless defined(&netif_poll_disable);
	eval 'sub netif_poll_enable {
	    local($dev) = @_;
    	    eval q({  &clear_bit( &__LINK_STATE_RX_SCHED,  ($dev->{state})); });
	}' unless defined(&netif_poll_enable);
	eval 'sub netif_tx_disable {
	    local($dev) = @_;
    	    eval q({  &spin_lock_bh( ($dev->{xmit_lock}));  &netif_stop_queue($dev);  &spin_unlock_bh( ($dev->{xmit_lock})); });
	}' unless defined(&netif_tx_disable);
	if(defined(&CONFIG_NET_FASTROUTE)) {
	}
	eval 'sub free_netdev {
	    local($dev) = @_;
    	    eval q({  &kfree($dev); });
	}' unless defined(&free_netdev);
    }
}
1;
