require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_FS_H)) {
    eval 'sub _LINUX_FS_H () {1;}' unless defined(&_LINUX_FS_H);
    require 'linux/config.ph';
    require 'linux/linkage.ph';
    require 'linux/limits.ph';
    require 'linux/wait.ph';
    require 'linux/types.ph';
    require 'linux/vfs.ph';
    require 'linux/net.ph';
    require 'linux/kdev_t.ph';
    require 'linux/ioctl.ph';
    require 'linux/list.ph';
    require 'linux/dcache.ph';
    require 'linux/stat.ph';
    require 'linux/cache.ph';
    require 'linux/stddef.ph';
    require 'linux/string.ph';
    require 'asm/atomic.ph';
    require 'asm/bitops.ph';
    undef(&NR_OPEN) if defined(&NR_OPEN);
    eval 'sub NR_OPEN () {(1024*1024);}' unless defined(&NR_OPEN);
    eval 'sub INR_OPEN () {1024;}' unless defined(&INR_OPEN);
    eval 'sub BLOCK_SIZE_BITS () {10;}' unless defined(&BLOCK_SIZE_BITS);
    eval 'sub BLOCK_SIZE () {(1<< &BLOCK_SIZE_BITS);}' unless defined(&BLOCK_SIZE);
    eval 'sub NR_FILE () {8192;}' unless defined(&NR_FILE);
    eval 'sub NR_RESERVED_FILES () {10;}' unless defined(&NR_RESERVED_FILES);
    eval 'sub NR_SUPER () {256;}' unless defined(&NR_SUPER);
    eval 'sub MAY_EXEC () {1;}' unless defined(&MAY_EXEC);
    eval 'sub MAY_WRITE () {2;}' unless defined(&MAY_WRITE);
    eval 'sub MAY_READ () {4;}' unless defined(&MAY_READ);
    eval 'sub FMODE_READ () {1;}' unless defined(&FMODE_READ);
    eval 'sub FMODE_WRITE () {2;}' unless defined(&FMODE_WRITE);
    eval 'sub READ () {0;}' unless defined(&READ);
    eval 'sub WRITE () {1;}' unless defined(&WRITE);
    eval 'sub READA () {2;}' unless defined(&READA);
    eval 'sub SPECIAL () {4;}' unless defined(&SPECIAL);
    eval 'sub SEL_IN () {1;}' unless defined(&SEL_IN);
    eval 'sub SEL_OUT () {2;}' unless defined(&SEL_OUT);
    eval 'sub SEL_EX () {4;}' unless defined(&SEL_EX);
    eval 'sub FS_REQUIRES_DEV () {1;}' unless defined(&FS_REQUIRES_DEV);
    eval 'sub FS_NO_DCACHE () {2;}' unless defined(&FS_NO_DCACHE);
    eval 'sub FS_NO_PRELIM () {4;}' unless defined(&FS_NO_PRELIM);
    eval 'sub FS_SINGLE () {8;}' unless defined(&FS_SINGLE);
    eval 'sub FS_NOMOUNT () {16;}' unless defined(&FS_NOMOUNT);
    eval 'sub FS_LITTER () {32;}' unless defined(&FS_LITTER);
    eval 'sub FS_ODD_RENAME () {32768;}' unless defined(&FS_ODD_RENAME);
    eval 'sub MS_RDONLY () {1;}' unless defined(&MS_RDONLY);
    eval 'sub MS_NOSUID () {2;}' unless defined(&MS_NOSUID);
    eval 'sub MS_NODEV () {4;}' unless defined(&MS_NODEV);
    eval 'sub MS_NOEXEC () {8;}' unless defined(&MS_NOEXEC);
    eval 'sub MS_SYNCHRONOUS () {16;}' unless defined(&MS_SYNCHRONOUS);
    eval 'sub MS_REMOUNT () {32;}' unless defined(&MS_REMOUNT);
    eval 'sub MS_MANDLOCK () {64;}' unless defined(&MS_MANDLOCK);
    eval 'sub MS_NOATIME () {1024;}' unless defined(&MS_NOATIME);
    eval 'sub MS_NODIRATIME () {2048;}' unless defined(&MS_NODIRATIME);
    eval 'sub MS_BIND () {4096;}' unless defined(&MS_BIND);
    eval 'sub MS_MOVE () {8192;}' unless defined(&MS_MOVE);
    eval 'sub MS_REC () {16384;}' unless defined(&MS_REC);
    eval 'sub MS_VERBOSE () {32768;}' unless defined(&MS_VERBOSE);
    eval 'sub MS_ACTIVE () {(1<<30);}' unless defined(&MS_ACTIVE);
    eval 'sub MS_NOUSER () {(1<<31);}' unless defined(&MS_NOUSER);
    eval 'sub MS_RMT_MASK () {( &MS_RDONLY| &MS_SYNCHRONOUS| &MS_MANDLOCK| &MS_NOATIME|  &MS_NODIRATIME);}' unless defined(&MS_RMT_MASK);
    eval 'sub MS_MGC_VAL () {0xc0ed0000;}' unless defined(&MS_MGC_VAL);
    eval 'sub MS_MGC_MSK () {0xffff0000;}' unless defined(&MS_MGC_MSK);
    eval 'sub S_SYNC () {1;}' unless defined(&S_SYNC);
    eval 'sub S_NOATIME () {2;}' unless defined(&S_NOATIME);
    eval 'sub S_QUOTA () {4;}' unless defined(&S_QUOTA);
    eval 'sub S_APPEND () {8;}' unless defined(&S_APPEND);
    eval 'sub S_IMMUTABLE () {16;}' unless defined(&S_IMMUTABLE);
    eval 'sub S_DEAD () {32;}' unless defined(&S_DEAD);
    eval 'sub S_NOQUOTA () {64;}' unless defined(&S_NOQUOTA);
    eval 'sub __IS_FLG {
        local($inode,$flg) = @_;
	    eval q((($inode)-> ($i_sb->{s_flags}) & ($flg)));
    }' unless defined(&__IS_FLG);
    eval 'sub IS_RDONLY {
        local($inode) = @_;
	    eval q((($inode)-> ($i_sb->{s_flags}) &  &MS_RDONLY));
    }' unless defined(&IS_RDONLY);
    eval 'sub IS_SYNC {
        local($inode) = @_;
	    eval q(( &__IS_FLG($inode,  &MS_SYNCHRONOUS) || (($inode)-> &i_flags &  &S_SYNC)));
    }' unless defined(&IS_SYNC);
    eval 'sub IS_MANDLOCK {
        local($inode) = @_;
	    eval q( &__IS_FLG($inode,  &MS_MANDLOCK));
    }' unless defined(&IS_MANDLOCK);
    eval 'sub IS_QUOTAINIT {
        local($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_QUOTA));
    }' unless defined(&IS_QUOTAINIT);
    eval 'sub IS_NOQUOTA {
        local($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_NOQUOTA));
    }' unless defined(&IS_NOQUOTA);
    eval 'sub IS_APPEND {
        local($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_APPEND));
    }' unless defined(&IS_APPEND);
    eval 'sub IS_IMMUTABLE {
        local($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_IMMUTABLE));
    }' unless defined(&IS_IMMUTABLE);
    eval 'sub IS_NOATIME {
        local($inode) = @_;
	    eval q(( &__IS_FLG($inode,  &MS_NOATIME) || (($inode)-> &i_flags &  &S_NOATIME)));
    }' unless defined(&IS_NOATIME);
    eval 'sub IS_NODIRATIME {
        local($inode) = @_;
	    eval q( &__IS_FLG($inode,  &MS_NODIRATIME));
    }' unless defined(&IS_NODIRATIME);
    eval 'sub IS_DEADDIR {
        local($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_DEAD));
    }' unless defined(&IS_DEADDIR);
    eval 'sub BLKROSET () { &_IO(0x12,93);}' unless defined(&BLKROSET);
    eval 'sub BLKROGET () { &_IO(0x12,94);}' unless defined(&BLKROGET);
    eval 'sub BLKRRPART () { &_IO(0x12,95);}' unless defined(&BLKRRPART);
    eval 'sub BLKGETSIZE () { &_IO(0x12,96);}' unless defined(&BLKGETSIZE);
    eval 'sub BLKFLSBUF () { &_IO(0x12,97);}' unless defined(&BLKFLSBUF);
    eval 'sub BLKRASET () { &_IO(0x12,98);}' unless defined(&BLKRASET);
    eval 'sub BLKRAGET () { &_IO(0x12,99);}' unless defined(&BLKRAGET);
    eval 'sub BLKFRASET () { &_IO(0x12,100);}' unless defined(&BLKFRASET);
    eval 'sub BLKFRAGET () { &_IO(0x12,101);}' unless defined(&BLKFRAGET);
    eval 'sub BLKSECTSET () { &_IO(0x12,102);}' unless defined(&BLKSECTSET);
    eval 'sub BLKSECTGET () { &_IO(0x12,103);}' unless defined(&BLKSECTGET);
    eval 'sub BLKSSZGET () { &_IO(0x12,104);}' unless defined(&BLKSSZGET);
    if(0) {
	eval 'sub BLKPG () { &_IO(0x12,105);}' unless defined(&BLKPG);
	eval 'sub BLKELVGET () { &_IOR(0x12,106,$sizeof{ &blkelv_ioctl_arg_t});}' unless defined(&BLKELVGET);
	eval 'sub BLKELVSET () { &_IOW(0x12,107,$sizeof{ &blkelv_ioctl_arg_t});}' unless defined(&BLKELVSET);
    }
    eval 'sub BLKBSZGET () { &_IOR(0x12,112,$sizeof{\'int\'});}' unless defined(&BLKBSZGET);
    eval 'sub BLKBSZSET () { &_IOW(0x12,113,$sizeof{\'int\'});}' unless defined(&BLKBSZSET);
    eval 'sub BLKGETSIZE64 () { &_IOR(0x12,114,$sizeof{ &u64});}' unless defined(&BLKGETSIZE64);
    eval 'sub BMAP_IOCTL () {1;}' unless defined(&BMAP_IOCTL);
    eval 'sub FIBMAP () { &_IO(0x,1);}' unless defined(&FIBMAP);
    eval 'sub FIGETBSZ () { &_IO(0x,2);}' unless defined(&FIGETBSZ);
    if(defined(&__KERNEL__)) {
	require 'asm/semaphore.ph';
	require 'asm/byteorder.ph';
	eval 'sub UPDATE_ATIME {
	    local($inode) = @_;
    	    eval q( &update_atime ($inode));
	}' unless defined(&UPDATE_ATIME);
	eval("sub BH_Uptodate () { 0; }") unless defined(&BH_Uptodate);
	eval("sub BH_Dirty () { 1; }") unless defined(&BH_Dirty);
	eval("sub BH_Lock () { 2; }") unless defined(&BH_Lock);
	eval("sub BH_Req () { 3; }") unless defined(&BH_Req);
	eval("sub BH_Mapped () { 4; }") unless defined(&BH_Mapped);
	eval("sub BH_New () { 5; }") unless defined(&BH_New);
	eval("sub BH_Async () { 6; }") unless defined(&BH_Async);
	eval("sub BH_Wait_IO () { 7; }") unless defined(&BH_Wait_IO);
	eval("sub BH_Launder () { 8; }") unless defined(&BH_Launder);
	eval("sub BH_Attached () { 9; }") unless defined(&BH_Attached);
	eval("sub BH_JBD () { 10; }") unless defined(&BH_JBD);
	eval("sub BH_Sync () { 11; }") unless defined(&BH_Sync);
	eval("sub BH_Delay () { 12; }") unless defined(&BH_Delay);
	eval("sub BH_PrivateStart () { 13; }") unless defined(&BH_PrivateStart);
	eval 'sub MAX_BUF_PER_PAGE () {( &PAGE_CACHE_SIZE / 512);}' unless defined(&MAX_BUF_PER_PAGE);
	eval 'sub __buffer_state {
	    local($bh, $state) = @_;
    	    eval q(((($bh)-> &b_state & (1 <<  &BH_$state)) != 0));
	}' unless defined(&__buffer_state);
	eval 'sub buffer_uptodate {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Uptodate));
	}' unless defined(&buffer_uptodate);
	eval 'sub buffer_dirty {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Dirty));
	}' unless defined(&buffer_dirty);
	eval 'sub buffer_locked {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Lock));
	}' unless defined(&buffer_locked);
	eval 'sub buffer_req {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Req));
	}' unless defined(&buffer_req);
	eval 'sub buffer_mapped {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Mapped));
	}' unless defined(&buffer_mapped);
	eval 'sub buffer_new {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &New));
	}' unless defined(&buffer_new);
	eval 'sub buffer_async {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Async));
	}' unless defined(&buffer_async);
	eval 'sub buffer_launder {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Launder));
	}' unless defined(&buffer_launder);
	eval 'sub buffer_delay {
	    local($bh) = @_;
    	    eval q( &__buffer_state($bh, &Delay));
	}' unless defined(&buffer_delay);
	eval 'sub bh_offset {
	    local($bh) = @_;
    	    eval q((($bh)-> &b_data & ~ &PAGE_MASK));
	}' unless defined(&bh_offset);
	eval 'sub touch_buffer {
	    local($bh) = @_;
    	    eval q( &mark_page_accessed( ($bh->{b_page})));
	}' unless defined(&touch_buffer);
	require 'linux/pipe_fs_i.ph';
	require 'linux/minix_fs_i.ph';
	require 'linux/ext2_fs_i.ph';
	require 'linux/ext3_fs_i.ph';
	require 'linux/hpfs_fs_i.ph';
	require 'linux/ntfs_fs_i.ph';
	require 'linux/msdos_fs_i.ph';
	require 'linux/umsdos_fs_i.ph';
	require 'linux/iso_fs_i.ph';
	require 'linux/nfs_fs_i.ph';
	require 'linux/sysv_fs_i.ph';
	require 'linux/affs_fs_i.ph';
	require 'linux/ufs_fs_i.ph';
	require 'linux/efs_fs_i.ph';
	require 'linux/coda_fs_i.ph';
	require 'linux/romfs_fs_i.ph';
	require 'linux/shmem_fs.ph';
	require 'linux/smb_fs_i.ph';
	require 'linux/hfs_fs_i.ph';
	require 'linux/adfs_fs_i.ph';
	require 'linux/qnx4_fs_i.ph';
	require 'linux/reiserfs_fs_i.ph';
	require 'linux/bfs_fs_i.ph';
	require 'linux/udf_fs_i.ph';
	require 'linux/ncp_fs_i.ph';
	require 'linux/proc_fs_i.ph';
	require 'linux/usbdev_fs_i.ph';
	require 'linux/jffs2_fs_i.ph';
	require 'linux/cramfs_fs_sb.ph';
	eval 'sub ATTR_MODE () {1;}' unless defined(&ATTR_MODE);
	eval 'sub ATTR_UID () {2;}' unless defined(&ATTR_UID);
	eval 'sub ATTR_GID () {4;}' unless defined(&ATTR_GID);
	eval 'sub ATTR_SIZE () {8;}' unless defined(&ATTR_SIZE);
	eval 'sub ATTR_ATIME () {16;}' unless defined(&ATTR_ATIME);
	eval 'sub ATTR_MTIME () {32;}' unless defined(&ATTR_MTIME);
	eval 'sub ATTR_CTIME () {64;}' unless defined(&ATTR_CTIME);
	eval 'sub ATTR_ATIME_SET () {128;}' unless defined(&ATTR_ATIME_SET);
	eval 'sub ATTR_MTIME_SET () {256;}' unless defined(&ATTR_MTIME_SET);
	eval 'sub ATTR_FORCE () {512;}' unless defined(&ATTR_FORCE);
	eval 'sub ATTR_ATTR_FLAG () {1024;}' unless defined(&ATTR_ATTR_FLAG);
	eval 'sub ATTR_FLAG_SYNCRONOUS () {1;}' unless defined(&ATTR_FLAG_SYNCRONOUS);
	eval 'sub ATTR_FLAG_NOATIME () {2;}' unless defined(&ATTR_FLAG_NOATIME);
	eval 'sub ATTR_FLAG_APPEND () {4;}' unless defined(&ATTR_FLAG_APPEND);
	eval 'sub ATTR_FLAG_IMMUTABLE () {8;}' unless defined(&ATTR_FLAG_IMMUTABLE);
	eval 'sub ATTR_FLAG_NODIRATIME () {16;}' unless defined(&ATTR_FLAG_NODIRATIME);
	require 'linux/quota.ph';
	require 'linux/mount.ph';
	eval 'sub KERNEL_HAS_O_DIRECT () {1;}' unless defined(&KERNEL_HAS_O_DIRECT);
	eval 'sub KERNEL_HAS_DIRECT_FILEIO () {1;}' unless defined(&KERNEL_HAS_DIRECT_FILEIO);
	eval 'sub inode_add_bytes {
	    local($inode,$bytes) = @_;
    	    eval q({  ($inode->{i_blocks}) += $bytes >> 9; $bytes &= 511;  ($inode->{i_bytes}) += $bytes;  &if ( ($inode->{i_bytes}) >= 512) {  ($inode->{i_blocks})++;  ($inode->{i_bytes}) -= 512; } });
	}' unless defined(&inode_add_bytes);
	eval 'sub inode_sub_bytes {
	    local($inode,$bytes) = @_;
    	    eval q({  ($inode->{i_blocks}) -= $bytes >> 9; $bytes &= 511;  &if ( ($inode->{i_bytes}) < $bytes) {  ($inode->{i_blocks})--;  ($inode->{i_bytes}) += 512; }  ($inode->{i_bytes}) -= $bytes; });
	}' unless defined(&inode_sub_bytes);
	eval 'sub inode_get_bytes {
	    local($inode) = @_;
    	    eval q({ ((( &loff_t) ($inode->{i_blocks})) << 9) +  ($inode->{i_bytes}); });
	}' unless defined(&inode_get_bytes);
	eval 'sub inode_set_bytes {
	    local($inode,$bytes) = @_;
    	    eval q({  ($inode->{i_blocks}) = $bytes >> 9;  ($inode->{i_bytes}) = $bytes & 511; });
	}' unless defined(&inode_set_bytes);
	eval 'sub file_list_lock () {
	    eval q( &spin_lock( &files_lock););
	}' unless defined(&file_list_lock);
	eval 'sub file_list_unlock () {
	    eval q( &spin_unlock( &files_lock););
	}' unless defined(&file_list_unlock);
	eval 'sub get_file {
	    local($x) = @_;
    	    eval q( &atomic_inc(($x)-> &f_count));
	}' unless defined(&get_file);
	eval 'sub file_count {
	    local($x) = @_;
    	    eval q( &atomic_read(($x)-> &f_count));
	}' unless defined(&file_count);
	eval 'sub MAX_NON_LFS () {((1<<31) - 1);}' unless defined(&MAX_NON_LFS);
	if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)==32) {
	    eval 'sub MAX_LFS_FILESIZE () {((( &u64) &PAGE_CACHE_SIZE << ( &BITS_PER_LONG-1))-1);}' unless defined(&MAX_LFS_FILESIZE);
	}
 elsif((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)==64) {
	    eval 'sub MAX_LFS_FILESIZE () {9.22337203685478e+18;}' unless defined(&MAX_LFS_FILESIZE);
	}
	eval 'sub FL_POSIX () {1;}' unless defined(&FL_POSIX);
	eval 'sub FL_FLOCK () {2;}' unless defined(&FL_FLOCK);
	eval 'sub FL_BROKEN () {4;}' unless defined(&FL_BROKEN);
	eval 'sub FL_ACCESS () {8;}' unless defined(&FL_ACCESS);
	eval 'sub FL_LOCKD () {16;}' unless defined(&FL_LOCKD);
	eval 'sub FL_LEASE () {32;}' unless defined(&FL_LEASE);
	unless(defined(&OFFSET_MAX)) {
	    eval 'sub INT_LIMIT {
	        local($x) = @_;
    		eval q((~(($x)1<< ($sizeof{$x}*8- 1))));
	    }' unless defined(&INT_LIMIT);
	    eval 'sub OFFSET_MAX () { &INT_LIMIT( &loff_t);}' unless defined(&OFFSET_MAX);
	    eval 'sub OFFT_OFFSET_MAX () { &INT_LIMIT( &off_t);}' unless defined(&OFFT_OFFSET_MAX);
	}
	require 'linux/fcntl.ph';
	eval 'sub FASYNC_MAGIC () {0x4601;}' unless defined(&FASYNC_MAGIC);
	eval 'sub MNT_FORCE () {0x1;}' unless defined(&MNT_FORCE);
	eval 'sub MNT_DETACH () {0x2;}' unless defined(&MNT_DETACH);
	require 'linux/minix_fs_sb.ph';
	require 'linux/ext2_fs_sb.ph';
	require 'linux/ext3_fs_sb.ph';
	require 'linux/hpfs_fs_sb.ph';
	require 'linux/ntfs_fs_sb.ph';
	require 'linux/msdos_fs_sb.ph';
	require 'linux/iso_fs_sb.ph';
	require 'linux/nfs_fs_sb.ph';
	require 'linux/sysv_fs_sb.ph';
	require 'linux/affs_fs_sb.ph';
	require 'linux/ufs_fs_sb.ph';
	require 'linux/efs_fs_sb.ph';
	require 'linux/romfs_fs_sb.ph';
	require 'linux/smb_fs_sb.ph';
	require 'linux/hfs_fs_sb.ph';
	require 'linux/adfs_fs_sb.ph';
	require 'linux/qnx4_fs_sb.ph';
	require 'linux/reiserfs_fs_sb.ph';
	require 'linux/bfs_fs_sb.ph';
	require 'linux/udf_fs_sb.ph';
	require 'linux/ncp_fs_sb.ph';
	require 'linux/usbdev_fs_sb.ph';
	require 'linux/cramfs_fs_sb.ph';
	require 'linux/jffs2_fs_sb.ph';
	eval 'sub sb_entry {
	    local($list) = @_;
    	    eval q( &list_entry(($list), \'struct super_block\',  &s_list));
	}' unless defined(&sb_entry);
	eval 'sub S_BIAS () {(1<<30);}' unless defined(&S_BIAS);
	eval 'sub DT_UNKNOWN () {0;}' unless defined(&DT_UNKNOWN);
	eval 'sub DT_FIFO () {1;}' unless defined(&DT_FIFO);
	eval 'sub DT_CHR () {2;}' unless defined(&DT_CHR);
	eval 'sub DT_DIR () {4;}' unless defined(&DT_DIR);
	eval 'sub DT_BLK () {6;}' unless defined(&DT_BLK);
	eval 'sub DT_REG () {8;}' unless defined(&DT_REG);
	eval 'sub DT_LNK () {10;}' unless defined(&DT_LNK);
	eval 'sub DT_SOCK () {12;}' unless defined(&DT_SOCK);
	eval 'sub DT_WHT () {14;}' unless defined(&DT_WHT);
	eval 'sub I_DIRTY_SYNC () {1;}' unless defined(&I_DIRTY_SYNC);
	eval 'sub I_DIRTY_DATASYNC () {2;}' unless defined(&I_DIRTY_DATASYNC);
	eval 'sub I_DIRTY_PAGES () {4;}' unless defined(&I_DIRTY_PAGES);
	eval 'sub I_LOCK () {8;}' unless defined(&I_LOCK);
	eval 'sub I_FREEING () {16;}' unless defined(&I_FREEING);
	eval 'sub I_CLEAR () {32;}' unless defined(&I_CLEAR);
	eval 'sub I_NEW () {64;}' unless defined(&I_NEW);
	eval 'sub I_DIRTY () {( &I_DIRTY_SYNC |  &I_DIRTY_DATASYNC |  &I_DIRTY_PAGES);}' unless defined(&I_DIRTY);
	eval 'sub mark_inode_dirty {
	    local($inode) = @_;
    	    eval q({  &__mark_inode_dirty($inode,  &I_DIRTY); });
	}' unless defined(&mark_inode_dirty);
	eval 'sub mark_inode_dirty_sync {
	    local($inode) = @_;
    	    eval q({  &__mark_inode_dirty($inode,  &I_DIRTY_SYNC); });
	}' unless defined(&mark_inode_dirty_sync);
	eval 'sub mark_inode_dirty_pages {
	    local($inode) = @_;
    	    eval q({  &__mark_inode_dirty($inode,  &I_DIRTY_PAGES); });
	}' unless defined(&mark_inode_dirty_pages);
	eval 'sub DECLARE_FSTYPE {
	    local($var,$type,$read,$flags) = @_;
    	    eval q(\'struct file_system_type\' $var = {  &name: $type,  &read_super: $read,  &fs_flags: $flags,  &owner:  &THIS_MODULE, });
	}' unless defined(&DECLARE_FSTYPE);
	eval 'sub DECLARE_FSTYPE_DEV {
	    local($var,$type,$read) = @_;
    	    eval q( &DECLARE_FSTYPE($var,$type,$read, &FS_REQUIRES_DEV));
	}' unless defined(&DECLARE_FSTYPE_DEV);
	eval 'sub fops_get {
	    local($fops) = @_;
    	    eval q(((($fops)  && ($fops)-> &owner) ? (  &try_inc_mod_count(($fops)-> &owner) ? ($fops) :  &NULL ) : ($fops)));
	}' unless defined(&fops_get);
	eval 'sub fops_put {
	    local($fops) = @_;
    	    eval q( &do {  &if (($fops)  && ($fops)-> &owner)  &__MOD_DEC_USE_COUNT(($fops)-> &owner); }  &while(0));
	}' unless defined(&fops_put);
	eval 'sub kern_umount () { &mntput;}' unless defined(&kern_umount);
	eval 'sub LOCK_USE_CLNT () {1;}' unless defined(&LOCK_USE_CLNT);
	eval 'sub FLOCK_VERIFY_READ () {1;}' unless defined(&FLOCK_VERIFY_READ);
	eval 'sub FLOCK_VERIFY_WRITE () {2;}' unless defined(&FLOCK_VERIFY_WRITE);
	eval 'sub MANDATORY_LOCK {
	    local($inode) = @_;
    	    eval q(( &IS_MANDLOCK($inode)  && (($inode)-> &i_mode & ( &S_ISGID |  &S_IXGRP)) ==  &S_ISGID));
	}' unless defined(&MANDATORY_LOCK);
	eval 'sub locks_verify_locked {
	    local($inode) = @_;
    	    eval q({  &if ( &MANDATORY_LOCK($inode))  &locks_mandatory_locked($inode); 0; });
	}' unless defined(&locks_verify_locked);
	eval 'sub locks_verify_area {
	    local($read_write,$inode,$filp,$offset,$count) = @_;
    	    eval q({  &if ( ($inode->{i_flock})  &&  &MANDATORY_LOCK($inode))  &locks_mandatory_area($read_write, $inode, $filp, $offset, $count); 0; });
	}' unless defined(&locks_verify_area);
	eval 'sub locks_verify_truncate {
	    local($inode,$filp,$size) = @_;
    	    eval q({  &if ( ($inode->{i_flock})  &&  &MANDATORY_LOCK($inode))  &locks_mandatory_area(  &FLOCK_VERIFY_WRITE, $inode, $filp, $size <  ($inode->{i_size}) ? $size :  ($inode->{i_size}), ($size <  ($inode->{i_size}) ?  ($inode->{i_size}) - $size : $size -  ($inode->{i_size})) ); 0; });
	}' unless defined(&locks_verify_truncate);
	eval 'sub get_lease {
	    local($inode,$mode) = @_;
    	    eval q({  &if ( ($inode->{i_flock}))  &__get_lease($inode, $mode); 0; });
	}' unless defined(&get_lease);
	eval 'sub __getname () {
	    eval q( &kmem_cache_alloc( &names_cachep,  &SLAB_KERNEL));
	}' unless defined(&__getname);
	eval 'sub putname {
	    local($name) = @_;
    	    eval q( &kmem_cache_free( &names_cachep, ( &void *)($name)));
	}' unless defined(&putname);
	eval("sub BDEV_FILE () { 0; }") unless defined(&BDEV_FILE);
	eval("sub BDEV_SWAP () { 1; }") unless defined(&BDEV_SWAP);
	eval("sub BDEV_FS () { 2; }") unless defined(&BDEV_FS);
	eval("sub BDEV_RAW () { 3; }") unless defined(&BDEV_RAW);
	eval 'sub BUF_CLEAN () {0;}' unless defined(&BUF_CLEAN);
	eval 'sub BUF_LOCKED () {1;}' unless defined(&BUF_LOCKED);
	eval 'sub BUF_DIRTY () {2;}' unless defined(&BUF_DIRTY);
	eval 'sub NR_LIST () {3;}' unless defined(&NR_LIST);
	eval 'sub get_bh {
	    local($bh) = @_;
    	    eval q({  &atomic_inc(($bh)-> &b_count); });
	}' unless defined(&get_bh);
	eval 'sub put_bh {
	    local($bh) = @_;
    	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($bh->{b_count})); });
	}' unless defined(&put_bh);
	eval 'sub atomic_set_buffer_clean {
	    local($bh) = @_;
    	    eval q( &test_and_clear_bit( &BH_Dirty, ($bh)-> &b_state));
	}' unless defined(&atomic_set_buffer_clean);
	eval 'sub __mark_buffer_clean {
	    local($bh) = @_;
    	    eval q({  &refile_buffer($bh); });
	}' unless defined(&__mark_buffer_clean);
	eval 'sub mark_buffer_clean {
	    local($bh) = @_;
    	    eval q({  &if ( &atomic_set_buffer_clean($bh))  &__mark_buffer_clean($bh); });
	}' unless defined(&mark_buffer_clean);
	eval 'sub buffer_insert_inode_queue {
	    local($bh,$inode) = @_;
    	    eval q({  &buffer_insert_list($bh,  ($inode->{i_dirty_buffers})); });
	}' unless defined(&buffer_insert_inode_queue);
	eval 'sub buffer_insert_inode_data_queue {
	    local($bh,$inode) = @_;
    	    eval q({  &buffer_insert_list($bh,  ($inode->{i_dirty_data_buffers})); });
	}' unless defined(&buffer_insert_inode_data_queue);
	eval 'sub atomic_set_buffer_dirty {
	    local($bh) = @_;
    	    eval q({  &test_and_set_bit( &BH_Dirty,  ($bh->{b_state})); });
	}' unless defined(&atomic_set_buffer_dirty);
	eval 'sub mark_buffer_async {
	    local($bh,$on) = @_;
    	    eval q({  &if ($on)  &set_bit( &BH_Async,  ($bh->{b_state}));  &else  &clear_bit( &BH_Async,  ($bh->{b_state})); });
	}' unless defined(&mark_buffer_async);
	eval 'sub set_buffer_attached {
	    local($bh) = @_;
    	    eval q({  &set_bit( &BH_Attached,  ($bh->{b_state})); });
	}' unless defined(&set_buffer_attached);
	eval 'sub clear_buffer_attached {
	    local($bh) = @_;
    	    eval q({  &clear_bit( &BH_Attached,  ($bh->{b_state})); });
	}' unless defined(&clear_buffer_attached);
	eval 'sub buffer_attached {
	    local($bh) = @_;
    	    eval q({  &test_bit( &BH_Attached,  ($bh->{b_state})); });
	}' unless defined(&buffer_attached);
	eval 'sub mark_buffer_dirty_inode {
	    local($bh,$inode) = @_;
    	    eval q({  &mark_buffer_dirty($bh);  &buffer_insert_inode_queue($bh, $inode); });
	}' unless defined(&mark_buffer_dirty_inode);
	eval 'sub invalidate_buffers {
	    local($dev) = @_;
    	    eval q( &__invalidate_buffers(($dev), 0));
	}' unless defined(&invalidate_buffers);
	eval 'sub destroy_buffers {
	    local($dev) = @_;
    	    eval q( &__invalidate_buffers(($dev), 1));
	}' unless defined(&destroy_buffers);
	eval 'sub fsync_inode_buffers {
	    local($inode) = @_;
    	    eval q({  &fsync_buffers_list( ($inode->{i_dirty_buffers})); });
	}' unless defined(&fsync_inode_buffers);
	eval 'sub fsync_inode_data_buffers {
	    local($inode) = @_;
    	    eval q({  &fsync_buffers_list( ($inode->{i_dirty_data_buffers})); });
	}' unless defined(&fsync_inode_data_buffers);
	eval 'sub put_write_access {
	    local($inode) = @_;
    	    eval q({  &atomic_dec( ($inode->{i_writecount})); });
	}' unless defined(&put_write_access);
	eval 'sub allow_write_access {
	    local($file) = @_;
    	    eval q({  &if ($file)  &atomic_inc( ($file->{f_dentry}->{d_inode}->{i_writecount})); });
	}' unless defined(&allow_write_access);
	eval 'sub PTR_ERR {
	    local($ptr) = @_;
    	    eval q({ $ptr; });
	}' unless defined(&PTR_ERR);
	eval 'sub IS_ERR {
	    local($ptr) = @_;
    	    eval q({ $ptr > -1000; });
	}' unless defined(&IS_ERR);
	eval 'sub LOOKUP_FOLLOW () {(1);}' unless defined(&LOOKUP_FOLLOW);
	eval 'sub LOOKUP_DIRECTORY () {(2);}' unless defined(&LOOKUP_DIRECTORY);
	eval 'sub LOOKUP_CONTINUE () {(4);}' unless defined(&LOOKUP_CONTINUE);
	eval 'sub LOOKUP_POSITIVE () {(8);}' unless defined(&LOOKUP_POSITIVE);
	eval 'sub LOOKUP_PARENT () {(16);}' unless defined(&LOOKUP_PARENT);
	eval 'sub LOOKUP_NOALT () {(32);}' unless defined(&LOOKUP_NOALT);
	eval("sub LAST_NORM () { 0; }") unless defined(&LAST_NORM);
	eval("sub LAST_ROOT () { 1; }") unless defined(&LAST_ROOT);
	eval("sub LAST_DOT () { 2; }") unless defined(&LAST_DOT);
	eval("sub LAST_DOTDOT () { 3; }") unless defined(&LAST_DOTDOT);
	eval("sub LAST_BIND () { 4; }") unless defined(&LAST_BIND);
	eval 'sub user_path_walk {
	    local($name,$nd) = @_;
    	    eval q( &__user_walk($name,  &LOOKUP_FOLLOW| &LOOKUP_POSITIVE, $nd));
	}' unless defined(&user_path_walk);
	eval 'sub user_path_walk_link {
	    local($name,$nd) = @_;
    	    eval q( &__user_walk($name,  &LOOKUP_POSITIVE, $nd));
	}' unless defined(&user_path_walk_link);
	eval 'sub inode {
	    eval q(* &iget4(\'struct super_block\' * &sb, my $ino,  &find_inode_t  &find_actor,  &void * &opaque) { \'struct inode\' * &inode =  &iget4_locked( &sb,  $ino,  &find_actor,  &opaque);  &if ( &inode  && ( ($inode->{i_state}) &  &I_NEW)) {  &if ( ($sb->{s_op}->{read_inode2}))  ($sb->{s_op}->{read_inode2})( &inode,  &opaque);  &else  ($sb->{s_op}->{read_inode})( &inode);  &unlock_new_inode( &inode); }  &inode; });
	}' unless defined(&inode);
	eval 'sub inode {
	    eval q(* &iget(\'struct super_block\' * &sb, my $ino) { \'struct inode\' * &inode =  &iget4_locked( &sb,  $ino,  &NULL,  &NULL);  &if ( &inode  && ( ($inode->{i_state}) &  &I_NEW)) {  ($sb->{s_op}->{read_inode})( &inode);  &unlock_new_inode( &inode); }  &inode; });
	}' unless defined(&inode);
	eval 'sub inode {
	    eval q(* &iget_locked(\'struct super_block\' * &sb, my $ino) {  &iget4_locked( &sb,  $ino,  &NULL,  &NULL); });
	}' unless defined(&inode);
	eval 'sub brelse {
	    local($buf) = @_;
    	    eval q({  &if ($buf)  &__brelse($buf); });
	}' unless defined(&brelse);
	eval 'sub bforget {
	    local($buf) = @_;
    	    eval q({  &if ($buf)  &__bforget($buf); });
	}' unless defined(&bforget);
	eval 'sub sb_bread {
	    local($sb,$block) = @_;
    	    eval q({  &bread( ($sb->{s_dev}), $block,  ($sb->{s_blocksize})); });
	}' unless defined(&sb_bread);
	eval 'sub sb_getblk {
	    local($sb,$block) = @_;
    	    eval q({  &getblk( ($sb->{s_dev}), $block,  ($sb->{s_blocksize})); });
	}' unless defined(&sb_getblk);
	eval 'sub sb_get_hash_table {
	    local($sb,$block) = @_;
    	    eval q({  &get_hash_table( ($sb->{s_dev}), $block,  ($sb->{s_blocksize})); });
	}' unless defined(&sb_get_hash_table);
	eval 'sub block_flushpage {
	    local($page, $offset) = @_;
    	    eval q( &discard_bh_page($page, $offset, 1));
	}' unless defined(&block_flushpage);
	eval 'sub block_invalidate_page {
	    local($page) = @_;
    	    eval q( &discard_bh_page($page, 0, 0));
	}' unless defined(&block_invalidate_page);
	eval 'sub is_mounted {
	    local($dev) = @_;
    	    eval q({ \'struct super_block\' * &sb =  &get_super($dev);  &if ( &sb) {  &drop_super( &sb); 1; } 0; });
	}' unless defined(&is_mounted);
	if(defined(&CONFIG_BLK_DEV_INITRD)) {
	}
	eval 'sub OSYNC_METADATA () {(1<<0);}' unless defined(&OSYNC_METADATA);
	eval 'sub OSYNC_DATA () {(1<<1);}' unless defined(&OSYNC_DATA);
	eval 'sub OSYNC_INODE () {(1<<2);}' unless defined(&OSYNC_INODE);
	eval 'sub dentry {
	    eval q(* &get_parent(\'struct dentry\' * &dentry) {  &dget( ($dentry->{d_parent})); });
	}' unless defined(&dentry);
	eval 'sub unlock_dir {
	    local($dir) = @_;
    	    eval q({  &up( ($dir->{d_inode}->{i_sem}));  &dput($dir); });
	}' unless defined(&unlock_dir);
	eval 'sub double_up {
	    local($s1,$s2) = @_;
    	    eval q({  &up($s1);  &if ($s1 != $s2)  &up($s2); });
	}' unless defined(&double_up);
	eval 'sub triple_up {
	    local($s1,$s2,$s3) = @_;
    	    eval q({  &up($s1);  &if ($s1 != $s2)  &up($s2);  &up($s3); });
	}' unless defined(&triple_up);
	eval 'sub double_lock {
	    local($d1,$d2) = @_;
    	    eval q({  &double_down( ($d1->{d_inode}->{i_sem}),  ($d2->{d_inode}->{i_sem})); });
	}' unless defined(&double_lock);
	eval 'sub double_unlock {
	    local($d1,$d2) = @_;
    	    eval q({  &double_up( ($d1->{d_inode}->{i_sem}), ($d2->{d_inode}->{i_sem}));  &dput($d1);  &dput($d2); });
	}' unless defined(&double_unlock);
    }
}
1;
