require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_ARCDEVICE_H)) {
    eval 'sub _LINUX_ARCDEVICE_H () {1;}' unless defined(&_LINUX_ARCDEVICE_H);
    require 'asm/timex.ph';
    require 'linux/if_arcnet.ph';
    if(defined(&__KERNEL__)) {
	unless(defined(&bool)) {
	    eval 'sub bool () {\'int\';}' unless defined(&bool);
	}
	eval 'sub RECON_THRESHOLD () {30;}' unless defined(&RECON_THRESHOLD);
	eval 'sub TX_TIMEOUT () {( &HZ * 200/ 1000);}' unless defined(&TX_TIMEOUT);
	undef(&ALPHA_WARNING) if defined(&ALPHA_WARNING);
	eval 'sub D_NORMAL () {1;}' unless defined(&D_NORMAL);
	eval 'sub D_EXTRA () {2;}' unless defined(&D_EXTRA);
	eval 'sub D_INIT () {4;}' unless defined(&D_INIT);
	eval 'sub D_INIT_REASONS () {8;}' unless defined(&D_INIT_REASONS);
	eval 'sub D_RECON () {32;}' unless defined(&D_RECON);
	eval 'sub D_PROTO () {64;}' unless defined(&D_PROTO);
	eval 'sub D_DURING () {128;}' unless defined(&D_DURING);
	eval 'sub D_TX () {256;}' unless defined(&D_TX);
	eval 'sub D_RX () {512;}' unless defined(&D_RX);
	eval 'sub D_SKB () {1024;}' unless defined(&D_SKB);
	eval 'sub D_SKB_SIZE () {2048;}' unless defined(&D_SKB_SIZE);
	eval 'sub D_TIMING () {4096;}' unless defined(&D_TIMING);
	unless(defined(&ARCNET_DEBUG_MAX)) {
	    eval 'sub ARCNET_DEBUG_MAX () {(127);}' unless defined(&ARCNET_DEBUG_MAX);
	}
	unless(defined(&ARCNET_DEBUG)) {
	    eval 'sub ARCNET_DEBUG () {( &D_NORMAL| &D_EXTRA);}' unless defined(&ARCNET_DEBUG);
	}
	eval 'sub BUGLVL {
	    local($x) = @_;
    	    eval q( &if (( &ARCNET_DEBUG_MAX) &arcnet_debug($x)));
	}' unless defined(&BUGLVL);
	eval 'sub BUGMSG2 () {( &x, &msg, &args...)  &do {  &BUGLVL( &x)  &printk( &msg,   &args); }  &while (0);}' unless defined(&BUGMSG2);
	eval 'sub BUGMSG () {( &x, &msg, &args...)  &BUGMSG2( &x, "%s%6s: "  &msg,  &x== &D_NORMAL ?  &KERN_WARNING :  &x <  &D_DURING ?  &KERN_INFO :  &KERN_DEBUG,  ($dev->{name}) ,   &args);}' unless defined(&BUGMSG);
	eval 'sub TIME {
	    local($name, $bytes, $call) = @_;
    	    eval q( &BUGLVL( &D_TIMING) { \'unsigned long _x\',  &_y;  &_x =  &get_cycles(); $call;  &_y =  &get_cycles();  &BUGMSG( &D_TIMING, \\"%s: %d bytes in %lu cycles == \\" \\"%lu Kbytes/100Mcycle\\\\n\\", $name, $bytes,  &_y -  &_x, 100000000/ 1024* $bytes / ( &_y -  &_x + 1)); }  &else { $call; });
	}' unless defined(&TIME);
	eval 'sub RESETtime () {(300);}' unless defined(&RESETtime);
	eval 'sub MTU () {253;}' unless defined(&MTU);
	eval 'sub MinTU () {257;}' unless defined(&MinTU);
	eval 'sub XMTU () {508;}' unless defined(&XMTU);
	eval 'sub TXFREEflag () {0x1;}' unless defined(&TXFREEflag);
	eval 'sub TXACKflag () {0x2;}' unless defined(&TXACKflag);
	eval 'sub RECONflag () {0x4;}' unless defined(&RECONflag);
	eval 'sub TESTflag () {0x8;}' unless defined(&TESTflag);
	eval 'sub RESETflag () {0x10;}' unless defined(&RESETflag);
	eval 'sub RES1flag () {0x20;}' unless defined(&RES1flag);
	eval 'sub RES2flag () {0x40;}' unless defined(&RES2flag);
	eval 'sub NORXflag () {0x80;}' unless defined(&NORXflag);
	eval 'sub AUTOINCflag () {0x40;}' unless defined(&AUTOINCflag);
	eval 'sub IOMAPflag () {0x2;}' unless defined(&IOMAPflag);
	eval 'sub ENABLE16flag () {0x80;}' unless defined(&ENABLE16flag);
	eval 'sub NOTXcmd () {0x1;}' unless defined(&NOTXcmd);
	eval 'sub NORXcmd () {0x2;}' unless defined(&NORXcmd);
	eval 'sub TXcmd () {0x3;}' unless defined(&TXcmd);
	eval 'sub RXcmd () {0x4;}' unless defined(&RXcmd);
	eval 'sub CONFIGcmd () {0x5;}' unless defined(&CONFIGcmd);
	eval 'sub CFLAGScmd () {0x6;}' unless defined(&CFLAGScmd);
	eval 'sub TESTcmd () {0x7;}' unless defined(&TESTcmd);
	eval 'sub RESETclear () {0x8;}' unless defined(&RESETclear);
	eval 'sub CONFIGclear () {0x10;}' unless defined(&CONFIGclear);
	eval 'sub TESTload () {0x8;}' unless defined(&TESTload);
	eval 'sub TESTvalue () {0321;}' unless defined(&TESTvalue);
	eval 'sub RXbcasts () {0x80;}' unless defined(&RXbcasts);
	eval 'sub NORMALconf () {0x;}' unless defined(&NORMALconf);
	eval 'sub EXTconf () {0x8;}' unless defined(&EXTconf);
	eval 'sub ARC_IS_5MBIT () {1;}' unless defined(&ARC_IS_5MBIT);
	eval 'sub ARC_CAN_10MBIT () {2;}' unless defined(&ARC_CAN_10MBIT);
	eval 'sub ARCRESET {
	    local($x) = @_;
    	    eval q(( ($lp->{hw}->{reset})( &dev, ($x))));
	}' unless defined(&ARCRESET);
	eval 'sub ACOMMAND {
	    local($x) = @_;
    	    eval q(( ($lp->{hw}->{command})( &dev, ($x))));
	}' unless defined(&ACOMMAND);
	eval 'sub ASTATUS () {
	    eval q(( ($lp->{hw}->{status})( &dev)));
	}' unless defined(&ASTATUS);
	eval 'sub AINTMASK {
	    local($x) = @_;
    	    eval q(( ($lp->{hw}->{intmask})( &dev, ($x))));
	}' unless defined(&AINTMASK);
	eval 'sub ARCOPEN {
	    local($x) = @_;
    	    eval q(( ($lp->{hw}->{open_close})( &dev, ($x))));
	}' unless defined(&ARCOPEN);
	if((defined(&ARCNET_DEBUG_MAX) ? &ARCNET_DEBUG_MAX : 0) & (defined(&D_SKB) ? &D_SKB : 0)) {
	} else {
	    eval 'sub arcnet_dump_skb {
	        local($dev,$skb,$desc) = @_;
    		eval q(;);
	    }' unless defined(&arcnet_dump_skb);
	}
	if(((defined(&ARCNET_DEBUG_MAX) ? &ARCNET_DEBUG_MAX : 0) & (defined(&D_RX) ? &D_RX : 0)) || ((defined(&ARCNET_DEBUG_MAX) ? &ARCNET_DEBUG_MAX : 0) & (defined(&D_TX) ? &D_TX : 0))) {
	} else {
	    eval 'sub arcnet_dump_packet {
	        local($dev, $bufnum, $desc) = @_;
    		eval q(;);
	    }' unless defined(&arcnet_dump_packet);
	}
    }
}
1;
