require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_DIO_H)) {
    eval 'sub _LINUX_DIO_H () {1;}' unless defined(&_LINUX_DIO_H);
    if(defined(&__KERNEL__)) {
	eval 'sub DIO_IDOFF () {0x1;}' unless defined(&DIO_IDOFF);
	eval 'sub DIO_IPLOFF () {0x3;}' unless defined(&DIO_IPLOFF);
	eval 'sub DIO_SECIDOFF () {0x15;}' unless defined(&DIO_SECIDOFF);
	eval 'sub DIOII_SIZEOFF () {0x101;}' unless defined(&DIOII_SIZEOFF);
	eval 'sub DIO_IHPIBADDR () {0x47800;}' unless defined(&DIO_IHPIBADDR);
	eval 'sub DIO_IHPIBSCODE () {7;}' unless defined(&DIO_IHPIBSCODE);
	eval 'sub CONFIG_IHPIB () {1;}' unless defined(&CONFIG_IHPIB);
	if(defined(&CONFIG_IHPIB)) {
	    eval 'sub DIO_ISIHPIB {
	        local($scode) = @_;
    		eval q((($scode) ==  &DIO_IHPIBSCODE));
	    }' unless defined(&DIO_ISIHPIB);
	} else {
	    eval 'sub DIO_ISIHPIB {
	        local($scode) = @_;
    		eval q(0);
	    }' unless defined(&DIO_ISIHPIB);
	}
	eval 'sub DIO_VIRADDRBASE () {0xf0000000;}' unless defined(&DIO_VIRADDRBASE);
	eval 'sub DIO_BASE () {0x600000;}' unless defined(&DIO_BASE);
	eval 'sub DIO_END () {0x1000000;}' unless defined(&DIO_END);
	eval 'sub DIO_DEVSIZE () {0x10000;}' unless defined(&DIO_DEVSIZE);
	eval 'sub DIOII_BASE () {0x1000000;}' unless defined(&DIOII_BASE);
	eval 'sub DIOII_END () {0x20000000;}' unless defined(&DIOII_END);
	eval 'sub DIOII_DEVSIZE () {0x400000;}' unless defined(&DIOII_DEVSIZE);
	eval 'sub DIO_SCMAX () {32;}' unless defined(&DIO_SCMAX);
	eval 'sub DIOII_SCBASE () {132;}' unless defined(&DIOII_SCBASE);
	eval 'sub DIO_SCINHOLE {
	    local($scode) = @_;
    	    eval q(((($scode) >= 32)  && (($scode) <  &DIOII_SCBASE)));
	}' unless defined(&DIO_SCINHOLE);
	eval 'sub DIO_ID {
	    local($baseaddr) = @_;
    	    eval q( &in_8(($baseaddr) +  &DIO_IDOFF));
	}' unless defined(&DIO_ID);
	eval 'sub DIO_SECID {
	    local($baseaddr) = @_;
    	    eval q( &in_8(($baseaddr) +  &DIO_SECIDOFF));
	}' unless defined(&DIO_SECID);
	eval 'sub DIO_IPL {
	    local($baseaddr) = @_;
    	    eval q(((( &in_8(($baseaddr) +  &DIO_IPLOFF) >> 4) & 0x3) + 3));
	}' unless defined(&DIO_IPL);
	eval 'sub DIOII_SIZE {
	    local($baseaddr) = @_;
    	    eval q((( &in_8(($baseaddr) +  &DIOII_SIZEOFF) + 1) * 0x100000));
	}' unless defined(&DIOII_SIZE);
	eval 'sub DIO_SIZE {
	    local($scode, $base) = @_;
    	    eval q(( &DIO_ISDIOII(($scode)) ?  &DIOII_SIZE(($base)) :  &DIO_DEVSIZE));
	}' unless defined(&DIO_SIZE);
	eval 'sub DIO_ENCODE_ID {
	    local($pr,$sec) = @_;
    	    eval q(((($sec & 0xff) << 8) & ($pr & 0xff)));
	}' unless defined(&DIO_ENCODE_ID);
	eval 'sub DIO_NEEDSSECID {
	    local($id) = @_;
    	    eval q((($id) ==  &DIO_ID_FBUFFER));
	}' unless defined(&DIO_NEEDSSECID);
	eval 'sub DIO_ID_DCA0 () {0x2;}' unless defined(&DIO_ID_DCA0);
	eval 'sub DIO_DESC_DCA0 () {"98644A DCA0 serial";}' unless defined(&DIO_DESC_DCA0);
	eval 'sub DIO_ID_DCA0REM () {0x82;}' unless defined(&DIO_ID_DCA0REM);
	eval 'sub DIO_DESC_DCA0REM () {"98644A DCA0REM serial";}' unless defined(&DIO_DESC_DCA0REM);
	eval 'sub DIO_ID_DCA1 () {0x42;}' unless defined(&DIO_ID_DCA1);
	eval 'sub DIO_DESC_DCA1 () {"98644A DCA1 serial";}' unless defined(&DIO_DESC_DCA1);
	eval 'sub DIO_ID_DCA1REM () {0xc2;}' unless defined(&DIO_ID_DCA1REM);
	eval 'sub DIO_DESC_DCA1REM () {"98644A DCA1REM serial";}' unless defined(&DIO_DESC_DCA1REM);
	eval 'sub DIO_ID_DCM () {0x5;}' unless defined(&DIO_ID_DCM);
	eval 'sub DIO_DESC_DCM () {"98642A DCM serial MUX";}' unless defined(&DIO_DESC_DCM);
	eval 'sub DIO_ID_DCMREM () {0x85;}' unless defined(&DIO_ID_DCMREM);
	eval 'sub DIO_DESC_DCMREM () {"98642A DCMREM serial MUX";}' unless defined(&DIO_DESC_DCMREM);
	eval 'sub DIO_ID_LAN () {0x15;}' unless defined(&DIO_ID_LAN);
	eval 'sub DIO_DESC_LAN () {"98643A LANCE ethernet";}' unless defined(&DIO_DESC_LAN);
	eval 'sub DIO_ID_FHPIB () {0x8;}' unless defined(&DIO_ID_FHPIB);
	eval 'sub DIO_DESC_FHPIB () {"98625A/98625B fast HPIB";}' unless defined(&DIO_DESC_FHPIB);
	eval 'sub DIO_ID_NHPIB () {0x80;}' unless defined(&DIO_ID_NHPIB);
	eval 'sub DIO_DESC_NHPIB () {"98624A HPIB";}' unless defined(&DIO_DESC_NHPIB);
	eval 'sub DIO_ID_IHPIB () {0x;}' unless defined(&DIO_ID_IHPIB);
	eval 'sub DIO_DESC_IHPIB () {"internal HPIB";}' unless defined(&DIO_DESC_IHPIB);
	eval 'sub DIO_ID_SCSI0 () {0x7;}' unless defined(&DIO_ID_SCSI0);
	eval 'sub DIO_DESC_SCSI0 () {"98625A SCSI0";}' unless defined(&DIO_DESC_SCSI0);
	eval 'sub DIO_ID_SCSI1 () {0x27;}' unless defined(&DIO_ID_SCSI1);
	eval 'sub DIO_DESC_SCSI1 () {"98625A SCSI1";}' unless defined(&DIO_DESC_SCSI1);
	eval 'sub DIO_ID_SCSI2 () {0x47;}' unless defined(&DIO_ID_SCSI2);
	eval 'sub DIO_DESC_SCSI2 () {"98625A SCSI2";}' unless defined(&DIO_DESC_SCSI2);
	eval 'sub DIO_ID_SCSI3 () {0x67;}' unless defined(&DIO_ID_SCSI3);
	eval 'sub DIO_DESC_SCSI3 () {"98625A SCSI3";}' unless defined(&DIO_DESC_SCSI3);
	eval 'sub DIO_ID_FBUFFER () {0x39;}' unless defined(&DIO_ID_FBUFFER);
	eval 'sub DIO_DESC_FBUFFER () {"bitmapped display";}' unless defined(&DIO_DESC_FBUFFER);
	eval 'sub DIO_ID_MISC0 () {0x3;}' unless defined(&DIO_ID_MISC0);
	eval 'sub DIO_DESC_MISC0 () {"98622A";}' unless defined(&DIO_DESC_MISC0);
	eval 'sub DIO_ID_MISC1 () {0x4;}' unless defined(&DIO_ID_MISC1);
	eval 'sub DIO_DESC_MISC1 () {"98623A";}' unless defined(&DIO_DESC_MISC1);
	eval 'sub DIO_ID_PARALLEL () {0x6;}' unless defined(&DIO_ID_PARALLEL);
	eval 'sub DIO_DESC_PARALLEL () {"internal parallel";}' unless defined(&DIO_DESC_PARALLEL);
	eval 'sub DIO_ID_MISC2 () {0x9;}' unless defined(&DIO_ID_MISC2);
	eval 'sub DIO_DESC_MISC2 () {"98287A keyboard";}' unless defined(&DIO_DESC_MISC2);
	eval 'sub DIO_ID_MISC3 () {0xa;}' unless defined(&DIO_ID_MISC3);
	eval 'sub DIO_DESC_MISC3 () {"HP98635A FP accelerator";}' unless defined(&DIO_DESC_MISC3);
	eval 'sub DIO_ID_MISC4 () {0xb;}' unless defined(&DIO_ID_MISC4);
	eval 'sub DIO_DESC_MISC4 () {"timer";}' unless defined(&DIO_DESC_MISC4);
	eval 'sub DIO_ID_MISC5 () {0x12;}' unless defined(&DIO_ID_MISC5);
	eval 'sub DIO_DESC_MISC5 () {"98640A";}' unless defined(&DIO_DESC_MISC5);
	eval 'sub DIO_ID_MISC6 () {0x16;}' unless defined(&DIO_ID_MISC6);
	eval 'sub DIO_DESC_MISC6 () {"98659A";}' unless defined(&DIO_DESC_MISC6);
	eval 'sub DIO_ID_MISC7 () {0x19;}' unless defined(&DIO_ID_MISC7);
	eval 'sub DIO_DESC_MISC7 () {"237 display";}' unless defined(&DIO_DESC_MISC7);
	eval 'sub DIO_ID_MISC8 () {0x1a;}' unless defined(&DIO_ID_MISC8);
	eval 'sub DIO_DESC_MISC8 () {"quad-wide card";}' unless defined(&DIO_DESC_MISC8);
	eval 'sub DIO_ID_MISC9 () {0x1b;}' unless defined(&DIO_ID_MISC9);
	eval 'sub DIO_DESC_MISC9 () {"98253A";}' unless defined(&DIO_DESC_MISC9);
	eval 'sub DIO_ID_MISC10 () {0x1c;}' unless defined(&DIO_ID_MISC10);
	eval 'sub DIO_DESC_MISC10 () {"98253A";}' unless defined(&DIO_DESC_MISC10);
	eval 'sub DIO_ID_MISC11 () {0x1d;}' unless defined(&DIO_ID_MISC11);
	eval 'sub DIO_DESC_MISC11 () {"98633A";}' unless defined(&DIO_DESC_MISC11);
	eval 'sub DIO_ID_MISC12 () {0x1e;}' unless defined(&DIO_ID_MISC12);
	eval 'sub DIO_DESC_MISC12 () {"98259A";}' unless defined(&DIO_DESC_MISC12);
	eval 'sub DIO_ID_MISC13 () {0x1f;}' unless defined(&DIO_ID_MISC13);
	eval 'sub DIO_DESC_MISC13 () {"8741";}' unless defined(&DIO_DESC_MISC13);
	eval 'sub DIO_ID_VME () {0x31;}' unless defined(&DIO_ID_VME);
	eval 'sub DIO_DESC_VME () {"98577A VME adapter";}' unless defined(&DIO_DESC_VME);
	eval 'sub DIO_ID_DCL () {0x34;}' unless defined(&DIO_ID_DCL);
	eval 'sub DIO_DESC_DCL () {"98628A DCL serial";}' unless defined(&DIO_DESC_DCL);
	eval 'sub DIO_ID_DCLREM () {0xb4;}' unless defined(&DIO_ID_DCLREM);
	eval 'sub DIO_DESC_DCLREM () {"98628A DCLREM serial";}' unless defined(&DIO_DESC_DCLREM);
	eval 'sub DIO_ID2_GATORBOX () {0x1;}' unless defined(&DIO_ID2_GATORBOX);
	eval 'sub DIO_DESC2_GATORBOX () {"98700/98710 \\"gatorbox\\" display";}' unless defined(&DIO_DESC2_GATORBOX);
	eval 'sub DIO_ID2_TOPCAT () {0x2;}' unless defined(&DIO_ID2_TOPCAT);
	eval 'sub DIO_DESC2_TOPCAT () {"98544/98545/98547 \\"topcat\\" display";}' unless defined(&DIO_DESC2_TOPCAT);
	eval 'sub DIO_ID2_RENAISSANCE () {0x4;}' unless defined(&DIO_ID2_RENAISSANCE);
	eval 'sub DIO_DESC2_RENAISSANCE () {"98720/98721 \\"renaissance\\" display";}' unless defined(&DIO_DESC2_RENAISSANCE);
	eval 'sub DIO_ID2_LRCATSEYE () {0x5;}' unless defined(&DIO_ID2_LRCATSEYE);
	eval 'sub DIO_DESC2_LRCATSEYE () {"low-res catseye display";}' unless defined(&DIO_DESC2_LRCATSEYE);
	eval 'sub DIO_ID2_HRCCATSEYE () {0x6;}' unless defined(&DIO_ID2_HRCCATSEYE);
	eval 'sub DIO_DESC2_HRCCATSEYE () {"high-res color catseye display";}' unless defined(&DIO_DESC2_HRCCATSEYE);
	eval 'sub DIO_ID2_HRMCATSEYE () {0x7;}' unless defined(&DIO_ID2_HRMCATSEYE);
	eval 'sub DIO_DESC2_HRMCATSEYE () {"high-res mono catseye display";}' unless defined(&DIO_DESC2_HRMCATSEYE);
	eval 'sub DIO_ID2_DAVINCI () {0x8;}' unless defined(&DIO_ID2_DAVINCI);
	eval 'sub DIO_DESC2_DAVINCI () {"98730/98731 \\"davinci\\" display";}' unless defined(&DIO_DESC2_DAVINCI);
	eval 'sub DIO_ID2_XXXCATSEYE () {0x9;}' unless defined(&DIO_ID2_XXXCATSEYE);
	eval 'sub DIO_DESC2_XXXCATSEYE () {"catseye display";}' unless defined(&DIO_DESC2_XXXCATSEYE);
	eval 'sub DIO_ID2_HYPERION () {0xe;}' unless defined(&DIO_ID2_HYPERION);
	eval 'sub DIO_DESC2_HYPERION () {"A1096A \\"hyperion\\" display";}' unless defined(&DIO_DESC2_HYPERION);
	eval 'sub DIO_ID2_XGENESIS () {0xb;}' unless defined(&DIO_ID2_XGENESIS);
	eval 'sub DIO_DESC2_XGENESIS () {"\\"x-genesis\\" display";}' unless defined(&DIO_DESC2_XGENESIS);
	eval 'sub DIO_ID2_TIGER () {0xc;}' unless defined(&DIO_ID2_TIGER);
	eval 'sub DIO_DESC2_TIGER () {"\\"tiger\\" display";}' unless defined(&DIO_DESC2_TIGER);
	eval 'sub DIO_ID2_YGENESIS () {0xd;}' unless defined(&DIO_ID2_YGENESIS);
	eval 'sub DIO_DESC2_YGENESIS () {"\\"y-genesis\\" display";}' unless defined(&DIO_DESC2_YGENESIS);
    }
}
1;
