require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_MEMORY_H)) {
    eval 'sub __ASM_ARM_MEMORY_H () {1;}' unless defined(&__ASM_ARM_MEMORY_H);
    require 'linux/config.ph';
    require 'asm/arch/memory.ph';
    eval 'sub PHYS_PFN_OFFSET () {( &PHYS_OFFSET >>  &PAGE_SHIFT);}' unless defined(&PHYS_PFN_OFFSET);
    eval 'sub void {
        eval q(* &phys_to_virt { ( &void *)( &__phys_to_virt(( &x))); });
    }' unless defined(&void);
    eval 'sub __pa {
        local($x) = @_;
	    eval q( &__virt_to_phys(($x)));
    }' unless defined(&__pa);
    eval 'sub __va {
        local($x) = @_;
	    eval q((( &void *) &__phys_to_virt(($x))));
    }' unless defined(&__va);
    eval 'sub virt_to_bus {
        local($x) = @_;
	    eval q(( &__virt_to_bus(($x))));
    }' unless defined(&virt_to_bus);
    eval 'sub bus_to_virt {
        local($x) = @_;
	    eval q((( &void *)( &__bus_to_virt(($x)))));
    }' unless defined(&bus_to_virt);
    unless(defined(&CONFIG_DISCONTIGMEM)) {
	eval 'sub page_to_pfn {
	    local($page) = @_;
    	    eval q(((($page) -  &mem_map) +  &PHYS_PFN_OFFSET));
	}' unless defined(&page_to_pfn);
	eval 'sub pfn_to_page {
	    local($pfn) = @_;
    	    eval q((( &mem_map + ($pfn)) -  &PHYS_PFN_OFFSET));
	}' unless defined(&pfn_to_page);
	eval 'sub pfn_valid {
	    local($pfn) = @_;
    	    eval q((($pfn) >=  &PHYS_PFN_OFFSET  && ($pfn) < ( &PHYS_PFN_OFFSET +  &max_mapnr)));
	}' unless defined(&pfn_valid);
	eval 'sub virt_to_page {
	    local($kaddr) = @_;
    	    eval q(( &pfn_to_page( &__pa($kaddr) >>  &PAGE_SHIFT)));
	}' unless defined(&virt_to_page);
	eval 'sub virt_addr_valid {
	    local($kaddr) = @_;
    	    eval q(( >=  &PAGE_OFFSET  && <  &high_memory));
	}' unless defined(&virt_addr_valid);
	eval 'sub PHYS_TO_NID {
	    local($addr) = @_;
    	    eval q((0));
	}' unless defined(&PHYS_TO_NID);
	eval 'sub VALID_PAGE {
	    local($page) = @_;
    	    eval q((($page -  &mem_map) <  &max_mapnr));
	}' unless defined(&VALID_PAGE);
    } else {
	eval 'sub page_to_pfn {
	    local($page) = @_;
    	    eval q(((($page) -  &page_zone($page)-> &zone_mem_map) + ( &page_zone($page)-> &zone_start_paddr >>  &PAGE_SHIFT)));
	}' unless defined(&page_to_pfn);
	eval 'sub pfn_to_page {
	    local($pfn) = @_;
    	    eval q(( &PFN_TO_MAPBASE($pfn) +  &LOCAL_MAP_NR(($pfn) <<  &PAGE_SHIFT)));
	}' unless defined(&pfn_to_page);
	eval 'sub pfn_valid {
	    local($pfn) = @_;
    	    eval q(({ \'unsigned int node\' =  &PFN_TO_NID($pfn); \'struct pglist_data\' * &nd =  &NODE_DATA( &node); (( &node <  &NR_NODES)  && (($pfn - ( ($nd->{node_start_paddr}) >>  &PAGE_SHIFT)) <  ($nd->{node_size}))); }));
	}' unless defined(&pfn_valid);
	eval 'sub virt_to_page {
	    local($kaddr) = @_;
    	    eval q(( &ADDR_TO_MAPBASE($kaddr) +  &LOCAL_MAP_NR($kaddr)));
	}' unless defined(&virt_to_page);
	eval 'sub virt_addr_valid {
	    local($kaddr) = @_;
    	    eval q(( &KVADDR_TO_NID($kaddr) <  &NR_NODES));
	}' unless defined(&virt_addr_valid);
	eval 'sub PHYS_TO_NID {
	    local($addr) = @_;
    	    eval q( &PFN_TO_NID(($addr) >>  &PAGE_SHIFT));
	}' unless defined(&PHYS_TO_NID);
	eval 'sub VALID_PAGE {
	    local($page) = @_;
    	    eval q(({ \'unsigned int node\' =  &KVADDR_TO_NID; (( &node <  &NR_NODES)  && ((($page) -  &NODE_MEM_MAP( &node)) <  &NODE_DATA( &node)-> &node_size)); }));
	}' unless defined(&VALID_PAGE);
    }
    eval 'sub page_to_phys {
        local($page) = @_;
	    eval q(( &page_to_pfn($page) <<  &PAGE_SHIFT));
    }' unless defined(&page_to_phys);
    eval 'sub page_to_bus {
        local($page) = @_;
	    eval q(( &virt_to_bus( &page_address($page))));
    }' unless defined(&page_to_bus);
}
1;
