require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_MC146818RTC_H)) {
    eval 'sub _ASM_MC146818RTC_H () {1;}' unless defined(&_ASM_MC146818RTC_H);
    require 'asm/arch/irqs.ph';
    require 'asm/io.ph';
    unless(defined(&RTC_PORT)) {
	eval 'sub RTC_PORT {
	    local($x) = @_;
    	    eval q((0x70 + ($x)));
	}' unless defined(&RTC_PORT);
	eval 'sub RTC_ALWAYS_BCD () {1;}' unless defined(&RTC_ALWAYS_BCD);
    }
    eval 'sub CMOS_READ {
        local($addr) = @_;
	    eval q(({  &outb_p(($addr), &RTC_PORT(0));  &inb_p( &RTC_PORT(1)); }));
    }' unless defined(&CMOS_READ);
    eval 'sub CMOS_WRITE {
        local($val, $addr) = @_;
	    eval q(({  &outb_p(($addr), &RTC_PORT(0));  &outb_p(($val), &RTC_PORT(1)); }));
    }' unless defined(&CMOS_WRITE);
    if(defined(&CONFIG_ARCH_RISCSTATION)) {
	undef(&CMOS_READ) if defined(&CMOS_READ);
	undef(&CMOS_WRITE) if defined(&CMOS_WRITE);
	eval 'sub CMOS_READ {
	    local($addr) = @_;
    	    eval q(({  &outb_p(($addr), &RTC_PORT(0));  &outb_p(($addr), &RTC_PORT(3));  &inb_p( &RTC_PORT(1)); }));
	}' unless defined(&CMOS_READ);
	eval 'sub CMOS_WRITE {
	    local($val, $addr) = @_;
    	    eval q(({  &outb_p(($addr), &RTC_PORT(0));  &outb_p(($addr), &RTC_PORT(3));  &outb_p(($val), &RTC_PORT(1)); }));
	}' unless defined(&CMOS_WRITE);
    }
}
1;
