require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_IO_H)) {
    eval 'sub __ASM_ARM_IO_H () {1;}' unless defined(&__ASM_ARM_IO_H);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'asm/byteorder.ph';
	require 'asm/memory.ph';
	require 'asm/arch/hardware.ph';
	eval 'sub __arch_getb {
	    local($a) = @_;
    	    eval q((*( &volatile \'unsigned char\' *)($a)));
	}' unless defined(&__arch_getb);
	eval 'sub __arch_getl {
	    local($a) = @_;
    	    eval q((*( &volatile \'unsigned int\' *)($a)));
	}' unless defined(&__arch_getl);
	eval 'sub __arch_putb {
	    local($v,$a) = @_;
    	    eval q((*( &volatile \'unsigned char\' *)($a) = ($v)));
	}' unless defined(&__arch_putb);
	eval 'sub __arch_putl {
	    local($v,$a) = @_;
    	    eval q((*( &volatile \'unsigned int\' *)($a) = ($v)));
	}' unless defined(&__arch_putl);
	eval 'sub __raw_writeb {
	    local($v,$a) = @_;
    	    eval q( &__arch_putb($v,$a));
	}' unless defined(&__raw_writeb);
	eval 'sub __raw_writew {
	    local($v,$a) = @_;
    	    eval q( &__arch_putw($v,$a));
	}' unless defined(&__raw_writew);
	eval 'sub __raw_writel {
	    local($v,$a) = @_;
    	    eval q( &__arch_putl($v,$a));
	}' unless defined(&__raw_writel);
	eval 'sub __raw_readb {
	    local($a) = @_;
    	    eval q( &__arch_getb($a));
	}' unless defined(&__raw_readb);
	eval 'sub __raw_readw {
	    local($a) = @_;
    	    eval q( &__arch_getw($a));
	}' unless defined(&__raw_readw);
	eval 'sub __raw_readl {
	    local($a) = @_;
    	    eval q( &__arch_getl($a));
	}' unless defined(&__raw_readl);
	eval 'sub __raw_base_writeb {
	    local($val,$base,$off) = @_;
    	    eval q( &__arch_base_putb($val,$base,$off));
	}' unless defined(&__raw_base_writeb);
	eval 'sub __raw_base_writew {
	    local($val,$base,$off) = @_;
    	    eval q( &__arch_base_putw($val,$base,$off));
	}' unless defined(&__raw_base_writew);
	eval 'sub __raw_base_writel {
	    local($val,$base,$off) = @_;
    	    eval q( &__arch_base_putl($val,$base,$off));
	}' unless defined(&__raw_base_writel);
	eval 'sub __raw_base_readb {
	    local($base,$off) = @_;
    	    eval q( &__arch_base_getb($base,$off));
	}' unless defined(&__raw_base_readb);
	eval 'sub __raw_base_readw {
	    local($base,$off) = @_;
    	    eval q( &__arch_base_getw($base,$off));
	}' unless defined(&__raw_base_readw);
	eval 'sub __raw_base_readl {
	    local($base,$off) = @_;
    	    eval q( &__arch_base_getl($base,$off));
	}' unless defined(&__raw_base_readl);
	require 'asm/arch/io.ph';
	if(defined(&__io)) {
	    eval 'sub outb {
	        local($v,$p) = @_;
    		eval q( &__raw_writeb($v, &__io($p)));
	    }' unless defined(&outb);
	    eval 'sub outw {
	        local($v,$p) = @_;
    		eval q( &__raw_writew( &cpu_to_le16($v), &__io($p)));
	    }' unless defined(&outw);
	    eval 'sub outl {
	        local($v,$p) = @_;
    		eval q( &__raw_writel( &cpu_to_le32($v), &__io($p)));
	    }' unless defined(&outl);
	    eval 'sub inb {
	        local($p) = @_;
    		eval q(({ \'unsigned int __v\' =  &__raw_readb( &__io($p));  &__v; }));
	    }' unless defined(&inb);
	    eval 'sub inw {
	        local($p) = @_;
    		eval q(({ \'unsigned int __v\' =  &le16_to_cpu( &__raw_readw( &__io($p)));  &__v; }));
	    }' unless defined(&inw);
	    eval 'sub inl {
	        local($p) = @_;
    		eval q(({ \'unsigned int __v\' =  &le32_to_cpu( &__raw_readl( &__io($p)));  &__v; }));
	    }' unless defined(&inl);
	    eval 'sub outsb {
	        local($p,$d,$l) = @_;
    		eval q( &__raw_writesb( &__io($p),$d,$l));
	    }' unless defined(&outsb);
	    eval 'sub outsw {
	        local($p,$d,$l) = @_;
    		eval q( &__raw_writesw( &__io($p),$d,$l));
	    }' unless defined(&outsw);
	    eval 'sub outsl {
	        local($p,$d,$l) = @_;
    		eval q( &__raw_writesl( &__io($p),$d,$l));
	    }' unless defined(&outsl);
	    eval 'sub insb {
	        local($p,$d,$l) = @_;
    		eval q( &__raw_readsb( &__io($p),$d,$l));
	    }' unless defined(&insb);
	    eval 'sub insw {
	        local($p,$d,$l) = @_;
    		eval q( &__raw_readsw( &__io($p),$d,$l));
	    }' unless defined(&insw);
	    eval 'sub insl {
	        local($p,$d,$l) = @_;
    		eval q( &__raw_readsl( &__io($p),$d,$l));
	    }' unless defined(&insl);
	}
	eval 'sub outb_p {
	    local($val,$port) = @_;
    	    eval q( &outb(($val),($port)));
	}' unless defined(&outb_p);
	eval 'sub outw_p {
	    local($val,$port) = @_;
    	    eval q( &outw(($val),($port)));
	}' unless defined(&outw_p);
	eval 'sub outl_p {
	    local($val,$port) = @_;
    	    eval q( &outl(($val),($port)));
	}' unless defined(&outl_p);
	eval 'sub inb_p {
	    local($port) = @_;
    	    eval q( &inb(($port)));
	}' unless defined(&inb_p);
	eval 'sub inw_p {
	    local($port) = @_;
    	    eval q( &inw(($port)));
	}' unless defined(&inw_p);
	eval 'sub inl_p {
	    local($port) = @_;
    	    eval q( &inl(($port)));
	}' unless defined(&inl_p);
	eval 'sub outsb_p {
	    local($port,$from,$len) = @_;
    	    eval q( &outsb($port,$from,$len));
	}' unless defined(&outsb_p);
	eval 'sub outsw_p {
	    local($port,$from,$len) = @_;
    	    eval q( &outsw($port,$from,$len));
	}' unless defined(&outsw_p);
	eval 'sub outsl_p {
	    local($port,$from,$len) = @_;
    	    eval q( &outsl($port,$from,$len));
	}' unless defined(&outsl_p);
	eval 'sub insb_p {
	    local($port,$to,$len) = @_;
    	    eval q( &insb($port,$to,$len));
	}' unless defined(&insb_p);
	eval 'sub insw_p {
	    local($port,$to,$len) = @_;
    	    eval q( &insw($port,$to,$len));
	}' unless defined(&insw_p);
	eval 'sub insl_p {
	    local($port,$to,$len) = @_;
    	    eval q( &insl($port,$to,$len));
	}' unless defined(&insl_p);
	if(defined(&iomem_valid_addr)) {
	    eval 'sub __arch_ioremap {
	        local($off,$sz,$nocache) = @_;
    		eval q(({ \'unsigned long _off\' = ($off),  &_size = ($sz);  &void * &_ret = ( &void *)0;  &if ( &iomem_valid_addr( &_off,  &_size))  &_ret =  &__ioremap( &iomem_to_phys( &_off), &_size,0);  &_ret; }));
	    }' unless defined(&__arch_ioremap);
	    eval 'sub __arch_iounmap () { &__iounmap;}' unless defined(&__arch_iounmap);
	}
	eval 'sub ioremap {
	    local($off,$sz) = @_;
    	    eval q( &__arch_ioremap(($off),($sz),0));
	}' unless defined(&ioremap);
	eval 'sub ioremap_nocache {
	    local($off,$sz) = @_;
    	    eval q( &__arch_ioremap(($off),($sz),1));
	}' unless defined(&ioremap_nocache);
	eval 'sub iounmap {
	    local($_addr) = @_;
    	    eval q( &__arch_iounmap($_addr));
	}' unless defined(&iounmap);
	if(defined(&__mem_pci)) {
	    eval 'sub readb {
	        local($c) = @_;
    		eval q(({ \'unsigned int __v\' =  &__raw_readb( &__mem_pci($c));  &__v; }));
	    }' unless defined(&readb);
	    eval 'sub readw {
	        local($c) = @_;
    		eval q(({ \'unsigned int __v\' =  &le16_to_cpu( &__raw_readw( &__mem_pci($c)));  &__v; }));
	    }' unless defined(&readw);
	    eval 'sub readl {
	        local($c) = @_;
    		eval q(({ \'unsigned int __v\' =  &le32_to_cpu( &__raw_readl( &__mem_pci($c)));  &__v; }));
	    }' unless defined(&readl);
	    eval 'sub writeb {
	        local($v,$c) = @_;
    		eval q( &__raw_writeb($v, &__mem_pci($c)));
	    }' unless defined(&writeb);
	    eval 'sub writew {
	        local($v,$c) = @_;
    		eval q( &__raw_writew( &cpu_to_le16($v), &__mem_pci($c)));
	    }' unless defined(&writew);
	    eval 'sub writel {
	        local($v,$c) = @_;
    		eval q( &__raw_writel( &cpu_to_le32($v), &__mem_pci($c)));
	    }' unless defined(&writel);
	    eval 'sub memset_io {
	        local($c,$v,$l) = @_;
    		eval q( &_memset_io( &__mem_pci($c),($v),($l)));
	    }' unless defined(&memset_io);
	    eval 'sub memcpy_fromio {
	        local($a,$c,$l) = @_;
    		eval q( &_memcpy_fromio(($a), &__mem_pci($c),($l)));
	    }' unless defined(&memcpy_fromio);
	    eval 'sub memcpy_toio {
	        local($c,$a,$l) = @_;
    		eval q( &_memcpy_toio( &__mem_pci($c),($a),($l)));
	    }' unless defined(&memcpy_toio);
	    eval 'sub eth_io_copy_and_sum {
	        local($s,$c,$l,$b) = @_;
    		eval q( &eth_copy_and_sum(($s), &__mem_pci($c),($l),($b)));
	    }' unless defined(&eth_io_copy_and_sum);
	    eval 'sub check_signature {
	        local($io_addr,$signature,$length) = @_;
    		eval q({ \'int\'  &retval = 0;  &do {  &if ( &readb($io_addr) != *$signature)  &goto  &out; $io_addr++; $signature++; $length--; }  &while ($length);  &retval = 1;  &out:  &retval; });
	    }' unless defined(&check_signature);
	}
 elsif(!defined( &readb)) {
	    eval 'sub readb {
	        local($addr) = @_;
    		eval q(( &__readwrite_bug(\\"readb\\"),0));
	    }' unless defined(&readb);
	    eval 'sub readw {
	        local($addr) = @_;
    		eval q(( &__readwrite_bug(\\"readw\\"),0));
	    }' unless defined(&readw);
	    eval 'sub readl {
	        local($addr) = @_;
    		eval q(( &__readwrite_bug(\\"readl\\"),0));
	    }' unless defined(&readl);
	    eval 'sub writeb {
	        local($v,$addr) = @_;
    		eval q( &__readwrite_bug(\\"writeb\\"));
	    }' unless defined(&writeb);
	    eval 'sub writew {
	        local($v,$addr) = @_;
    		eval q( &__readwrite_bug(\\"writew\\"));
	    }' unless defined(&writew);
	    eval 'sub writel {
	        local($v,$addr) = @_;
    		eval q( &__readwrite_bug(\\"writel\\"));
	    }' unless defined(&writel);
	    eval 'sub eth_io_copy_and_sum {
	        local($a,$b,$c,$d) = @_;
    		eval q( &__readwrite_bug(\\"eth_io_copy_and_sum\\"));
	    }' unless defined(&eth_io_copy_and_sum);
	    eval 'sub check_signature {
	        local($io,$sig,$len) = @_;
    		eval q((0));
	    }' unless defined(&check_signature);
	}
	if(defined(&__mem_isa)) {
	    eval 'sub isa_readb {
	        local($addr) = @_;
    		eval q( &__raw_readb( &__mem_isa($addr)));
	    }' unless defined(&isa_readb);
	    eval 'sub isa_readw {
	        local($addr) = @_;
    		eval q( &__raw_readw( &__mem_isa($addr)));
	    }' unless defined(&isa_readw);
	    eval 'sub isa_readl {
	        local($addr) = @_;
    		eval q( &__raw_readl( &__mem_isa($addr)));
	    }' unless defined(&isa_readl);
	    eval 'sub isa_writeb {
	        local($val,$addr) = @_;
    		eval q( &__raw_writeb($val, &__mem_isa($addr)));
	    }' unless defined(&isa_writeb);
	    eval 'sub isa_writew {
	        local($val,$addr) = @_;
    		eval q( &__raw_writew($val, &__mem_isa($addr)));
	    }' unless defined(&isa_writew);
	    eval 'sub isa_writel {
	        local($val,$addr) = @_;
    		eval q( &__raw_writel($val, &__mem_isa($addr)));
	    }' unless defined(&isa_writel);
	    eval 'sub isa_memset_io {
	        local($a,$b,$c) = @_;
    		eval q( &_memset_io( &__mem_isa($a),($b),($c)));
	    }' unless defined(&isa_memset_io);
	    eval 'sub isa_memcpy_fromio {
	        local($a,$b,$c) = @_;
    		eval q( &_memcpy_fromio(($a), &__mem_isa($b),($c)));
	    }' unless defined(&isa_memcpy_fromio);
	    eval 'sub isa_memcpy_toio {
	        local($a,$b,$c) = @_;
    		eval q( &_memcpy_toio( &__mem_isa(($a)),($b),($c)));
	    }' unless defined(&isa_memcpy_toio);
	    eval 'sub isa_eth_io_copy_and_sum {
	        local($a,$b,$c,$d) = @_;
    		eval q( &eth_copy_and_sum(($a), &__mem_isa($b),($c),($d)));
	    }' unless defined(&isa_eth_io_copy_and_sum);
	    eval 'sub isa_check_signature {
	        local($io_addr,$signature,$length) = @_;
    		eval q({ \'int\'  &retval = 0;  &do {  &if ( &isa_readb($io_addr) != *$signature)  &goto  &out; $io_addr++; $signature++; $length--; }  &while ($length);  &retval = 1;  &out:  &retval; });
	    }' unless defined(&isa_check_signature);
	} else {
	    eval 'sub isa_readb {
	        local($addr) = @_;
    		eval q(( &__readwrite_bug(\\"isa_readb\\"),0));
	    }' unless defined(&isa_readb);
	    eval 'sub isa_readw {
	        local($addr) = @_;
    		eval q(( &__readwrite_bug(\\"isa_readw\\"),0));
	    }' unless defined(&isa_readw);
	    eval 'sub isa_readl {
	        local($addr) = @_;
    		eval q(( &__readwrite_bug(\\"isa_readl\\"),0));
	    }' unless defined(&isa_readl);
	    eval 'sub isa_writeb {
	        local($val,$addr) = @_;
    		eval q( &__readwrite_bug(\\"isa_writeb\\"));
	    }' unless defined(&isa_writeb);
	    eval 'sub isa_writew {
	        local($val,$addr) = @_;
    		eval q( &__readwrite_bug(\\"isa_writew\\"));
	    }' unless defined(&isa_writew);
	    eval 'sub isa_writel {
	        local($val,$addr) = @_;
    		eval q( &__readwrite_bug(\\"isa_writel\\"));
	    }' unless defined(&isa_writel);
	    eval 'sub isa_memset_io {
	        local($a,$b,$c) = @_;
    		eval q( &__readwrite_bug(\\"isa_memset_io\\"));
	    }' unless defined(&isa_memset_io);
	    eval 'sub isa_memcpy_fromio {
	        local($a,$b,$c) = @_;
    		eval q( &__readwrite_bug(\\"isa_memcpy_fromio\\"));
	    }' unless defined(&isa_memcpy_fromio);
	    eval 'sub isa_memcpy_toio {
	        local($a,$b,$c) = @_;
    		eval q( &__readwrite_bug(\\"isa_memcpy_toio\\"));
	    }' unless defined(&isa_memcpy_toio);
	    eval 'sub isa_eth_io_copy_and_sum {
	        local($a,$b,$c,$d) = @_;
    		eval q( &__readwrite_bug(\\"isa_eth_io_copy_and_sum\\"));
	    }' unless defined(&isa_eth_io_copy_and_sum);
	    eval 'sub isa_check_signature {
	        local($io,$sig,$len) = @_;
    		eval q((0));
	    }' unless defined(&isa_check_signature);
	}
    }
}
1;
