require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_USB_H)) {
    eval 'sub __LINUX_USB_H () {1;}' unless defined(&__LINUX_USB_H);
    eval 'sub USB_CLASS_PER_INTERFACE () {0;}' unless defined(&USB_CLASS_PER_INTERFACE);
    eval 'sub USB_CLASS_AUDIO () {1;}' unless defined(&USB_CLASS_AUDIO);
    eval 'sub USB_CLASS_COMM () {2;}' unless defined(&USB_CLASS_COMM);
    eval 'sub USB_CLASS_HID () {3;}' unless defined(&USB_CLASS_HID);
    eval 'sub USB_CLASS_PHYSICAL () {5;}' unless defined(&USB_CLASS_PHYSICAL);
    eval 'sub USB_CLASS_STILL_IMAGE () {6;}' unless defined(&USB_CLASS_STILL_IMAGE);
    eval 'sub USB_CLASS_PRINTER () {7;}' unless defined(&USB_CLASS_PRINTER);
    eval 'sub USB_CLASS_MASS_STORAGE () {8;}' unless defined(&USB_CLASS_MASS_STORAGE);
    eval 'sub USB_CLASS_HUB () {9;}' unless defined(&USB_CLASS_HUB);
    eval 'sub USB_CLASS_CDC_DATA () {0xa;}' unless defined(&USB_CLASS_CDC_DATA);
    eval 'sub USB_CLASS_CSCID () {0xb;}' unless defined(&USB_CLASS_CSCID);
    eval 'sub USB_CLASS_CONTENT_SEC () {0xd;}' unless defined(&USB_CLASS_CONTENT_SEC);
    eval 'sub USB_CLASS_APP_SPEC () {0xfe;}' unless defined(&USB_CLASS_APP_SPEC);
    eval 'sub USB_CLASS_VENDOR_SPEC () {0xff;}' unless defined(&USB_CLASS_VENDOR_SPEC);
    eval 'sub USB_TYPE_MASK () {(0x3 << 5);}' unless defined(&USB_TYPE_MASK);
    eval 'sub USB_TYPE_STANDARD () {(0x << 5);}' unless defined(&USB_TYPE_STANDARD);
    eval 'sub USB_TYPE_CLASS () {(0x1 << 5);}' unless defined(&USB_TYPE_CLASS);
    eval 'sub USB_TYPE_VENDOR () {(0x2 << 5);}' unless defined(&USB_TYPE_VENDOR);
    eval 'sub USB_TYPE_RESERVED () {(0x3 << 5);}' unless defined(&USB_TYPE_RESERVED);
    eval 'sub USB_RECIP_MASK () {0x1f;}' unless defined(&USB_RECIP_MASK);
    eval 'sub USB_RECIP_DEVICE () {0x;}' unless defined(&USB_RECIP_DEVICE);
    eval 'sub USB_RECIP_INTERFACE () {0x1;}' unless defined(&USB_RECIP_INTERFACE);
    eval 'sub USB_RECIP_ENDPOINT () {0x2;}' unless defined(&USB_RECIP_ENDPOINT);
    eval 'sub USB_RECIP_OTHER () {0x3;}' unless defined(&USB_RECIP_OTHER);
    eval 'sub USB_DIR_OUT () {0;}' unless defined(&USB_DIR_OUT);
    eval 'sub USB_DIR_IN () {0x80;}' unless defined(&USB_DIR_IN);
    eval 'sub USB_DT_DEVICE () {0x1;}' unless defined(&USB_DT_DEVICE);
    eval 'sub USB_DT_CONFIG () {0x2;}' unless defined(&USB_DT_CONFIG);
    eval 'sub USB_DT_STRING () {0x3;}' unless defined(&USB_DT_STRING);
    eval 'sub USB_DT_INTERFACE () {0x4;}' unless defined(&USB_DT_INTERFACE);
    eval 'sub USB_DT_ENDPOINT () {0x5;}' unless defined(&USB_DT_ENDPOINT);
    eval 'sub USB_DT_HID () {( &USB_TYPE_CLASS | 0x1);}' unless defined(&USB_DT_HID);
    eval 'sub USB_DT_REPORT () {( &USB_TYPE_CLASS | 0x2);}' unless defined(&USB_DT_REPORT);
    eval 'sub USB_DT_PHYSICAL () {( &USB_TYPE_CLASS | 0x3);}' unless defined(&USB_DT_PHYSICAL);
    eval 'sub USB_DT_HUB () {( &USB_TYPE_CLASS | 0x9);}' unless defined(&USB_DT_HUB);
    eval 'sub USB_DT_DEVICE_SIZE () {18;}' unless defined(&USB_DT_DEVICE_SIZE);
    eval 'sub USB_DT_CONFIG_SIZE () {9;}' unless defined(&USB_DT_CONFIG_SIZE);
    eval 'sub USB_DT_INTERFACE_SIZE () {9;}' unless defined(&USB_DT_INTERFACE_SIZE);
    eval 'sub USB_DT_ENDPOINT_SIZE () {7;}' unless defined(&USB_DT_ENDPOINT_SIZE);
    eval 'sub USB_DT_ENDPOINT_AUDIO_SIZE () {9;}' unless defined(&USB_DT_ENDPOINT_AUDIO_SIZE);
    eval 'sub USB_DT_HUB_NONVAR_SIZE () {7;}' unless defined(&USB_DT_HUB_NONVAR_SIZE);
    eval 'sub USB_DT_HID_SIZE () {9;}' unless defined(&USB_DT_HID_SIZE);
    eval 'sub USB_ENDPOINT_NUMBER_MASK () {0xf;}' unless defined(&USB_ENDPOINT_NUMBER_MASK);
    eval 'sub USB_ENDPOINT_DIR_MASK () {0x80;}' unless defined(&USB_ENDPOINT_DIR_MASK);
    eval 'sub USB_ENDPOINT_XFERTYPE_MASK () {0x3;}' unless defined(&USB_ENDPOINT_XFERTYPE_MASK);
    eval 'sub USB_ENDPOINT_XFER_CONTROL () {0;}' unless defined(&USB_ENDPOINT_XFER_CONTROL);
    eval 'sub USB_ENDPOINT_XFER_ISOC () {1;}' unless defined(&USB_ENDPOINT_XFER_ISOC);
    eval 'sub USB_ENDPOINT_XFER_BULK () {2;}' unless defined(&USB_ENDPOINT_XFER_BULK);
    eval 'sub USB_ENDPOINT_XFER_INT () {3;}' unless defined(&USB_ENDPOINT_XFER_INT);
    eval 'sub USB_PID_UNDEF_0 () {0xf0;}' unless defined(&USB_PID_UNDEF_0);
    eval 'sub USB_PID_OUT () {0xe1;}' unless defined(&USB_PID_OUT);
    eval 'sub USB_PID_ACK () {0xd2;}' unless defined(&USB_PID_ACK);
    eval 'sub USB_PID_DATA0 () {0xc3;}' unless defined(&USB_PID_DATA0);
    eval 'sub USB_PID_PING () {0xb4;}' unless defined(&USB_PID_PING);
    eval 'sub USB_PID_SOF () {0xa5;}' unless defined(&USB_PID_SOF);
    eval 'sub USB_PID_NYET () {0x96;}' unless defined(&USB_PID_NYET);
    eval 'sub USB_PID_DATA2 () {0x87;}' unless defined(&USB_PID_DATA2);
    eval 'sub USB_PID_SPLIT () {0x78;}' unless defined(&USB_PID_SPLIT);
    eval 'sub USB_PID_IN () {0x69;}' unless defined(&USB_PID_IN);
    eval 'sub USB_PID_NAK () {0x5a;}' unless defined(&USB_PID_NAK);
    eval 'sub USB_PID_DATA1 () {0x4b;}' unless defined(&USB_PID_DATA1);
    eval 'sub USB_PID_PREAMBLE () {0x3c;}' unless defined(&USB_PID_PREAMBLE);
    eval 'sub USB_PID_ERR () {0x3c;}' unless defined(&USB_PID_ERR);
    eval 'sub USB_PID_SETUP () {0x2d;}' unless defined(&USB_PID_SETUP);
    eval 'sub USB_PID_STALL () {0x1e;}' unless defined(&USB_PID_STALL);
    eval 'sub USB_PID_MDATA () {0xf;}' unless defined(&USB_PID_MDATA);
    eval 'sub USB_REQ_GET_STATUS () {0x;}' unless defined(&USB_REQ_GET_STATUS);
    eval 'sub USB_REQ_CLEAR_FEATURE () {0x1;}' unless defined(&USB_REQ_CLEAR_FEATURE);
    eval 'sub USB_REQ_SET_FEATURE () {0x3;}' unless defined(&USB_REQ_SET_FEATURE);
    eval 'sub USB_REQ_SET_ADDRESS () {0x5;}' unless defined(&USB_REQ_SET_ADDRESS);
    eval 'sub USB_REQ_GET_DESCRIPTOR () {0x6;}' unless defined(&USB_REQ_GET_DESCRIPTOR);
    eval 'sub USB_REQ_SET_DESCRIPTOR () {0x7;}' unless defined(&USB_REQ_SET_DESCRIPTOR);
    eval 'sub USB_REQ_GET_CONFIGURATION () {0x8;}' unless defined(&USB_REQ_GET_CONFIGURATION);
    eval 'sub USB_REQ_SET_CONFIGURATION () {0x9;}' unless defined(&USB_REQ_SET_CONFIGURATION);
    eval 'sub USB_REQ_GET_INTERFACE () {0xa;}' unless defined(&USB_REQ_GET_INTERFACE);
    eval 'sub USB_REQ_SET_INTERFACE () {0xb;}' unless defined(&USB_REQ_SET_INTERFACE);
    eval 'sub USB_REQ_SYNCH_FRAME () {0xc;}' unless defined(&USB_REQ_SYNCH_FRAME);
    eval 'sub USB_REQ_GET_REPORT () {0x1;}' unless defined(&USB_REQ_GET_REPORT);
    eval 'sub USB_REQ_GET_IDLE () {0x2;}' unless defined(&USB_REQ_GET_IDLE);
    eval 'sub USB_REQ_GET_PROTOCOL () {0x3;}' unless defined(&USB_REQ_GET_PROTOCOL);
    eval 'sub USB_REQ_SET_REPORT () {0x9;}' unless defined(&USB_REQ_SET_REPORT);
    eval 'sub USB_REQ_SET_IDLE () {0xa;}' unless defined(&USB_REQ_SET_IDLE);
    eval 'sub USB_REQ_SET_PROTOCOL () {0xb;}' unless defined(&USB_REQ_SET_PROTOCOL);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'linux/ioctl.ph';
	require 'linux/version.ph';
	require 'linux/sched.ph';
	require 'linux/delay.ph';
	require 'linux/interrupt.ph';
	require 'linux/config.ph';
	require 'linux/list.ph';
	eval 'sub USB_MAJOR () {180;}' unless defined(&USB_MAJOR);
	eval 'sub wait_ms {
	    local($ms) = @_;
    	    eval q({  &if(! &in_interrupt()) {  ($current->{state}) =  &TASK_UNINTERRUPTIBLE;  &schedule_timeout(1+ $ms *  &HZ / 1000); }  &else  &mdelay($ms); });
	}' unless defined(&wait_ms);
	eval 'sub USB_ST_NOERROR () {0;}' unless defined(&USB_ST_NOERROR);
	eval 'sub USB_ST_CRC () {(- &EILSEQ);}' unless defined(&USB_ST_CRC);
	eval 'sub USB_ST_BITSTUFF () {(- &EPROTO);}' unless defined(&USB_ST_BITSTUFF);
	eval 'sub USB_ST_NORESPONSE () {(- &ETIMEDOUT);}' unless defined(&USB_ST_NORESPONSE);
	eval 'sub USB_ST_DATAOVERRUN () {(- &EOVERFLOW);}' unless defined(&USB_ST_DATAOVERRUN);
	eval 'sub USB_ST_DATAUNDERRUN () {(- &EREMOTEIO);}' unless defined(&USB_ST_DATAUNDERRUN);
	eval 'sub USB_ST_BUFFEROVERRUN () {(- &ECOMM);}' unless defined(&USB_ST_BUFFEROVERRUN);
	eval 'sub USB_ST_BUFFERUNDERRUN () {(- &ENOSR);}' unless defined(&USB_ST_BUFFERUNDERRUN);
	eval 'sub USB_ST_INTERNALERROR () {(- &EPROTO);}' unless defined(&USB_ST_INTERNALERROR);
	eval 'sub USB_ST_SHORT_PACKET () {(- &EREMOTEIO);}' unless defined(&USB_ST_SHORT_PACKET);
	eval 'sub USB_ST_PARTIAL_ERROR () {(- &EXDEV);}' unless defined(&USB_ST_PARTIAL_ERROR);
	eval 'sub USB_ST_URB_KILLED () {(- &ENOENT);}' unless defined(&USB_ST_URB_KILLED);
	eval 'sub USB_ST_URB_PENDING () {(- &EINPROGRESS);}' unless defined(&USB_ST_URB_PENDING);
	eval 'sub USB_ST_REMOVED () {(- &ENODEV);}' unless defined(&USB_ST_REMOVED);
	eval 'sub USB_ST_TIMEOUT () {(- &ETIMEDOUT);}' unless defined(&USB_ST_TIMEOUT);
	eval 'sub USB_ST_NOTSUPPORTED () {(- &ENOSYS);}' unless defined(&USB_ST_NOTSUPPORTED);
	eval 'sub USB_ST_BANDWIDTH_ERROR () {(- &ENOSPC);}' unless defined(&USB_ST_BANDWIDTH_ERROR);
	eval 'sub USB_ST_URB_INVALID_ERROR () {(- &EINVAL);}' unless defined(&USB_ST_URB_INVALID_ERROR);
	eval 'sub USB_ST_URB_REQUEST_ERROR () {(- &ENXIO);}' unless defined(&USB_ST_URB_REQUEST_ERROR);
	eval 'sub USB_ST_STALL () {(- &EPIPE);}' unless defined(&USB_ST_STALL);
	eval 'sub USB_MAXBUS () {64;}' unless defined(&USB_MAXBUS);
	eval 'sub USB_MAXCONFIG () {8;}' unless defined(&USB_MAXCONFIG);
	eval 'sub USB_ALTSETTINGALLOC () {4;}' unless defined(&USB_ALTSETTINGALLOC);
	eval 'sub USB_MAXALTSETTING () {128;}' unless defined(&USB_MAXALTSETTING);
	eval 'sub USB_MAXINTERFACES () {32;}' unless defined(&USB_MAXINTERFACES);
	eval 'sub USB_MAXENDPOINTS () {32;}' unless defined(&USB_MAXENDPOINTS);
	eval 'sub USB_DEVICE_ID_MATCH_VENDOR () {0x1;}' unless defined(&USB_DEVICE_ID_MATCH_VENDOR);
	eval 'sub USB_DEVICE_ID_MATCH_PRODUCT () {0x2;}' unless defined(&USB_DEVICE_ID_MATCH_PRODUCT);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_LO () {0x4;}' unless defined(&USB_DEVICE_ID_MATCH_DEV_LO);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_HI () {0x8;}' unless defined(&USB_DEVICE_ID_MATCH_DEV_HI);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_CLASS () {0x10;}' unless defined(&USB_DEVICE_ID_MATCH_DEV_CLASS);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_SUBCLASS () {0x20;}' unless defined(&USB_DEVICE_ID_MATCH_DEV_SUBCLASS);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_PROTOCOL () {0x40;}' unless defined(&USB_DEVICE_ID_MATCH_DEV_PROTOCOL);
	eval 'sub USB_DEVICE_ID_MATCH_INT_CLASS () {0x80;}' unless defined(&USB_DEVICE_ID_MATCH_INT_CLASS);
	eval 'sub USB_DEVICE_ID_MATCH_INT_SUBCLASS () {0x100;}' unless defined(&USB_DEVICE_ID_MATCH_INT_SUBCLASS);
	eval 'sub USB_DEVICE_ID_MATCH_INT_PROTOCOL () {0x200;}' unless defined(&USB_DEVICE_ID_MATCH_INT_PROTOCOL);
	eval 'sub USB_DEVICE_ID_MATCH_DEVICE () {( &USB_DEVICE_ID_MATCH_VENDOR |  &USB_DEVICE_ID_MATCH_PRODUCT);}' unless defined(&USB_DEVICE_ID_MATCH_DEVICE);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_RANGE () {( &USB_DEVICE_ID_MATCH_DEV_LO |  &USB_DEVICE_ID_MATCH_DEV_HI);}' unless defined(&USB_DEVICE_ID_MATCH_DEV_RANGE);
	eval 'sub USB_DEVICE_ID_MATCH_DEVICE_AND_VERSION () {( &USB_DEVICE_ID_MATCH_DEVICE |  &USB_DEVICE_ID_MATCH_DEV_RANGE);}' unless defined(&USB_DEVICE_ID_MATCH_DEVICE_AND_VERSION);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_INFO () {( &USB_DEVICE_ID_MATCH_DEV_CLASS |  &USB_DEVICE_ID_MATCH_DEV_SUBCLASS |  &USB_DEVICE_ID_MATCH_DEV_PROTOCOL);}' unless defined(&USB_DEVICE_ID_MATCH_DEV_INFO);
	eval 'sub USB_DEVICE_ID_MATCH_INT_INFO () {( &USB_DEVICE_ID_MATCH_INT_CLASS |  &USB_DEVICE_ID_MATCH_INT_SUBCLASS |  &USB_DEVICE_ID_MATCH_INT_PROTOCOL);}' unless defined(&USB_DEVICE_ID_MATCH_INT_INFO);
	eval 'sub USB_DEVICE {
	    local($vend,$prod) = @_;
    	    eval q( &match_flags:  &USB_DEVICE_ID_MATCH_DEVICE,  &idVendor: ($vend),  &idProduct: ($prod));
	}' unless defined(&USB_DEVICE);
	eval 'sub USB_DEVICE_VER {
	    local($vend,$prod,$lo,$hi) = @_;
    	    eval q( &match_flags:  &USB_DEVICE_ID_MATCH_DEVICE_AND_VERSION,  &idVendor: ($vend),  &idProduct: ($prod),  &bcdDevice_lo: ($lo),  &bcdDevice_hi: ($hi));
	}' unless defined(&USB_DEVICE_VER);
	eval 'sub USB_DEVICE_INFO {
	    local($cl,$sc,$pr) = @_;
    	    eval q( &match_flags:  &USB_DEVICE_ID_MATCH_DEV_INFO,  &bDeviceClass: ($cl),  &bDeviceSubClass: ($sc),  &bDeviceProtocol: ($pr));
	}' unless defined(&USB_DEVICE_INFO);
	eval 'sub USB_INTERFACE_INFO {
	    local($cl,$sc,$pr) = @_;
    	    eval q( &match_flags:  &USB_DEVICE_ID_MATCH_INT_INFO,  &bInterfaceClass: ($cl),  &bInterfaceSubClass: ($sc),  &bInterfaceProtocol: ($pr));
	}' unless defined(&USB_INTERFACE_INFO);
	eval 'sub USB_DISABLE_SPD () {0x1;}' unless defined(&USB_DISABLE_SPD);
	eval 'sub URB_SHORT_NOT_OK () { &USB_DISABLE_SPD;}' unless defined(&URB_SHORT_NOT_OK);
	eval 'sub USB_ISO_ASAP () {0x2;}' unless defined(&USB_ISO_ASAP);
	eval 'sub USB_ASYNC_UNLINK () {0x8;}' unless defined(&USB_ASYNC_UNLINK);
	eval 'sub USB_QUEUE_BULK () {0x10;}' unless defined(&USB_QUEUE_BULK);
	eval 'sub USB_NO_FSBR () {0x20;}' unless defined(&USB_NO_FSBR);
	eval 'sub USB_ZERO_PACKET () {0x40;}' unless defined(&USB_ZERO_PACKET);
	eval 'sub URB_NO_INTERRUPT () {0x80;}' unless defined(&URB_NO_INTERRUPT);
	eval 'sub USB_TIMEOUT_KILLED () {0x1000;}' unless defined(&USB_TIMEOUT_KILLED);
	eval 'sub usb_iso_packet_descriptor () { &iso_packet_descriptor;}' unless defined(&usb_iso_packet_descriptor);
	eval 'sub FILL_CONTROL_URB {
	    local($URB,$DEV,$PIPE,$SETUP_PACKET,$TRANSFER_BUFFER,$BUFFER_LENGTH,$COMPLETE,$CONTEXT) = @_;
    	    eval q( &do {  &spin_lock_init(($URB)-> &lock); ($URB)-> &dev=$DEV; ($URB)-> &pipe=$PIPE; ($URB)-> &setup_packet=$SETUP_PACKET; ($URB)-> &transfer_buffer=$TRANSFER_BUFFER; ($URB)-> &transfer_buffer_length=$BUFFER_LENGTH; ($URB)-> &complete=$COMPLETE; ($URB)-> &context=$CONTEXT; }  &while (0));
	}' unless defined(&FILL_CONTROL_URB);
	eval 'sub FILL_BULK_URB {
	    local($URB,$DEV,$PIPE,$TRANSFER_BUFFER,$BUFFER_LENGTH,$COMPLETE,$CONTEXT) = @_;
    	    eval q( &do {  &spin_lock_init(($URB)-> &lock); ($URB)-> &dev=$DEV; ($URB)-> &pipe=$PIPE; ($URB)-> &transfer_buffer=$TRANSFER_BUFFER; ($URB)-> &transfer_buffer_length=$BUFFER_LENGTH; ($URB)-> &complete=$COMPLETE; ($URB)-> &context=$CONTEXT; }  &while (0));
	}' unless defined(&FILL_BULK_URB);
	eval 'sub FILL_INT_URB {
	    local($URB,$DEV,$PIPE,$TRANSFER_BUFFER,$BUFFER_LENGTH,$COMPLETE,$CONTEXT,$INTERVAL) = @_;
    	    eval q( &do {  &spin_lock_init(($URB)-> &lock); ($URB)-> &dev=$DEV; ($URB)-> &pipe=$PIPE; ($URB)-> &transfer_buffer=$TRANSFER_BUFFER; ($URB)-> &transfer_buffer_length=$BUFFER_LENGTH; ($URB)-> &complete=$COMPLETE; ($URB)-> &context=$CONTEXT; ($URB)-> &interval=$INTERVAL; ($URB)-> &start_frame=-1; }  &while (0));
	}' unless defined(&FILL_INT_URB);
	eval 'sub FILL_CONTROL_URB_TO {
	    local($a,$aa,$b,$c,$d,$e,$f,$g,$h) = @_;
    	    eval q( &do {  &spin_lock_init(($a)-> &lock); ($a)-> &dev=$aa; ($a)-> &pipe=$b; ($a)-> &setup_packet=$c; ($a)-> &transfer_buffer=$d; ($a)-> &transfer_buffer_length=$e; ($a)-> &complete=$f; ($a)-> &context=$g; ($a)-> &timeout=$h; }  &while (0));
	}' unless defined(&FILL_CONTROL_URB_TO);
	eval 'sub FILL_BULK_URB_TO {
	    local($a,$aa,$b,$c,$d,$e,$f,$g) = @_;
    	    eval q( &do {  &spin_lock_init(($a)-> &lock); ($a)-> &dev=$aa; ($a)-> &pipe=$b; ($a)-> &transfer_buffer=$c; ($a)-> &transfer_buffer_length=$d; ($a)-> &complete=$e; ($a)-> &context=$f; ($a)-> &timeout=$g; }  &while (0));
	}' unless defined(&FILL_BULK_URB_TO);
	eval 'sub DEVNUM_ROUND_ROBIN () {1;}' unless defined(&DEVNUM_ROUND_ROBIN);
	if(defined(&DEVNUM_ROUND_ROBIN)) {
	}
	eval 'sub USB_MAXCHILDREN () {(16);}' unless defined(&USB_MAXCHILDREN);
	eval("sub USB_SPEED_UNKNOWN () { 0; }") unless defined(&USB_SPEED_UNKNOWN);
	eval("sub USB_SPEED_LOW () { 1; }") unless defined(&USB_SPEED_LOW);
	eval("sub USB_SPEED_FULL () { 2; }") unless defined(&USB_SPEED_FULL);
	eval("sub USB_SPEED_HIGH () { 3; }") unless defined(&USB_SPEED_HIGH);
	eval 'sub usb_dec_dev_use () { &usb_free_dev;}' unless defined(&usb_dec_dev_use);
	eval 'sub PIPE_ISOCHRONOUS () {0;}' unless defined(&PIPE_ISOCHRONOUS);
	eval 'sub PIPE_INTERRUPT () {1;}' unless defined(&PIPE_INTERRUPT);
	eval 'sub PIPE_CONTROL () {2;}' unless defined(&PIPE_CONTROL);
	eval 'sub PIPE_BULK () {3;}' unless defined(&PIPE_BULK);
	eval 'sub usb_maxpacket {
	    local($dev, $pipe, $out) = @_;
    	    eval q(($out ? ($dev)-> $epmaxpacketout[ &usb_pipeendpoint($pipe)] : ($dev)-> &epmaxpacketin [ &usb_pipeendpoint($pipe)] ));
	}' unless defined(&usb_maxpacket);
	eval 'sub usb_packetid {
	    local($pipe) = @_;
    	    eval q(((($pipe) &  &USB_DIR_IN) ?  &USB_PID_IN :  &USB_PID_OUT));
	}' unless defined(&usb_packetid);
	eval 'sub usb_pipeout {
	    local($pipe) = @_;
    	    eval q((((($pipe) >> 7) & 1) ^ 1));
	}' unless defined(&usb_pipeout);
	eval 'sub usb_pipein {
	    local($pipe) = @_;
    	    eval q(((($pipe) >> 7) & 1));
	}' unless defined(&usb_pipein);
	eval 'sub usb_pipedevice {
	    local($pipe) = @_;
    	    eval q(((($pipe) >> 8) & 0x7f));
	}' unless defined(&usb_pipedevice);
	eval 'sub usb_pipe_endpdev {
	    local($pipe) = @_;
    	    eval q(((($pipe) >> 8) & 0x7ff));
	}' unless defined(&usb_pipe_endpdev);
	eval 'sub usb_pipeendpoint {
	    local($pipe) = @_;
    	    eval q(((($pipe) >> 15) & 0xf));
	}' unless defined(&usb_pipeendpoint);
	eval 'sub usb_pipedata {
	    local($pipe) = @_;
    	    eval q(((($pipe) >> 19) & 1));
	}' unless defined(&usb_pipedata);
	eval 'sub usb_pipeslow {
	    local($pipe) = @_;
    	    eval q(((($pipe) >> 26) & 1));
	}' unless defined(&usb_pipeslow);
	eval 'sub usb_pipetype {
	    local($pipe) = @_;
    	    eval q(((($pipe) >> 30) & 3));
	}' unless defined(&usb_pipetype);
	eval 'sub usb_pipeisoc {
	    local($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_ISOCHRONOUS));
	}' unless defined(&usb_pipeisoc);
	eval 'sub usb_pipeint {
	    local($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_INTERRUPT));
	}' unless defined(&usb_pipeint);
	eval 'sub usb_pipecontrol {
	    local($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_CONTROL));
	}' unless defined(&usb_pipecontrol);
	eval 'sub usb_pipebulk {
	    local($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_BULK));
	}' unless defined(&usb_pipebulk);
	eval 'sub PIPE_DEVEP_MASK () {0x7ff00;}' unless defined(&PIPE_DEVEP_MASK);
	eval 'sub usb_gettoggle {
	    local($dev, $ep, $out) = @_;
    	    eval q(((($dev)-> $toggle[$out] >> ($ep)) & 1));
	}' unless defined(&usb_gettoggle);
	eval 'sub usb_dotoggle {
	    local($dev, $ep, $out) = @_;
    	    eval q((($dev)-> $toggle[$out] ^= (1<< ($ep))));
	}' unless defined(&usb_dotoggle);
	eval 'sub usb_settoggle {
	    local($dev,$ep,$out,$bit) = @_;
    	    eval q({  ($dev->{toggle[$out]}) &= ~(1<< $ep);  ($dev->{toggle[$out]}) |= $bit << $ep; });
	}' unless defined(&usb_settoggle);
	eval 'sub usb_endpoint_out {
	    local($ep_dir) = @_;
    	    eval q(((($ep_dir >> 7) & 1) ^ 1));
	}' unless defined(&usb_endpoint_out);
	eval 'sub usb_endpoint_halt {
	    local($dev, $ep, $out) = @_;
    	    eval q((($dev)-> $halted[$out] |= (1<< ($ep))));
	}' unless defined(&usb_endpoint_halt);
	eval 'sub usb_endpoint_running {
	    local($dev, $ep, $out) = @_;
    	    eval q((($dev)-> $halted[$out] &= ~(1<< ($ep))));
	}' unless defined(&usb_endpoint_running);
	eval 'sub usb_endpoint_halted {
	    local($dev, $ep, $out) = @_;
    	    eval q((($dev)-> $halted[$out] & (1<< ($ep))));
	}' unless defined(&usb_endpoint_halted);
	eval 'sub __create_pipe {
	    local($dev,$endpoint) = @_;
    	    eval q({ ( ($dev->{devnum}) << 8) | ($endpoint << 15) | (( ($dev->{speed}) ==  &USB_SPEED_LOW) << 26); });
	}' unless defined(&__create_pipe);
	eval 'sub __default_pipe {
	    local($dev) = @_;
    	    eval q({ (( ($dev->{speed}) ==  &USB_SPEED_LOW) << 26); });
	}' unless defined(&__default_pipe);
	eval 'sub usb_sndctrlpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_CONTROL << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndctrlpipe);
	eval 'sub usb_rcvctrlpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_CONTROL << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvctrlpipe);
	eval 'sub usb_sndisocpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_ISOCHRONOUS << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndisocpipe);
	eval 'sub usb_rcvisocpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_ISOCHRONOUS << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvisocpipe);
	eval 'sub usb_sndbulkpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_BULK << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndbulkpipe);
	eval 'sub usb_rcvbulkpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_BULK << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvbulkpipe);
	eval 'sub usb_sndintpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_INTERRUPT << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndintpipe);
	eval 'sub usb_rcvintpipe {
	    local($dev,$endpoint) = @_;
    	    eval q((( &PIPE_INTERRUPT << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvintpipe);
	eval 'sub usb_snddefctrl {
	    local($dev) = @_;
    	    eval q((( &PIPE_CONTROL << 30) |  &__default_pipe($dev)));
	}' unless defined(&usb_snddefctrl);
	eval 'sub usb_rcvdefctrl {
	    local($dev) = @_;
    	    eval q((( &PIPE_CONTROL << 30) |  &__default_pipe($dev) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvdefctrl);
	eval 'sub usb_get_extra_descriptor {
	    local($ifpoint,$type,$ptr) = @_;
    	    eval q( &__usb_get_extra_descriptor(($ifpoint)-> &extra,($ifpoint)-> &extralen,$type,( &void**)$ptr));
	}' unless defined(&usb_get_extra_descriptor);
	if(defined(&DEBUG)) {
	    eval 'sub dbg () {( &format,  &arg...)  &printk( &KERN_DEBUG  &__FILE__ ": "  &format "\\n" ,   &arg);}' unless defined(&dbg);
	} else {
	    eval 'sub dbg () {( &format,  &arg...)  &do {}  &while (0);}' unless defined(&dbg);
	}
	eval 'sub err () {( &format,  &arg...)  &printk( &KERN_ERR  &__FILE__ ": "  &format "\\n" ,   &arg);}' unless defined(&err);
	eval 'sub info () {( &format,  &arg...)  &printk( &KERN_INFO  &__FILE__ ": "  &format "\\n" ,   &arg);}' unless defined(&info);
	eval 'sub warn () {( &format,  &arg...)  &printk( &KERN_WARNING  &__FILE__ ": "  &format "\\n" ,   &arg);}' unless defined(&warn);
	if(defined(&CONFIG_USB_DEVICEFS)) {
	} else {
	}
    }
}
1;
