require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SPINLOCK_H)) {
    eval 'sub __LINUX_SPINLOCK_H () {1;}' unless defined(&__LINUX_SPINLOCK_H);
    require 'linux/config.ph';
    require 'asm/system.ph';
    eval 'sub spin_lock_irqsave {
        local($lock, $flags) = @_;
	    eval q( &do {  &local_irq_save($flags);  &spin_lock($lock); }  &while (0));
    }' unless defined(&spin_lock_irqsave);
    eval 'sub spin_lock_irq {
        local($lock) = @_;
	    eval q( &do {  &local_irq_disable();  &spin_lock($lock); }  &while (0));
    }' unless defined(&spin_lock_irq);
    eval 'sub spin_lock_bh {
        local($lock) = @_;
	    eval q( &do {  &local_bh_disable();  &spin_lock($lock); }  &while (0));
    }' unless defined(&spin_lock_bh);
    eval 'sub read_lock_irqsave {
        local($lock, $flags) = @_;
	    eval q( &do {  &local_irq_save($flags);  &read_lock($lock); }  &while (0));
    }' unless defined(&read_lock_irqsave);
    eval 'sub read_lock_irq {
        local($lock) = @_;
	    eval q( &do {  &local_irq_disable();  &read_lock($lock); }  &while (0));
    }' unless defined(&read_lock_irq);
    eval 'sub read_lock_bh {
        local($lock) = @_;
	    eval q( &do {  &local_bh_disable();  &read_lock($lock); }  &while (0));
    }' unless defined(&read_lock_bh);
    eval 'sub write_lock_irqsave {
        local($lock, $flags) = @_;
	    eval q( &do {  &local_irq_save($flags);  &write_lock($lock); }  &while (0));
    }' unless defined(&write_lock_irqsave);
    eval 'sub write_lock_irq {
        local($lock) = @_;
	    eval q( &do {  &local_irq_disable();  &write_lock($lock); }  &while (0));
    }' unless defined(&write_lock_irq);
    eval 'sub write_lock_bh {
        local($lock) = @_;
	    eval q( &do {  &local_bh_disable();  &write_lock($lock); }  &while (0));
    }' unless defined(&write_lock_bh);
    eval 'sub spin_unlock_irqrestore {
        local($lock, $flags) = @_;
	    eval q( &do {  &spin_unlock($lock);  &local_irq_restore($flags); }  &while (0));
    }' unless defined(&spin_unlock_irqrestore);
    eval 'sub spin_unlock_irq {
        local($lock) = @_;
	    eval q( &do {  &spin_unlock($lock);  &local_irq_enable(); }  &while (0));
    }' unless defined(&spin_unlock_irq);
    eval 'sub spin_unlock_bh {
        local($lock) = @_;
	    eval q( &do {  &spin_unlock($lock);  &local_bh_enable(); }  &while (0));
    }' unless defined(&spin_unlock_bh);
    eval 'sub read_unlock_irqrestore {
        local($lock, $flags) = @_;
	    eval q( &do {  &read_unlock($lock);  &local_irq_restore($flags); }  &while (0));
    }' unless defined(&read_unlock_irqrestore);
    eval 'sub read_unlock_irq {
        local($lock) = @_;
	    eval q( &do {  &read_unlock($lock);  &local_irq_enable(); }  &while (0));
    }' unless defined(&read_unlock_irq);
    eval 'sub read_unlock_bh {
        local($lock) = @_;
	    eval q( &do {  &read_unlock($lock);  &local_bh_enable(); }  &while (0));
    }' unless defined(&read_unlock_bh);
    eval 'sub write_unlock_irqrestore {
        local($lock, $flags) = @_;
	    eval q( &do {  &write_unlock($lock);  &local_irq_restore($flags); }  &while (0));
    }' unless defined(&write_unlock_irqrestore);
    eval 'sub write_unlock_irq {
        local($lock) = @_;
	    eval q( &do {  &write_unlock($lock);  &local_irq_enable(); }  &while (0));
    }' unless defined(&write_unlock_irq);
    eval 'sub write_unlock_bh {
        local($lock) = @_;
	    eval q( &do {  &write_unlock($lock);  &local_bh_enable(); }  &while (0));
    }' unless defined(&write_unlock_bh);
    eval 'sub spin_trylock_bh {
        local($lock) = @_;
	    eval q(({ \'int\'  &__r;  &local_bh_disable();  &__r =  &spin_trylock($lock);  &if (! &__r)  &local_bh_enable();  &__r; }));
    }' unless defined(&spin_trylock_bh);
    require 'linux/stringify.ph';
    eval 'sub LOCK_SECTION_NAME () {".text.lock."  &__stringify( &KBUILD_BASENAME);}' unless defined(&LOCK_SECTION_NAME);
    eval 'sub LOCK_SECTION_START {
        local($extra) = @_;
	    eval q(\\".subsection 1\\\\n\\\\t\\" $extra \\".ifndef \\"  &LOCK_SECTION_NAME \\"\\\\n\\\\t\\"  &LOCK_SECTION_NAME \\":\\\\n\\\\t\\" \\".endif\\\\n\\\\t\\");
    }' unless defined(&LOCK_SECTION_START);
    eval 'sub LOCK_SECTION_END () {".previous\\n\\t";}' unless defined(&LOCK_SECTION_END);
    if(defined(&CONFIG_SMP)) {
	require 'asm/spinlock.ph';
    }
 elsif(!defined( &spin_lock_init) ) {
	eval 'sub DEBUG_SPINLOCKS () {0;}' unless defined(&DEBUG_SPINLOCKS);
	if(((defined(&DEBUG_SPINLOCKS) ? &DEBUG_SPINLOCKS : 0) < 1)) {
	    eval 'sub atomic_dec_and_lock {
	        local($atomic,$lock) = @_;
    		eval q( &atomic_dec_and_test($atomic));
	    }' unless defined(&atomic_dec_and_lock);
	    eval 'sub ATOMIC_DEC_AND_LOCK () {1;}' unless defined(&ATOMIC_DEC_AND_LOCK);
	    if(((defined(&__GNUC__) ? &__GNUC__ : 0) > 2|| (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) > 95)) {
		eval 'sub SPIN_LOCK_UNLOCKED () {( &spinlock_t) { };}' unless defined(&SPIN_LOCK_UNLOCKED);
	    } else {
		eval 'sub SPIN_LOCK_UNLOCKED () {( &spinlock_t) { 0};}' unless defined(&SPIN_LOCK_UNLOCKED);
	    }
	    eval 'sub spin_lock_init {
	        local($lock) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&spin_lock_init);
	    eval 'sub spin_lock {
	        local($lock) = @_;
    		eval q(( &void)($lock));
	    }' unless defined(&spin_lock);
	    eval 'sub spin_is_locked {
	        local($lock) = @_;
    		eval q((0));
	    }' unless defined(&spin_is_locked);
	    eval 'sub spin_trylock {
	        local($lock) = @_;
    		eval q(({1; }));
	    }' unless defined(&spin_trylock);
	    eval 'sub spin_unlock_wait {
	        local($lock) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&spin_unlock_wait);
	    eval 'sub spin_unlock {
	        local($lock) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&spin_unlock);
	}
 elsif(((defined(&DEBUG_SPINLOCKS) ? &DEBUG_SPINLOCKS : 0) < 2)) {
	    eval 'sub SPIN_LOCK_UNLOCKED () {( &spinlock_t) { 0};}' unless defined(&SPIN_LOCK_UNLOCKED);
	    eval 'sub spin_lock_init {
	        local($x) = @_;
    		eval q( &do { ($x)-> &lock = 0; }  &while (0));
	    }' unless defined(&spin_lock_init);
	    eval 'sub spin_is_locked {
	        local($lock) = @_;
    		eval q(( &test_bit(0,($lock))));
	    }' unless defined(&spin_is_locked);
	    eval 'sub spin_trylock {
	        local($lock) = @_;
    		eval q((! &test_and_set_bit(0,($lock))));
	    }' unless defined(&spin_trylock);
	    eval 'sub spin_lock {
	        local($x) = @_;
    		eval q( &do { ($x)-> &lock = 1; }  &while (0));
	    }' unless defined(&spin_lock);
	    eval 'sub spin_unlock_wait {
	        local($x) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&spin_unlock_wait);
	    eval 'sub spin_unlock {
	        local($x) = @_;
    		eval q( &do { ($x)-> &lock = 0; }  &while (0));
	    }' unless defined(&spin_unlock);
	} else {
	    eval 'sub SPIN_LOCK_UNLOCKED () {( &spinlock_t) { 0, 25,  &__BASE_FILE__ };}' unless defined(&SPIN_LOCK_UNLOCKED);
	    require 'linux/kernel.ph';
	    eval 'sub spin_lock_init {
	        local($x) = @_;
    		eval q( &do { ($x)-> &lock = 0; }  &while (0));
	    }' unless defined(&spin_lock_init);
	    eval 'sub spin_is_locked {
	        local($lock) = @_;
    		eval q(( &test_bit(0,($lock))));
	    }' unless defined(&spin_is_locked);
	    eval 'sub spin_trylock {
	        local($lock) = @_;
    		eval q((! &test_and_set_bit(0,($lock))));
	    }' unless defined(&spin_trylock);
	    eval 'sub spin_lock {
	        local($x) = @_;
    		eval q( &do {\'unsigned long __spinflags\';  &save_flags( &__spinflags);  &cli();  &if (($x)-> &lock &&($x)-> &babble) { &printk(\\"%s:%d: spin_lock(%s:%p) already locked\\\\n\\",  &__BASE_FILE__, &__LINE__, ($x)-> &module, ($x));($x)-> &babble--;} ($x)-> &lock = 1;  &restore_flags( &__spinflags);}  &while (0));
	    }' unless defined(&spin_lock);
	    eval 'sub spin_unlock_wait {
	        local($x) = @_;
    		eval q( &do {\'unsigned long __spinflags\';  &save_flags( &__spinflags);  &cli();  &if (($x)-> &lock &&($x)-> &babble) { &printk(\\"%s:%d: spin_unlock_wait(%s:%p) deadlock\\\\n\\",  &__BASE_FILE__, &__LINE__, ($x)-> &module, ($x));($x)-> &babble--;}  &restore_flags( &__spinflags);}  &while (0));
	    }' unless defined(&spin_unlock_wait);
	    eval 'sub spin_unlock {
	        local($x) = @_;
    		eval q( &do {\'unsigned long __spinflags\';  &save_flags( &__spinflags);  &cli();  &if (!($x)-> &lock &&($x)-> &babble) { &printk(\\"%s:%d: spin_unlock(%s:%p) not locked\\\\n\\",  &__BASE_FILE__, &__LINE__, ($x)-> &module, ($x));($x)-> &babble--;} ($x)-> &lock = 0;  &restore_flags( &__spinflags);}  &while (0));
	    }' unless defined(&spin_unlock);
	}
	if(((defined(&__GNUC__) ? &__GNUC__ : 0) > 2|| (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) > 91)) {
	    eval 'sub RW_LOCK_UNLOCKED () {( &rwlock_t) { };}' unless defined(&RW_LOCK_UNLOCKED);
	} else {
	    eval 'sub RW_LOCK_UNLOCKED () {( &rwlock_t) { 0};}' unless defined(&RW_LOCK_UNLOCKED);
	}
	eval 'sub rwlock_init {
	    local($lock) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&rwlock_init);
	eval 'sub read_lock {
	    local($lock) = @_;
    	    eval q(( &void)($lock));
	}' unless defined(&read_lock);
	eval 'sub read_unlock {
	    local($lock) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&read_unlock);
	eval 'sub write_lock {
	    local($lock) = @_;
    	    eval q(( &void)($lock));
	}' unless defined(&write_lock);
	eval 'sub write_unlock {
	    local($lock) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&write_unlock);
    }
    unless(defined(&ATOMIC_DEC_AND_LOCK)) {
	require 'asm/atomic.ph';
    }
    if(defined(&CONFIG_SMP)) {
	require 'linux/cache.ph';
    } else {
    }
}
1;
