require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NFS_PAGE_H)) {
    eval 'sub _LINUX_NFS_PAGE_H () {1;}' unless defined(&_LINUX_NFS_PAGE_H);
    require 'linux/list.ph';
    require 'linux/mm.ph';
    require 'linux/wait.ph';
    require 'linux/sunrpc/auth.ph';
    require 'linux/nfs_xdr.ph';
    eval 'sub PG_BUSY () {0;}' unless defined(&PG_BUSY);
    eval 'sub NFS_WBACK_BUSY {
        local($req) = @_;
	    eval q(( &test_bit( &PG_BUSY,($req)-> &wb_flags)));
    }' unless defined(&NFS_WBACK_BUSY);
    eval 'sub nfs_unlock_request {
        local($req) = @_;
	    eval q({  &if (! &NFS_WBACK_BUSY($req)) {  &printk( &KERN_ERR \\"NFS: Invalid unlock attempted\\\\n\\");  &BUG(); }  &smp_mb__before_clear_bit();  &clear_bit( &PG_BUSY,  ($req->{wb_flags}));  &smp_mb__after_clear_bit();  &if ( &waitqueue_active( ($req->{wb_wait})))  &wake_up_all( ($req->{wb_wait}));  &nfs_release_request($req); });
    }' unless defined(&nfs_unlock_request);
    eval 'sub nfs_list_entry {
        local($head) = @_;
	    eval q({  &list_entry($head, \'struct nfs_page\',  &wb_list); });
    }' unless defined(&nfs_list_entry);
    eval 'sub nfs_inode_wb_entry {
        local($head) = @_;
	    eval q({  &list_entry($head, \'struct nfs_page\',  &wb_hash); });
    }' unless defined(&nfs_inode_wb_entry);
    eval 'sub __nfs_add_lru {
        local($head,$req) = @_;
	    eval q({  &list_add_tail( ($req->{wb_lru}), $head); });
    }' unless defined(&__nfs_add_lru);
    eval 'sub __nfs_del_lru {
        local($req) = @_;
	    eval q({  &if ( &list_empty( ($req->{wb_lru}))) ;  &list_del_init( ($req->{wb_lru})); });
    }' unless defined(&__nfs_del_lru);
    eval 'sub nfs_lru_entry {
        local($head) = @_;
	    eval q({  &list_entry($head, \'struct nfs_page\',  &wb_lru); });
    }' unless defined(&nfs_lru_entry);
}
1;
