require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_WAIT_H)) {
    eval 'sub _LINUX_WAIT_H () {1;}' unless defined(&_LINUX_WAIT_H);
    eval 'sub WNOHANG () {0x1;}' unless defined(&WNOHANG);
    eval 'sub WUNTRACED () {0x2;}' unless defined(&WUNTRACED);
    eval 'sub __WNOTHREAD () {0x20000000;}' unless defined(&__WNOTHREAD);
    eval 'sub __WALL () {0x40000000;}' unless defined(&__WALL);
    eval 'sub __WCLONE () {0x80000000;}' unless defined(&__WCLONE);
    if(defined(&__KERNEL__)) {
	require 'linux/kernel.ph';
	require 'linux/list.ph';
	require 'linux/stddef.ph';
	require 'linux/spinlock.ph';
	require 'linux/config.ph';
	require 'asm/page.ph';
	require 'asm/processor.ph';
	if(defined( &CONFIG_DEBUG_WAITQ)) {
	    eval 'sub WAITQUEUE_DEBUG () {1;}' unless defined(&WAITQUEUE_DEBUG);
	} else {
	    eval 'sub WAITQUEUE_DEBUG () {0;}' unless defined(&WAITQUEUE_DEBUG);
	}
	eval 'sub WQ_FLAG_EXCLUSIVE () {0x1;}' unless defined(&WQ_FLAG_EXCLUSIVE);
	if((defined(&WAITQUEUE_DEBUG) ? &WAITQUEUE_DEBUG : 0)) {
	}
	eval 'sub USE_RW_WAIT_QUEUE_SPINLOCK () {0;}' unless defined(&USE_RW_WAIT_QUEUE_SPINLOCK);
	if((defined(&USE_RW_WAIT_QUEUE_SPINLOCK) ? &USE_RW_WAIT_QUEUE_SPINLOCK : 0)) {
	    eval 'sub wq_lock_t () { &rwlock_t;}' unless defined(&wq_lock_t);
	    eval 'sub WAITQUEUE_RW_LOCK_UNLOCKED () { &RW_LOCK_UNLOCKED;}' unless defined(&WAITQUEUE_RW_LOCK_UNLOCKED);
	    eval 'sub wq_read_lock () { &read_lock;}' unless defined(&wq_read_lock);
	    eval 'sub wq_read_lock_irqsave () { &read_lock_irqsave;}' unless defined(&wq_read_lock_irqsave);
	    eval 'sub wq_read_unlock_irqrestore () { &read_unlock_irqrestore;}' unless defined(&wq_read_unlock_irqrestore);
	    eval 'sub wq_read_unlock () { &read_unlock;}' unless defined(&wq_read_unlock);
	    eval 'sub wq_write_lock_irq () { &write_lock_irq;}' unless defined(&wq_write_lock_irq);
	    eval 'sub wq_write_lock_irqsave () { &write_lock_irqsave;}' unless defined(&wq_write_lock_irqsave);
	    eval 'sub wq_write_unlock_irqrestore () { &write_unlock_irqrestore;}' unless defined(&wq_write_unlock_irqrestore);
	    eval 'sub wq_write_unlock () { &write_unlock;}' unless defined(&wq_write_unlock);
	} else {
	    eval 'sub wq_lock_t () { &spinlock_t;}' unless defined(&wq_lock_t);
	    eval 'sub WAITQUEUE_RW_LOCK_UNLOCKED () { &SPIN_LOCK_UNLOCKED;}' unless defined(&WAITQUEUE_RW_LOCK_UNLOCKED);
	    eval 'sub wq_read_lock () { &spin_lock;}' unless defined(&wq_read_lock);
	    eval 'sub wq_read_lock_irqsave () { &spin_lock_irqsave;}' unless defined(&wq_read_lock_irqsave);
	    eval 'sub wq_read_unlock () { &spin_unlock;}' unless defined(&wq_read_unlock);
	    eval 'sub wq_read_unlock_irqrestore () { &spin_unlock_irqrestore;}' unless defined(&wq_read_unlock_irqrestore);
	    eval 'sub wq_write_lock_irq () { &spin_lock_irq;}' unless defined(&wq_write_lock_irq);
	    eval 'sub wq_write_lock_irqsave () { &spin_lock_irqsave;}' unless defined(&wq_write_lock_irqsave);
	    eval 'sub wq_write_unlock_irqrestore () { &spin_unlock_irqrestore;}' unless defined(&wq_write_unlock_irqrestore);
	    eval 'sub wq_write_unlock () { &spin_unlock;}' unless defined(&wq_write_unlock);
	}
	if((defined(&WAITQUEUE_DEBUG) ? &WAITQUEUE_DEBUG : 0)) {
	}
	if((defined(&WAITQUEUE_DEBUG) ? &WAITQUEUE_DEBUG : 0)) {
	    eval 'sub WQ_BUG () {
	        eval q( &BUG());
	    }' unless defined(&WQ_BUG);
	    eval 'sub CHECK_MAGIC {
	        local($x) = @_;
    		eval q( &do {  &if ( != ) {  &printk(\\"bad magic %lx (should be %lx), \\", $x, ($x));  &WQ_BUG(); } }  &while (0));
	    }' unless defined(&CHECK_MAGIC);
	    eval 'sub CHECK_MAGIC_WQHEAD {
	        local($x) = @_;
    		eval q( &do {  &if (($x)-> &__magic != (($x)-> &__magic)) {  &printk(\\"bad magic %lx (should be %lx, creator %lx), \\", ($x)-> &__magic, (($x)-> &__magic), ($x)-> &__creator);  &WQ_BUG(); } }  &while (0));
	    }' unless defined(&CHECK_MAGIC_WQHEAD);
	    eval 'sub WQ_CHECK_LIST_HEAD {
	        local($list) = @_;
    		eval q( &do {  &if (!($list)-> &next || !($list)-> &prev)  &WQ_BUG(); }  &while(0));
	    }' unless defined(&WQ_CHECK_LIST_HEAD);
	    eval 'sub WQ_NOTE_WAKER {
	        local($tsk) = @_;
    		eval q( &do { -> &__waker =  &__builtin_return_address(0); }  &while (0));
	    }' unless defined(&WQ_NOTE_WAKER);
	} else {
	    eval 'sub WQ_BUG () {
	        eval q();
	    }' unless defined(&WQ_BUG);
	    eval 'sub CHECK_MAGIC {
	        local($x) = @_;
    		eval q();
	    }' unless defined(&CHECK_MAGIC);
	    eval 'sub CHECK_MAGIC_WQHEAD {
	        local($x) = @_;
    		eval q();
	    }' unless defined(&CHECK_MAGIC_WQHEAD);
	    eval 'sub WQ_CHECK_LIST_HEAD {
	        local($list) = @_;
    		eval q();
	    }' unless defined(&WQ_CHECK_LIST_HEAD);
	    eval 'sub WQ_NOTE_WAKER {
	        local($tsk) = @_;
    		eval q();
	    }' unless defined(&WQ_NOTE_WAKER);
	}
	if((defined(&WAITQUEUE_DEBUG) ? &WAITQUEUE_DEBUG : 0)) {
	    eval 'sub __WAITQUEUE_DEBUG_INIT {
	        local($name) = @_;
    		eval q(($name). &__magic, 0);
	    }' unless defined(&__WAITQUEUE_DEBUG_INIT);
	    eval 'sub __WAITQUEUE_HEAD_DEBUG_INIT {
	        local($name) = @_;
    		eval q(($name). &__magic, ($name). &__magic);
	    }' unless defined(&__WAITQUEUE_HEAD_DEBUG_INIT);
	} else {
	    eval 'sub __WAITQUEUE_DEBUG_INIT {
	        local($name) = @_;
    		eval q();
	    }' unless defined(&__WAITQUEUE_DEBUG_INIT);
	    eval 'sub __WAITQUEUE_HEAD_DEBUG_INIT {
	        local($name) = @_;
    		eval q();
	    }' unless defined(&__WAITQUEUE_HEAD_DEBUG_INIT);
	}
	eval 'sub __WAITQUEUE_INITIALIZER {
	    local($name, $tsk) = @_;
    	    eval q({  &task: $tsk,  &task_list: {  &NULL,  &NULL },  &__WAITQUEUE_DEBUG_INIT($name)});
	}' unless defined(&__WAITQUEUE_INITIALIZER);
	eval 'sub DECLARE_WAITQUEUE {
	    local($name, $tsk) = @_;
    	    eval q( &wait_queue_t $name =  &__WAITQUEUE_INITIALIZER($name, $tsk));
	}' unless defined(&DECLARE_WAITQUEUE);
	eval 'sub __WAIT_QUEUE_HEAD_INITIALIZER {
	    local($name) = @_;
    	    eval q({  &lock:  &WAITQUEUE_RW_LOCK_UNLOCKED,  &task_list: { ($name). &task_list, ($name). &task_list },  &__WAITQUEUE_HEAD_DEBUG_INIT($name)});
	}' unless defined(&__WAIT_QUEUE_HEAD_INITIALIZER);
	eval 'sub DECLARE_WAIT_QUEUE_HEAD {
	    local($name) = @_;
    	    eval q( &wait_queue_head_t $name =  &__WAIT_QUEUE_HEAD_INITIALIZER($name));
	}' unless defined(&DECLARE_WAIT_QUEUE_HEAD);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub init_waitqueue_head {
	    local($q) = @_;
    	    eval q({  ($q->{lock}) =  &WAITQUEUE_RW_LOCK_UNLOCKED;  &INIT_LIST_HEAD( ($q->{task_list})); });
	}' unless defined(&init_waitqueue_head);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub init_waitqueue_entry {
	    local($q,$p) = @_;
    	    eval q({  ($q->{flags}) = 0;  ($q->{task}) = $p; });
	}' unless defined(&init_waitqueue_entry);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub waitqueue_active {
	    local($q) = @_;
    	    eval q({ ! &list_empty( ($q->{task_list})); });
	}' unless defined(&waitqueue_active);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub __add_wait_queue {
	    local($head,$new) = @_;
    	    eval q({  &list_add( ($new->{task_list}),  ($head->{task_list})); });
	}' unless defined(&__add_wait_queue);
	if((defined(&WAITQUEUE_DEBUG) ? &WAITQUEUE_DEBUG : 0)) {
	}
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub __remove_wait_queue {
	    local($head,$old) = @_;
    	    eval q({  &list_del( ($old->{task_list})); });
	}' unless defined(&__remove_wait_queue);
    }
}
1;
