require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__INTERMEZZO_FS_H_)) {
    eval 'sub __INTERMEZZO_FS_H_ () {1;}' unless defined(&__INTERMEZZO_FS_H_);
    require 'linux/intermezzo_lib.ph';
    require 'linux/intermezzo_idl.ph';
    if(defined(&__KERNEL__)) {
    } else {
	require 'uuid/uuid.ph';
    }
    if(defined(&__KERNEL__)) {
	require 'linux/smp.ph';
	require 'linux/fsfilter.ph';
	require 'linux/slab.ph';
	require 'linux/vmalloc.ph';
	require 'linux/smp_lock.ph';
	unless(defined(&fs_down)) {
	    eval 'sub fs_down {
	        local($sem) = @_;
    		eval q( &down($sem));
	    }' unless defined(&fs_down);
	}
	unless(defined(&fs_up)) {
	    eval 'sub fs_up {
	        local($sem) = @_;
    		eval q( &up($sem));
	    }' unless defined(&fs_up);
	}
	eval 'sub KML_IDLE () {0;}' unless defined(&KML_IDLE);
	eval 'sub KML_DECODE () {1;}' unless defined(&KML_DECODE);
	eval 'sub KML_OPTIMIZE () {2;}' unless defined(&KML_OPTIMIZE);
	eval 'sub KML_REINT () {3;}' unless defined(&KML_REINT);
	eval 'sub KML_OPEN_REINT () {0x100;}' unless defined(&KML_OPEN_REINT);
	eval 'sub KML_REINT_BEGIN () {0x200;}' unless defined(&KML_REINT_BEGIN);
	eval 'sub KML_BACKFETCH () {0x400;}' unless defined(&KML_BACKFETCH);
	eval 'sub KML_REINT_END () {0x800;}' unless defined(&KML_REINT_END);
	eval 'sub KML_CLOSE_REINT () {0x1000;}' unless defined(&KML_CLOSE_REINT);
	eval 'sub KML_REINT_MAXBUF () {(64* 1024);}' unless defined(&KML_REINT_MAXBUF);
	eval 'sub CACHE_CLIENT_RO () {0x4;}' unless defined(&CACHE_CLIENT_RO);
	eval 'sub CACHE_LENTO_RO () {0x8;}' unless defined(&CACHE_LENTO_RO);
	eval 'sub PRESTO_DEBUG () {1;}' unless defined(&PRESTO_DEBUG);
	if(defined(&PRESTO_DEBUG)) {
	    eval 'sub D_SUPER () {1;}' unless defined(&D_SUPER);
	    eval 'sub D_INODE () {2;}' unless defined(&D_INODE);
	    eval 'sub D_FILE () {4;}' unless defined(&D_FILE);
	    eval 'sub D_CACHE () {8;}' unless defined(&D_CACHE);
	    eval 'sub D_MALLOC () {16;}' unless defined(&D_MALLOC);
	    eval 'sub D_JOURNAL () {32;}' unless defined(&D_JOURNAL);
	    eval 'sub D_UPCALL () {64;}' unless defined(&D_UPCALL);
	    eval 'sub D_PSDEV () {128;}' unless defined(&D_PSDEV);
	    eval 'sub D_PIOCTL () {256;}' unless defined(&D_PIOCTL);
	    eval 'sub D_SPECIAL () {512;}' unless defined(&D_SPECIAL);
	    eval 'sub D_TIMING () {1024;}' unless defined(&D_TIMING);
	    eval 'sub D_DOWNCALL () {2048;}' unless defined(&D_DOWNCALL);
	    eval 'sub D_KML () {4096;}' unless defined(&D_KML);
	    eval 'sub D_FSDATA () {8192;}' unless defined(&D_FSDATA);
	    eval 'sub CDEBUG () {( &mask,  &format,  &a...)  &do {  &if ( &presto_debug &  &mask) {  &printk("(%s:%s,l. %d %d): "  &format,  &__FILE__,  &__FUNCTION__,  &__LINE__,  ($current->{pid})  ,   &a); } }  &while (0);}' unless defined(&CDEBUG);
	    eval 'sub CERROR () {( &format,  &a...)  &do {  &printk("(%s:%s,l. %d %d): "  &format,  &__FILE__,  &__FUNCTION__,  &__LINE__,  ($current->{pid}) ,   &a); }  &while (0);}' unless defined(&CERROR);
	    eval 'sub ENTRY () { &if ( &presto_print_entry)  &printk("Process %d entered %s\\n",  ($current->{pid}),  &__FUNCTION__);}' unless defined(&ENTRY);
	    eval 'sub EXIT () { &if ( &presto_print_entry)  &printk("Process %d leaving %s at %d\\n",  ($current->{pid}),  &__FUNCTION__,  &__LINE__);}' unless defined(&EXIT);
	    eval 'sub presto_kmem_inc {
	        local($ptr, $size) = @_;
    		eval q( &presto_kmemory += ($size));
	    }' unless defined(&presto_kmem_inc);
	    eval 'sub presto_kmem_dec {
	        local($ptr, $size) = @_;
    		eval q( &presto_kmemory -= ($size));
	    }' unless defined(&presto_kmem_dec);
	    eval 'sub presto_vmem_inc {
	        local($ptr, $size) = @_;
    		eval q( &presto_vmemory += ($size));
	    }' unless defined(&presto_vmem_inc);
	    eval 'sub presto_vmem_dec {
	        local($ptr, $size) = @_;
    		eval q( &presto_vmemory -= ($size));
	    }' unless defined(&presto_vmem_dec);
	} else {
	    eval 'sub CDEBUG () {( &mask,  &format,  &a...)  &do {}  &while (0);}' unless defined(&CDEBUG);
	    eval 'sub ENTRY () { &do {}  &while (0);}' unless defined(&ENTRY);
	    eval 'sub EXIT () { &do {}  &while (0);}' unless defined(&EXIT);
	    eval 'sub presto_kmem_inc {
	        local($ptr, $size) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&presto_kmem_inc);
	    eval 'sub presto_kmem_dec {
	        local($ptr, $size) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&presto_kmem_dec);
	    eval 'sub presto_vmem_inc {
	        local($ptr, $size) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&presto_vmem_inc);
	    eval 'sub presto_vmem_dec {
	        local($ptr, $size) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&presto_vmem_dec);
	}
	eval 'sub presto_dentry_data {
	    eval q(* &presto_d2d(\'struct dentry\' * &dentry) { ( ($dentry->{d_fsdata})); });
	}' unless defined(&presto_dentry_data);
	eval 'sub CHUNK_BITS () {16;}' unless defined(&CHUNK_BITS);
	eval 'sub FSET_DEFAULT_MAX_FILEIO () {(1024<<10);}' unless defined(&FSET_DEFAULT_MAX_FILEIO);
	eval 'sub LENTO_FL_KML () {0x1;}' unless defined(&LENTO_FL_KML);
	eval 'sub LENTO_FL_EXPECT () {0x2;}' unless defined(&LENTO_FL_EXPECT);
	eval 'sub LENTO_FL_VFSCHECK () {0x4;}' unless defined(&LENTO_FL_VFSCHECK);
	eval 'sub LENTO_FL_JUSTLOG () {0x8;}' unless defined(&LENTO_FL_JUSTLOG);
	eval 'sub LENTO_FL_WRITE_KML () {0x10;}' unless defined(&LENTO_FL_WRITE_KML);
	eval 'sub LENTO_FL_CANCEL_LML () {0x20;}' unless defined(&LENTO_FL_CANCEL_LML);
	eval 'sub LENTO_FL_WRITE_EXPECT () {0x40;}' unless defined(&LENTO_FL_WRITE_EXPECT);
	eval 'sub LENTO_FL_IGNORE_TIME () {0x80;}' unless defined(&LENTO_FL_IGNORE_TIME);
	eval 'sub LENTO_FL_TOUCH_PARENT () {0x100;}' unless defined(&LENTO_FL_TOUCH_PARENT);
	eval 'sub LENTO_FL_TOUCH_NEWOBJ () {0x200;}' unless defined(&LENTO_FL_TOUCH_NEWOBJ);
	eval 'sub LENTO_FL_SET_DDFILEID () {0x400;}' unless defined(&LENTO_FL_SET_DDFILEID);
	eval 'sub PRESTO_ILOOKUP_MAGIC () {"...ino:";}' unless defined(&PRESTO_ILOOKUP_MAGIC);
	eval 'sub PRESTO_ILOOKUP_SEP () {ord(\':\');}' unless defined(&PRESTO_ILOOKUP_SEP);
	eval 'sub PRESTO_REQLOW () {(3* 4096);}' unless defined(&PRESTO_REQLOW);
	eval 'sub PRESTO_REQHIGH () {(6* 4096);}' unless defined(&PRESTO_REQHIGH);
	eval 'sub PRESTO_DATA () {0x2;}' unless defined(&PRESTO_DATA);
	eval 'sub PRESTO_ATTR () {0x4;}' unless defined(&PRESTO_ATTR);
	eval 'sub PRESTO_DONT_JOURNAL () {0x8;}' unless defined(&PRESTO_DONT_JOURNAL);
	eval 'sub JOURNAL_PAGE_SZ () { &PAGE_SIZE;}' unless defined(&JOURNAL_PAGE_SZ);
	eval 'sub SYNCHRONOUS () {0;}' unless defined(&SYNCHRONOUS);
	eval 'sub ASYNCHRONOUS () {1;}' unless defined(&ASYNCHRONOUS);
	eval 'sub PRESTO_EXT_ATTR_NAME_MAX () {128;}' unless defined(&PRESTO_EXT_ATTR_NAME_MAX);
	eval 'sub PRESTO_EXT_ATTR_VALUE_MAX () {8192;}' unless defined(&PRESTO_EXT_ATTR_VALUE_MAX);
	eval 'sub PRESTO_ALLOC {
	    local($ptr, $size) = @_;
    	    eval q( &do { \'long s\' = ($size); ($ptr) =  &kmalloc( &s,  &GFP_KERNEL);  &if (($ptr) ==  &NULL)  &CERROR(\\"IZO: out of memory at %s:%d (trying to \\" \\"allocate %ld)\\\\n\\",  &__FILE__,  &__LINE__,  &s);  &else {  &presto_kmem_inc(($ptr),  &s);  &memset(($ptr), 0,  &s); }  &CDEBUG( &D_MALLOC, \\"kmalloced: %ld at %p (tot %ld).\\\\n\\",  &s, ($ptr),  &presto_kmemory); }  &while (0));
	}' unless defined(&PRESTO_ALLOC);
	eval 'sub PRESTO_FREE {
	    local($ptr, $size) = @_;
    	    eval q( &do { \'long s\' = ($size);  &if (($ptr) ==  &NULL) {  &CERROR(\\"IZO: free NULL pointer (%ld bytes) at \\" \\"%s:%d\\\\n\\",  &s,  &__FILE__,  &__LINE__);  &break; }  &kfree($ptr);  &CDEBUG( &D_MALLOC, \\"kfreed: %ld at %p (tot %ld).\\\\n\\",  &s, ($ptr),  &presto_kmemory);  &presto_kmem_dec(($ptr),  &s); }  &while (0));
	}' unless defined(&PRESTO_FREE);
	eval 'sub dentry_name_cmp {
	    local($dentry,$name) = @_;
    	    eval q({ ( &strlen($name) ==  ($dentry->{d_name}->{len})  &&  &memcmp($name,  ($dentry->{d_name}->{name}),  ($dentry->{d_name}->{len})) == 0); });
	}' unless defined(&dentry_name_cmp);
	eval 'sub char {
	    eval q(* &strdup(\'char\' * &str) { \'char\' * &tmp;  &tmp =  &kmalloc( &strlen( &str) + 1,  &GFP_KERNEL);  &if ( &tmp)  &memcpy( &tmp,  &str,  &strlen( &str) + 1);  &tmp; });
	}' unless defined(&char);
	eval 'sub MYPATHLEN {
	    local($buffer, $path) = @_;
    	    eval q((($buffer) +  &PAGE_SIZE - ($path)));
	}' unless defined(&MYPATHLEN);
	eval 'sub free () { &kfree;}' unless defined(&free);
	eval 'sub malloc {
	    local($a) = @_;
    	    eval q( &kmalloc($a,  &GFP_KERNEL));
	}' unless defined(&malloc);
	eval 'sub printf () { &printk;}' unless defined(&printf);
    } else {
	require 'stdlib.ph';
	require 'stdio.ph';
	require 'sys/types.ph';
	require 'sys/ioctl.ph';
	require 'string.ph';
	eval 'sub printk () { &printf;}' unless defined(&printk);
	unless(defined(&CERROR)) {
	    eval 'sub CERROR () { &printf;}' unless defined(&CERROR);
	}
	eval 'sub kmalloc {
	    local($a,$b) = @_;
    	    eval q( &malloc($a));
	}' unless defined(&kmalloc);
	eval 'sub izo_ioctl_init {
	    local($data) = @_;
    	    eval q({  &memset($data, 0, $sizeof{$data});  ($data->{ioc_len}) = $sizeof{$data};  ($data->{ioc_version}) =  &IZO_IOCTL_VERSION; });
	}' unless defined(&izo_ioctl_init);
	eval 'sub izo_ioctl_pack {
	    local($data,$pbuf,$max) = @_;
    	    eval q({ \'char\' * &ptr; \'struct izo_ioctl_data\' * &overlay;  ($data->{ioc_len}) =  &izo_ioctl_packlen($data);  ($data->{ioc_version}) =  &IZO_IOCTL_VERSION;  &if (*$pbuf  &&  &izo_ioctl_packlen($data) > $max) 1;  &if (*$pbuf ==  &NULL) *$pbuf =  &malloc( ($data->{ioc_len}));  &if (*$pbuf ==  &NULL) 1;  &overlay = *$pbuf;  &memcpy(*$pbuf, $data, $sizeof{$data});  &ptr =  ($overlay->{ioc_bulk});  &if ( ($data->{ioc_inlbuf1}))  &LOGL( ($data->{ioc_inlbuf1}),  ($data->{ioc_inllen1}),  &ptr);  &if ( ($data->{ioc_inlbuf2}))  &LOGL( ($data->{ioc_inlbuf2}),  ($data->{ioc_inllen2}),  &ptr);  &if ( &izo_ioctl_is_invalid( &overlay)) 1; 0; });
	}' unless defined(&izo_ioctl_pack);
    }
    eval 'sub IZO_ERROR_NAME () {1;}' unless defined(&IZO_ERROR_NAME);
    eval 'sub IZO_ERROR_UPDATE () {2;}' unless defined(&IZO_ERROR_UPDATE);
    eval 'sub IZO_ERROR_DELETE () {3;}' unless defined(&IZO_ERROR_DELETE);
    eval 'sub IZO_ERROR_RENAME () {4;}' unless defined(&IZO_ERROR_RENAME);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub char {
        eval q(* &izo_error(\'int\'  &err) {  &switch ( &err) {  &case  &IZO_ERROR_NAME: \\"InterMezzo name/name conflict\\";  &case  &IZO_ERROR_UPDATE: \\"InterMezzo update/update conflict\\";  &case  &IZO_ERROR_DELETE: \\"InterMezzo update/delete conflict\\";  &case  &IZO_ERROR_RENAME: \\"InterMezzo rename/rename conflict\\"; } \\"Unknown InterMezzo error\\"; });
    }' unless defined(&char);
    eval 'sub izo_ioctl_packlen {
        local($data) = @_;
	    eval q({ \'int\'  &len = $sizeof{\'struct izo_ioctl_data\'};  &len +=  &size_round( ($data->{ioc_inllen1}));  &len +=  &size_round( ($data->{ioc_inllen2}));  &len; });
    }' unless defined(&izo_ioctl_packlen);
    eval 'sub izo_ioctl_is_invalid {
        local($data) = @_;
	    eval q({  &if ( ($data->{ioc_len}) > (1<<30)) {  &CERROR(\\"IZO ioctl: ioc_len larger than 1<<30\\\\n\\"); 1; }  &if ( ($data->{ioc_inllen1}) > (1<<30)) {  &CERROR(\\"IZO ioctl: ioc_inllen1 larger than 1<<30\\\\n\\"); 1; }  &if ( ($data->{ioc_inllen2}) > (1<<30)) {  &CERROR(\\"IZO ioctl: ioc_inllen2 larger than 1<<30\\\\n\\"); 1; }  &if ( ($data->{ioc_inlbuf1})  && ! ($data->{ioc_inllen1})) {  &CERROR(\\"IZO ioctl: inlbuf1 pointer but 0 length\\\\n\\"); 1; }  &if ( ($data->{ioc_inlbuf2})  && ! ($data->{ioc_inllen2})) {  &CERROR(\\"IZO ioctl: inlbuf2 pointer but 0 length\\\\n\\"); 1; }  &if ( ($data->{ioc_pbuf1})  && ! ($data->{ioc_plen1})) {  &CERROR(\\"IZO ioctl: pbuf1 pointer but 0 length\\\\n\\"); 1; }  &if ( ($data->{ioc_pbuf2})  && ! ($data->{ioc_plen2})) {  &CERROR(\\"IZO ioctl: pbuf2 pointer but 0 length\\\\n\\"); 1; }  &if ( &izo_ioctl_packlen($data) !=  ($data->{ioc_len}) ) {  &CERROR(\\"IZO ioctl: packlen exceeds ioc_len\\\\n\\"); 1; }  &if ( ($data->{ioc_inllen1})  &&  ($data->{ioc_bulk[$data}->{ioc_inllen1 }- 1]) != ord(\'\\\\0\')) {  &CERROR(\\"IZO ioctl: inlbuf1 not 0 terminated\\\\n\\"); 1; }  &if ( ($data->{ioc_inllen2})  &&  ($data->{ioc_bulk[size_round($data}->{ioc_inllen1) + data}->{ioc_inllen2			    }- 1]) != ord(\'\\\\0\')) {  &CERROR(\\"IZO ioctl: inlbuf2 not 0 terminated\\\\n\\"); 1; } 0; });
    }' unless defined(&izo_ioctl_is_invalid);
}
1;
